/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.ComunicadoProducao;
import com.touchcomp.basementor.model.vo.FichaTecItemComProducao;
import com.touchcomp.basementor.model.vo.FormulacaoFases;
import com.touchcomp.basementor.model.vo.GradeFormulaProduto;
import com.touchcomp.basementor.model.vo.GradeItemComunicadoProducao;
import com.touchcomp.basementor.model.vo.ItemComProdOutrosCustos;
import com.touchcomp.basementor.model.vo.ItemComposicaoCusto;
import com.touchcomp.basementor.model.vo.ItemEmbalagemProducao;
import com.touchcomp.basementor.model.vo.ItemEventoOsProdSobEnc;
import com.touchcomp.basementor.model.vo.PreFaturamentoNFItem;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.Requisicao;
import com.touchcomp.basementor.model.vo.TipoProducao;
import com.touchcomp.basementor.model.vo.TiposDefeitos;
import com.touchcomp.basementor.model.vo.UnidadeMedida;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.Hibernate;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="ITEM_COMUNICADO_PRODUCAO")
public class ItemComunicadoProducao
implements InterfaceVO {
    private Long identificador;
    private Double valorAdCusto = 0.0;
    private Produto produto;
    private UnidadeMedida unidadeMedida;
    private ComunicadoProducao comunicadoProducao;
    private Double quantidadeTotal = 0.0;
    private Double quantidadeTotalRef = 0.0;
    private Double pesoBruto = 0.0;
    private Double pesoLiquido = 0.0;
    private Double pesoBrutoMatReq = 0.0;
    private Double pesoLiquidoMatReq = 0.0;
    private TipoProducao tipoProducao;
    private TiposDefeitos tiposDefeitos;
    private CentroCusto centroCusto;
    private List<ItemEmbalagemProducao> itemEmbProduzidas;
    private List<ItemComposicaoCusto> itemComposicaoCusto = new ArrayList<ItemComposicaoCusto>();
    private List<GradeItemComunicadoProducao> gradeItemComunicadoProducao;
    private CentroEstoque centroEstoque;
    private List<Requisicao> requisicoes;
    private List<FichaTecItemComProducao> fichasTecnicas;
    private Short contabilizavel = 1;
    private Double valorCustoMatPrima = 0.0;
    private Double valorCustoEmProcesso = 0.0;
    private Double valorCustoIndireto = 0.0;
    private Double valorOutrosCustos = 0.0;
    private Double valorCustoTotal = 0.0;
    private Double percentualCustoDesmanche = 100.0;
    private Double percentualCustoDesmancheConsiderado = 100.0;
    private List<ItemComProdOutrosCustos> itensOutrosCustos;
    private List<ItemEventoOsProdSobEnc> itemEventoOsProdSobEnc;
    private GradeFormulaProduto gradeFormulaProduto;
    private FormulacaoFases formulacaoFases;
    private PreFaturamentoNFItem preFaturamentoNFItem;
    private Double valorCustoFixo = 0.0;
    private String observacaoSistema;
    private Integer tipoExcAnaliseCusto = 0;
    private Short itemRefugoDesmanche = 0;

    public ItemComunicadoProducao() {
        this.itemEmbProduzidas = new ArrayList<ItemEmbalagemProducao>();
        this.gradeItemComunicadoProducao = new ArrayList<GradeItemComunicadoProducao>();
        this.requisicoes = new ArrayList<Requisicao>();
        this.fichasTecnicas = new ArrayList<FichaTecItemComProducao>();
        this.itensOutrosCustos = new ArrayList<ItemComProdOutrosCustos>();
        this.itemEventoOsProdSobEnc = new ArrayList<ItemEventoOsProdSobEnc>();
    }

    @Id
    @Column(name="ID_ITEM_COMUNICADO_PRODUCAO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ITEM_COMUNICADO_PRODUCAO")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Column(nullable=false, name="VALOR_AD_CUSTO", precision=15, scale=4)
    public Double getValorAdCusto() {
        return this.valorAdCusto;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PRODUTO", foreignKey=@ForeignKey(name="FK_ITEM_COMUNICADO_PROD_PROD"))
    public Produto getProduto() {
        return this.produto;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_UNIDADE_MEDIDA", foreignKey=@ForeignKey(name="FK_ITEM_COMUNICADO_PROD_UN"))
    public UnidadeMedida getUnidadeMedida() {
        return this.unidadeMedida;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COMUNICADO_PRODUCAO", foreignKey=@ForeignKey(name="FK_ITEM_COM_PROD_COMUNIC_PROD"))
    public ComunicadoProducao getComunicadoProducao() {
        return this.comunicadoProducao;
    }

    @Column(nullable=false, name="QUANTIDADE_TOTAL", precision=15, scale=6)
    public Double getQuantidadeTotal() {
        return this.quantidadeTotal;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_PRODUCAO", foreignKey=@ForeignKey(name="FK_ITEM_COM_PROD_TIPO_PROD"))
    public TipoProducao getTipoProducao() {
        return this.tipoProducao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_CUSTO", foreignKey=@ForeignKey(name="FK_ITEM_COMUNICADO_PRODUCAO_CC"))
    public CentroCusto getCentroCusto() {
        return this.centroCusto;
    }

    @OneToMany(mappedBy="itemComProducao", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    public List<ItemEmbalagemProducao> getItemEmbProduzidas() {
        return this.itemEmbProduzidas;
    }

    @OneToMany(mappedBy="itemComProducao", fetch=FetchType.LAZY, orphanRemoval=true)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ItemComposicaoCusto> getItemComposicaoCusto() {
        return this.itemComposicaoCusto;
    }

    @OneToMany(mappedBy="itemComunicadoProducao", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<GradeItemComunicadoProducao> getGradeItemComunicadoProducao() {
        return this.gradeItemComunicadoProducao;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setValorAdCusto(Double valorAdCusto) {
        this.valorAdCusto = valorAdCusto;
    }

    public void setProduto(Produto produto) {
        this.produto = produto;
    }

    public void setUnidadeMedida(UnidadeMedida unidadeMedida) {
        this.unidadeMedida = unidadeMedida;
    }

    public void setComunicadoProducao(ComunicadoProducao comunicadoProducao) {
        this.comunicadoProducao = comunicadoProducao;
    }

    public void setQuantidadeTotal(Double quantidadeTotal) {
        this.quantidadeTotal = quantidadeTotal;
    }

    public void setTipoProducao(TipoProducao tipoProducao) {
        this.tipoProducao = tipoProducao;
    }

    public void setCentroCusto(CentroCusto centroCusto) {
        this.centroCusto = centroCusto;
    }

    public void setItemEmbProduzidas(List<ItemEmbalagemProducao> itemEmbProduzidas) {
        this.itemEmbProduzidas = itemEmbProduzidas;
    }

    public void setItemComposicaoCusto(List<ItemComposicaoCusto> itemComposicaoCusto) {
        this.itemComposicaoCusto = itemComposicaoCusto;
    }

    public void setGradeItemComunicadoProducao(List<GradeItemComunicadoProducao> Grade) {
        this.gradeItemComunicadoProducao = Grade;
        if (Grade != null && Hibernate.isInitialized(Grade)) {
            Double qtdTotal = 0.0;
            Double qtdTotalRef = 0.0;
            for (GradeItemComunicadoProducao o : Grade) {
                GradeItemComunicadoProducao g = o;
                if (g.getQuantidade() != null) {
                    qtdTotal = qtdTotal + g.getQuantidade();
                }
                if (g.getQuantidadeReferencia() == null) continue;
                qtdTotalRef = qtdTotalRef + g.getQuantidadeReferencia();
            }
            this.setQuantidadeTotal(qtdTotal);
            this.setQuantidadeTotalRef(qtdTotalRef);
        } else {
            this.setQuantidadeTotal(0.0);
            this.setQuantidadeTotalRef(0.0);
        }
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return this.getProduto() != null ? ToolBaseMethodsVO.toString((String)"{0} - {1} Qntde: {2}", (Object[])new Object[]{this.getProduto().getIdentificador(), this.getProduto().getNome(), this.getQuantidadeTotal()}) : ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(updatable=false, name="ID_CENTRO_ESTOQUE", foreignKey=@ForeignKey(name="FK_ITEM_COM_PRODUCAO_CENT_EST"))
    public CentroEstoque getCentroEstoque() {
        return this.centroEstoque;
    }

    public void setCentroEstoque(CentroEstoque centroestoque) {
        this.centroEstoque = centroestoque;
    }

    @OneToMany(mappedBy="itemComunicadoProducao", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<Requisicao> getRequisicoes() {
        return this.requisicoes;
    }

    public void setRequisicoes(List<Requisicao> requisicoes) {
        this.requisicoes = requisicoes;
    }

    @Column(nullable=false, name="QUANTIDADE_TOTAL_REF", precision=15, scale=6)
    public Double getQuantidadeTotalRef() {
        return this.quantidadeTotalRef;
    }

    public void setQuantidadeTotalRef(Double quantidadeTotalRef) {
        this.quantidadeTotalRef = quantidadeTotalRef;
    }

    @OneToMany(mappedBy="itemComunicadoProducao")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<FichaTecItemComProducao> getFichasTecnicas() {
        return this.fichasTecnicas;
    }

    public void setFichasTecnicas(List<FichaTecItemComProducao> fichasTecnicas) {
        this.fichasTecnicas = fichasTecnicas;
    }

    @Column(name="CONTABILIZAVEL")
    public Short getContabilizavel() {
        return this.contabilizavel;
    }

    public void setContabilizavel(Short contabilizavel) {
        this.contabilizavel = contabilizavel;
    }

    @Column(name="VALOR_CUSTO_MAT_PRIMA")
    public Double getValorCustoMatPrima() {
        return this.valorCustoMatPrima;
    }

    public void setValorCustoMatPrima(Double valorCustoMatPrima) {
        this.valorCustoMatPrima = valorCustoMatPrima;
    }

    @Column(name="VALOR_CUSTO_EM_PROCESSO")
    public Double getValorCustoEmProcesso() {
        return this.valorCustoEmProcesso;
    }

    public void setValorCustoEmProcesso(Double valorCustoEmProcesso) {
        this.valorCustoEmProcesso = valorCustoEmProcesso;
    }

    @Column(name="VALOR_CUSTO_INDIRETO")
    public Double getValorCustoIndireto() {
        return this.valorCustoIndireto;
    }

    public void setValorCustoIndireto(Double valorCustoIndireto) {
        this.valorCustoIndireto = valorCustoIndireto;
    }

    @Column(name="VALOR_CUSTO_TOTAL")
    public Double getValorCustoTotal() {
        return this.valorCustoTotal;
    }

    public void setValorCustoTotal(Double valorCustoTotal) {
        this.valorCustoTotal = valorCustoTotal;
    }

    @Column(name="PERCENTUAL_CUSTO_DESMANCHE", precision=15, scale=6)
    public Double getPercentualCustoDesmanche() {
        return this.percentualCustoDesmanche;
    }

    public void setPercentualCustoDesmanche(Double percentualCustoDesmanche) {
        this.percentualCustoDesmanche = percentualCustoDesmanche;
    }

    @OneToMany(mappedBy="itemComunicadoProducao", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<ItemComProdOutrosCustos> getItensOutrosCustos() {
        return this.itensOutrosCustos;
    }

    public void setItensOutrosCustos(List<ItemComProdOutrosCustos> itensOutrosCustos) {
        this.itensOutrosCustos = itensOutrosCustos;
    }

    @OneToMany(mappedBy="itemComunicadoProducao", fetch=FetchType.LAZY)
    public List<ItemEventoOsProdSobEnc> getItemEventoOsProdSobEnc() {
        return this.itemEventoOsProdSobEnc;
    }

    public void setItemEventoOsProdSobEnc(List<ItemEventoOsProdSobEnc> itemEventoOsProdSobEnc) {
        this.itemEventoOsProdSobEnc = itemEventoOsProdSobEnc;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRADE_FORM_PRODUTO", foreignKey=@ForeignKey(name="FK_ITEM_COM_PROD_GR_FORM_PRO"))
    public GradeFormulaProduto getGradeFormulaProduto() {
        return this.gradeFormulaProduto;
    }

    public void setGradeFormulaProduto(GradeFormulaProduto gradeFormulaProduto) {
        this.gradeFormulaProduto = gradeFormulaProduto;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FORMULACAO_FASES", foreignKey=@ForeignKey(name="FK_ITEM_COM_PROD_FORM_FASES"))
    public FormulacaoFases getFormulacaoFases() {
        return this.formulacaoFases;
    }

    public void setFormulacaoFases(FormulacaoFases formulacaoFases) {
        this.formulacaoFases = formulacaoFases;
    }

    @Column(name="PERCENTUAL_CUSTO_DESM_CONSID")
    public Double getPercentualCustoDesmancheConsiderado() {
        return this.percentualCustoDesmancheConsiderado;
    }

    public void setPercentualCustoDesmancheConsiderado(Double percentualCustoDesmancheConsiderado) {
        this.percentualCustoDesmancheConsiderado = percentualCustoDesmancheConsiderado;
    }

    @OneToOne(mappedBy="itemComunicadoProducao", fetch=FetchType.LAZY)
    public PreFaturamentoNFItem getPreFaturamentoNFItem() {
        return this.preFaturamentoNFItem;
    }

    public void setPreFaturamentoNFItem(PreFaturamentoNFItem preFaturamentoNFItem) {
        this.preFaturamentoNFItem = preFaturamentoNFItem;
    }

    @Column(name="VR_CUSTO_FIXO")
    public Double getValorCustoFixo() {
        return this.valorCustoFixo;
    }

    public void setValorCustoFixo(Double valorCustoFixo) {
        this.valorCustoFixo = valorCustoFixo;
    }

    @Column(name="OBSERVACAO_SISTEMA", length=500)
    public String getObservacaoSistema() {
        return this.observacaoSistema;
    }

    public void setObservacaoSistema(String observacaoSistema) {
        this.observacaoSistema = observacaoSistema;
    }

    @Column(name="TIPO_EXCLUSAO_ANA_CUSTO")
    public Integer getTipoExcAnaliseCusto() {
        return this.tipoExcAnaliseCusto;
    }

    public void setTipoExcAnaliseCusto(Integer tipoExcAnaliseCusto) {
        this.tipoExcAnaliseCusto = tipoExcAnaliseCusto;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPOS_DEFEITOS", foreignKey=@ForeignKey(name="FK_ITEM_COM_PROD_TIPOS_DEFEITOS"))
    public TiposDefeitos getTiposDefeitos() {
        return this.tiposDefeitos;
    }

    public void setTiposDefeitos(TiposDefeitos tiposDefeitos) {
        this.tiposDefeitos = tiposDefeitos;
    }

    @Column(name="PESO_BRUTO")
    public Double getPesoBruto() {
        return this.pesoBruto;
    }

    public void setPesoBruto(Double pesoBruto) {
        this.pesoBruto = pesoBruto;
    }

    @Column(name="PESO_LIQUIDO")
    public Double getPesoLiquido() {
        return this.pesoLiquido;
    }

    public void setPesoLiquido(Double pesoLiquido) {
        this.pesoLiquido = pesoLiquido;
    }

    @Column(name="PESO_BRUTO_MAT_REQ")
    public Double getPesoBrutoMatReq() {
        return this.pesoBrutoMatReq;
    }

    public void setPesoBrutoMatReq(Double pesoBrutoMatReq) {
        this.pesoBrutoMatReq = pesoBrutoMatReq;
    }

    @Column(name="PESO_LIQUIDO_MAT_REQ")
    public Double getPesoLiquidoMatReq() {
        return this.pesoLiquidoMatReq;
    }

    public void setPesoLiquidoMatReq(Double pesoLiquidoMatReq) {
        this.pesoLiquidoMatReq = pesoLiquidoMatReq;
    }

    @Column(name="VALOR_OUTROS_CUSTOS")
    public Double getValorOutrosCustos() {
        return this.valorOutrosCustos;
    }

    public void setValorOutrosCustos(Double valorOutrosCustos) {
        this.valorOutrosCustos = valorOutrosCustos;
    }

    @Column(name="ITEM_REFUGO_DESMANCHE")
    public Short getItemRefugoDesmanche() {
        return this.itemRefugoDesmanche;
    }

    public void setItemRefugoDesmanche(Short itemRefugoDesmanche) {
        this.itemRefugoDesmanche = itemRefugoDesmanche;
    }
}

