/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ControleSolicitacaoServico;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.OrdemServico;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.SolicitacaoServico;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="ITEM_CONTROLE_SOL_SERVICO")
public class ItemControleSolicitacaoServico
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Empresa empresa;
    private Short aprovado = 1;
    private ControleSolicitacaoServico controleSolicitacaoServico;
    private SolicitacaoServico solicitacaoServico;
    private OrdemServico ordemServico;
    private String motivoReprovacao;
    private Pessoa autorizadorReprovacao;

    @Id
    @Column(nullable=false, name="ID_ITEM_CONTROLE_SOL_SERVICO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ITEM_CONTROLE_SOL_SERVICO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_ITEM_CONTROLE_SOL_SERV_EMP"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="APROVADA")
    public Short getAprovado() {
        return this.aprovado;
    }

    public void setAprovado(Short aprovado) {
        this.aprovado = aprovado;
    }

    @JoinColumn(name="ID_CONTROLE_SOL_SERVICO", foreignKey=@ForeignKey(name="FK_ITEM_CONTROLE_SOL_SERV_CON_S"))
    @ManyToOne(fetch=FetchType.LAZY)
    public ControleSolicitacaoServico getControleSolicitacaoServico() {
        return this.controleSolicitacaoServico;
    }

    public void setControleSolicitacaoServico(ControleSolicitacaoServico controleSolicitacaoServico) {
        this.controleSolicitacaoServico = controleSolicitacaoServico;
    }

    @JoinColumn(name="ID_SOLICITACAO_SERVICO", foreignKey=@ForeignKey(name="FK_ITEM_CONTROLE_SOL_SERV_SOL_S"))
    @ManyToOne(fetch=FetchType.LAZY)
    public SolicitacaoServico getSolicitacaoServico() {
        return this.solicitacaoServico;
    }

    public void setSolicitacaoServico(SolicitacaoServico solicitacaoServico) {
        this.solicitacaoServico = solicitacaoServico;
    }

    @JoinColumn(name="ID_ORDEM_SERVICO", foreignKey=@ForeignKey(name="FK_ITEM_CONTROLE_SOL_SERV_OS"))
    @Cascade(value={CascadeType.ALL})
    @ManyToOne(fetch=FetchType.LAZY)
    public OrdemServico getOrdemServico() {
        return this.ordemServico;
    }

    public void setOrdemServico(OrdemServico ordemServico) {
        this.ordemServico = ordemServico;
    }

    @Column(name="MOTIVO_REPROVACAO", length=500)
    public String getMotivoReprovacao() {
        return this.motivoReprovacao;
    }

    public void setMotivoReprovacao(String motivoReprovacao) {
        this.motivoReprovacao = motivoReprovacao;
    }

    @JoinColumn(name="ID_AUTORIZADOR", foreignKey=@ForeignKey(name="FK_ITEM_CONTROLE_SOL_SERV_AUTOR"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Pessoa getAutorizadorReprovacao() {
        return this.autorizadorReprovacao;
    }

    public void setAutorizadorReprovacao(Pessoa autorizadorReprovacao) {
        this.autorizadorReprovacao = autorizadorReprovacao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getMotivoReprovacao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

