/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.GradeItemImpSaldo;
import com.touchcomp.basementor.model.vo.ImplantacaoSaldos;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.UnidadeMedida;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.Hibernate;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

@Entity
@Table(name="ITEM_IMPLANTA_SALDO")
public class ItemImplantaSaldo
implements InterfaceVO {
    private Long identificador;
    private Produto produto;
    private UnidadeMedida unidadeMedida;
    private ImplantacaoSaldos implantacaoSaldos;
    private Double quantidadeTotal = 0.0;
    private List<GradeItemImpSaldo> gradeItem = new ArrayList<GradeItemImpSaldo>();
    private CentroEstoque centroEstoque;
    private Double valorUltCustoUnit = 0.0;
    private Double valorUnitario = 0.0;

    @Id
    @Column(name="ID_ITEM_IMPLANTA_SALDO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ITEM_IMPLANTA_SALDOS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PRODUTO", foreignKey=@ForeignKey(name="FK_ITEM_IMPLANTA_SALDO_PROD"))
    public Produto getProduto() {
        return this.produto;
    }

    public void setProduto(Produto produto) {
        this.produto = produto;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_UNIDADE_MEDIDA", foreignKey=@ForeignKey(name="FK_ITEM_IMPLANTA_SALDO_UN"))
    public UnidadeMedida getUnidadeMedida() {
        return this.unidadeMedida;
    }

    public void setUnidadeMedida(UnidadeMedida unidadeMedida) {
        this.unidadeMedida = unidadeMedida;
    }

    @Column(nullable=false, name="QUANTIDADE_TOTAL", precision=15, scale=6)
    public Double getQuantidadeTotal() {
        return this.quantidadeTotal;
    }

    public void setQuantidadeTotal(Double quantidadeTotal) {
        this.quantidadeTotal = quantidadeTotal;
    }

    @JoinColumn(name="ID_IMPLANTA_SALDOS", foreignKey=@ForeignKey(name="FK_ITEM_IMPLANTA_SALDO_IMPLANTA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public ImplantacaoSaldos getImplantacaoSaldos() {
        return this.implantacaoSaldos;
    }

    public void setImplantacaoSaldos(ImplantacaoSaldos implantacaoSaldos) {
        this.implantacaoSaldos = implantacaoSaldos;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToMany(mappedBy="itemImplantaSaldo", fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    @Fetch(value=FetchMode.SELECT)
    public List<GradeItemImpSaldo> getGradeItem() {
        return this.gradeItem;
    }

    public void setGradeItem(List<GradeItemImpSaldo> Grade) {
        this.gradeItem = Grade;
        if (Grade != null) {
            Double qtdTotal = 0.0;
            if (Hibernate.isInitialized(this.gradeItem)) {
                Iterator<GradeItemImpSaldo> iterator = Grade.iterator();
                while (iterator.hasNext()) {
                    GradeItemImpSaldo o;
                    GradeItemImpSaldo g = o = iterator.next();
                    qtdTotal = qtdTotal + g.getQuantidade();
                }
            }
            this.setQuantidadeTotal(qtdTotal);
        } else {
            this.setQuantidadeTotal(0.0);
        }
    }

    @JoinColumn(updatable=false, name="ID_CENTRO_ESTOQUE", foreignKey=@ForeignKey(name="FK_ITEM_IMPLANTA_SALDO_CENT_EST"))
    @ManyToOne(fetch=FetchType.LAZY)
    public CentroEstoque getCentroEstoque() {
        return this.centroEstoque;
    }

    public void setCentroEstoque(CentroEstoque centroestoque) {
        this.centroEstoque = centroestoque;
    }

    @Column(nullable=false, name="VALOR_UNITARIO", precision=15, scale=6)
    public Double getValorUnitario() {
        return this.valorUnitario;
    }

    public void setValorUnitario(Double valorUnitario) {
        this.valorUnitario = valorUnitario;
    }

    @Column(name="VALOR_ULT_CUSTO_UNIT", precision=15, scale=6)
    public Double getValorUltCustoUnit() {
        return this.valorUltCustoUnit;
    }

    public void setValorUltCustoUnit(Double valorUltCustoUnit) {
        this.valorUltCustoUnit = valorUltCustoUnit;
    }
}

