/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.annotations.tests.Ignore;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CarteiraCobranca;
import com.touchcomp.basementor.model.vo.LogTitulos;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="ITEM_LOG_DADOS_TITULO")
public class ItemLogDadosTitulo
implements InterfaceVO {
    private Long identificador;
    private LogTitulos logTitulos;
    private Long numeroTitulo;
    private Pessoa pessoa;
    private Short pagRec = 0;
    private Short provisao = 0;
    private Date dataEmissao;
    private Date dataVencimento;
    private Date dataVencimentoNovo;
    private CarteiraCobranca carteiraCobranca;
    private CarteiraCobranca carteiraCobrancaNovo;
    private Double valor = 0.0;
    private Double valorNovo = 0.0;
    private String observacao;
    private Date dataVencimentoBase;
    private Date dataVencimentoBaseNovo;
    private Date dataAnterior;
    private Date dataNova;
    private Double valorDescontoFincanceiroNovo = 0.0;
    private Double valorDescontoFincanceiroAnterior = 0.0;
    private Double percentualDescontoFincanceiroNovo = 0.0;

    @Id
    @Column(nullable=false, name="ID_ITEM_LOG_DADOS_TITULO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ITEM_LOG_DADOS_TITULO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @OneToOne(targetEntity=LogTitulos.class, fetch=FetchType.LAZY)
    @JoinColumn(name="ID_LOG_TITULOS", foreignKey=@ForeignKey(name="FK_ITEM_LOG_DADOS_TITULO_LOG_TI"))
    public LogTitulos getLogTitulos() {
        return this.logTitulos;
    }

    public void setLogTitulos(LogTitulos logTitulos) {
        this.logTitulos = logTitulos;
    }

    @Ignore
    @Column(name="NUMERO_TITULO")
    public Long getNumeroTitulo() {
        return this.numeroTitulo;
    }

    public void setNumeroTitulo(Long numeroTitulo) {
        this.numeroTitulo = numeroTitulo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_ITEM_LOG_DADOS_TITULO_PESSOA"))
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Column(name="PAG_REC")
    public Short getPagRec() {
        return this.pagRec;
    }

    public void setPagRec(Short pagRec) {
        this.pagRec = pagRec;
    }

    @Column(name="PROVISAO")
    public Short getProvisao() {
        return this.provisao;
    }

    public void setProvisao(Short provisao) {
        this.provisao = provisao;
    }

    @Column(name="DATA_EMISSAO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(Date dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    @Column(name="DATA_VENCIMENTO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataVencimento() {
        return this.dataVencimento;
    }

    public void setDataVencimento(Date dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    @Column(name="DATA_VENCIMENTO_NOVO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataVencimentoNovo() {
        return this.dataVencimentoNovo;
    }

    public void setDataVencimentoNovo(Date dataVencimentoNovo) {
        this.dataVencimentoNovo = dataVencimentoNovo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CARTEIRA_COBRANCA", foreignKey=@ForeignKey(name="FK_ITEM_LOG_DADOS_TITULO_CART_C"))
    public CarteiraCobranca getCarteiraCobranca() {
        return this.carteiraCobranca;
    }

    public void setCarteiraCobranca(CarteiraCobranca carteiraCobranca) {
        this.carteiraCobranca = carteiraCobranca;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CARTEIRA_COBRANCA_NOVO", foreignKey=@ForeignKey(name="FK_ITEM_LOG_DADOS_TITULO_CC_NOV"))
    public CarteiraCobranca getCarteiraCobrancaNovo() {
        return this.carteiraCobrancaNovo;
    }

    public void setCarteiraCobrancaNovo(CarteiraCobranca carteiraCobrancaNovo) {
        this.carteiraCobrancaNovo = carteiraCobrancaNovo;
    }

    @Column(nullable=false, name="VALOR", precision=15, scale=2)
    public Double getValor() {
        return this.valor;
    }

    public void setValor(Double valor) {
        this.valor = valor;
    }

    @Column(nullable=false, name="VALOR_NOVO", precision=15, scale=2)
    public Double getValorNovo() {
        return this.valorNovo;
    }

    public void setValorNovo(Double valorNovo) {
        this.valorNovo = valorNovo;
    }

    @Column(name="OBSERVACAO", length=1000)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Column(name="DATA_VENCIMENTO_BASE")
    @Temporal(value=TemporalType.DATE)
    public Date getDataVencimentoBase() {
        return this.dataVencimentoBase;
    }

    public void setDataVencimentoBase(Date dataVencimentoBase) {
        this.dataVencimentoBase = dataVencimentoBase;
    }

    @Column(name="DATA_VENCIMENTO_BASE_NOVO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataVencimentoBaseNovo() {
        return this.dataVencimentoBaseNovo;
    }

    public void setDataVencimentoBaseNovo(Date dataVencimentoBaseNovo) {
        this.dataVencimentoBaseNovo = dataVencimentoBaseNovo;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"Titulo: {0}", (Object[])new Object[]{this.getNumeroTitulo()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="DATA_ANTERIOR")
    @Temporal(value=TemporalType.DATE)
    public Date getDataAnterior() {
        return this.dataAnterior;
    }

    public void setDataAnterior(Date dataAnterior) {
        this.dataAnterior = dataAnterior;
    }

    @Column(name="DATA_NOVA")
    @Temporal(value=TemporalType.DATE)
    public Date getDataNova() {
        return this.dataNova;
    }

    public void setDataNova(Date dataNova) {
        this.dataNova = dataNova;
    }

    @Column(name="VALOR_DESC_FINC_NOVO")
    public Double getValorDescontoFincanceiroNovo() {
        return this.valorDescontoFincanceiroNovo;
    }

    public void setValorDescontoFincanceiroNovo(Double valorDescontoFincanceiroNovo) {
        this.valorDescontoFincanceiroNovo = valorDescontoFincanceiroNovo;
    }

    @Column(name="VALOR_DESC_FINC_ANTERIOR")
    public Double getValorDescontoFincanceiroAnterior() {
        return this.valorDescontoFincanceiroAnterior;
    }

    public void setValorDescontoFincanceiroAnterior(Double valorDescontoFincanceiroAnterior) {
        this.valorDescontoFincanceiroAnterior = valorDescontoFincanceiroAnterior;
    }

    @Column(name="PERC_DESCO_FINANCEIRO_NOVO")
    public Double getPercentualDescontoFincanceiroNovo() {
        return this.percentualDescontoFincanceiroNovo;
    }

    public void setPercentualDescontoFincanceiroNovo(Double percentualDescontoFincanceiroNovo) {
        this.percentualDescontoFincanceiroNovo = percentualDescontoFincanceiroNovo;
    }
}

