/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.interfaces.InterfaceVOReinf;
import com.touchcomp.basementor.model.vo.ApuracaoReinf;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ReinfNaturezaRendimento;
import com.touchcomp.basementor.model.vo.ReinfPreEvento;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="item_reinf_4020_nao_ident")
public class ItemReinf4020NaoIdentificado
implements InterfaceVO,
InterfaceVOReinf {
    private Long identificador;
    private ApuracaoReinf apuracao;
    private Empresa empresa;
    private String cpf;
    private Double valorBruto = 0.0;
    private Double baseCsll = 0.0;
    private Double valorCsll = 0.0;
    private Double baseCofins = 0.0;
    private Double valorCofins = 0.0;
    private Double basePis = 0.0;
    private Double valorPis = 0.0;
    private Double baseAgregado = 0.0;
    private Double valorAgregado = 0.0;
    private Double baseIrrf = 0.0;
    private Double valorIrrf = 0.0;
    private ReinfNaturezaRendimento naturezaRendimento;
    private List<ReinfPreEvento> preEventosReinf;
    private Date dataPagamento;

    public ItemReinf4020NaoIdentificado() {
        this.preEventosReinf = new ArrayList<ReinfPreEvento>();
    }

    public ItemReinf4020NaoIdentificado(Empresa empresa) {
        this.empresa = empresa;
        this.preEventosReinf = new ArrayList<ReinfPreEvento>();
    }

    @Id
    @Column(nullable=false, unique=true, name="ID_REINF_4020_NAO_IDENT")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_REINF_4020_NAO_IDENT")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_APURACAO_REINF", foreignKey=@ForeignKey(name="FK_ITEM_REINF_4020_REINF"))
    public ApuracaoReinf getApuracao() {
        return this.apuracao;
    }

    public void setApuracao(ApuracaoReinf apuracao) {
        this.apuracao = apuracao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_ITEM_REINF_4020_EMP"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="base_csll")
    public Double getBaseCsll() {
        return this.baseCsll;
    }

    public void setBaseCsll(Double baseCsll) {
        this.baseCsll = baseCsll;
    }

    @Column(name="valor_csll")
    public Double getValorCsll() {
        return this.valorCsll;
    }

    public void setValorCsll(Double valorCsll) {
        this.valorCsll = valorCsll;
    }

    @Column(name="base_cofins")
    public Double getBaseCofins() {
        return this.baseCofins;
    }

    public void setBaseCofins(Double baseCofins) {
        this.baseCofins = baseCofins;
    }

    @Column(name="valor_cofins")
    public Double getValorCofins() {
        return this.valorCofins;
    }

    public void setValorCofins(Double valorCofins) {
        this.valorCofins = valorCofins;
    }

    @Column(name="base_pis")
    public Double getBasePis() {
        return this.basePis;
    }

    public void setBasePis(Double basePis) {
        this.basePis = basePis;
    }

    @Column(name="valor_pis")
    public Double getValorPis() {
        return this.valorPis;
    }

    public void setValorPis(Double valorPis) {
        this.valorPis = valorPis;
    }

    @Column(name="base_agregado")
    public Double getBaseAgregado() {
        return this.baseAgregado;
    }

    public void setBaseAgregado(Double baseAgregado) {
        this.baseAgregado = baseAgregado;
    }

    @Column(name="valor_agregado")
    public Double getValorAgregado() {
        return this.valorAgregado;
    }

    public void setValorAgregado(Double valorAgregado) {
        this.valorAgregado = valorAgregado;
    }

    @Column(name="base_irrf")
    public Double getBaseIrrf() {
        return this.baseIrrf;
    }

    public void setBaseIrrf(Double baseIrrf) {
        this.baseIrrf = baseIrrf;
    }

    @Column(name="valor_irrf")
    public Double getValorIrrf() {
        return this.valorIrrf;
    }

    public void setValorIrrf(Double valorIrrf) {
        this.valorIrrf = valorIrrf;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NATUREZA_RENDIMENTO", foreignKey=@ForeignKey(name="FK_ITEM_NAT_RENDIMENTO_4020"))
    public ReinfNaturezaRendimento getNaturezaRendimento() {
        return this.naturezaRendimento;
    }

    public void setNaturezaRendimento(ReinfNaturezaRendimento naturezaRendimento) {
        this.naturezaRendimento = naturezaRendimento;
    }

    @Column(name="cpf")
    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String cpf) {
        this.cpf = cpf;
    }

    @Column(name="valor_bruto")
    public Double getValorBruto() {
        return this.valorBruto;
    }

    public void setValorBruto(Double valorBruto) {
        this.valorBruto = valorBruto;
    }

    @Override
    @OneToMany(mappedBy="itemReinfNaoId", fetch=FetchType.LAZY)
    public List<ReinfPreEvento> getPreEventosReinf() {
        return this.preEventosReinf;
    }

    public void setPreEventosReinf(List<ReinfPreEvento> preEventosReinf) {
        this.preEventosReinf = preEventosReinf;
    }

    @Column(name="data_pagamento")
    @Temporal(value=TemporalType.DATE)
    public Date getDataPagamento() {
        return this.dataPagamento;
    }

    public void setDataPagamento(Date dataPagamento) {
        this.dataPagamento = dataPagamento;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

