/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.GradeItemRequisicao;
import com.touchcomp.basementor.model.vo.NaturezaRequisicao;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.Requisicao;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="ITEM_REQUISICAO")
public class ItemRequisicao
implements InterfaceVO {
    private Long identificador;
    private Requisicao requisicao;
    private Produto produto;
    private Double quantidadeTotal = 0.0;
    private CentroCusto centroCusto;
    private List<GradeItemRequisicao> gradeItemRequisicao = new ArrayList<GradeItemRequisicao>();
    private CentroEstoque centroEstoque;
    private NaturezaRequisicao naturezaRequisicao;
    private Produto produtoSubstituto;
    private String observacoes;
    private Double valorPrecoMedioCont = 0.0;
    private Produto produtoOriginal;

    @Id
    @Column(nullable=false, name="ID_ITEM_REQUISICAO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ITEM_REQUISICAO")
    public Long getIdentificador() {
        return this.identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_REQUISICAO", foreignKey=@ForeignKey(name="FK_ITEM_REQUISICAO_REQUISICAO"))
    public Requisicao getRequisicao() {
        return this.requisicao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_PRODUTO", foreignKey=@ForeignKey(name="FK_ITEM_REQUISICAO_PRODUTO"))
    public Produto getProduto() {
        return this.produto;
    }

    @Column(nullable=false, name="QUANTIDADE_TOTAL", precision=12, scale=2)
    public Double getQuantidadeTotal() {
        return this.quantidadeTotal;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_CUSTO", foreignKey=@ForeignKey(name="FK_ITEM_REQUISICAO_CC"))
    public CentroCusto getCentroCusto() {
        return this.centroCusto;
    }

    @OneToMany(mappedBy="itemRequisicao", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<GradeItemRequisicao> getGradeItemRequisicao() {
        return this.gradeItemRequisicao;
    }

    public void setCentroCusto(CentroCusto centroCusto) {
        this.centroCusto = centroCusto;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setProduto(Produto produto) {
        this.produto = produto;
    }

    public void setQuantidadeTotal(Double quantidadeTotal) {
        this.quantidadeTotal = quantidadeTotal;
    }

    public void setRequisicao(Requisicao requisicao) {
        this.requisicao = requisicao;
    }

    public void setGradeItemRequisicao(List<GradeItemRequisicao> gradeItemRequisicao) {
        this.gradeItemRequisicao = gradeItemRequisicao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(updatable=false, name="ID_CENTRO_ESTOQUE", foreignKey=@ForeignKey(name="FK_ITEM_REQUISICAO_CENTRO_ESTOQ"))
    public CentroEstoque getCentroEstoque() {
        return this.centroEstoque;
    }

    public void setCentroEstoque(CentroEstoque centroestoque) {
        this.centroEstoque = centroestoque;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NATUREZA_REQUISICAO", foreignKey=@ForeignKey(name="FK_ITEM_REQUISICAO_NAT_REQUISIC"))
    public NaturezaRequisicao getNaturezaRequisicao() {
        return this.naturezaRequisicao;
    }

    public void setNaturezaRequisicao(NaturezaRequisicao naturezaRequisicao) {
        this.naturezaRequisicao = naturezaRequisicao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PRODUTO_SUBSTITUTO", foreignKey=@ForeignKey(name="FK_ITEM_REQUISICAO_PROD_SUBST"))
    public Produto getProdutoSubstituto() {
        return this.produtoSubstituto;
    }

    public void setProdutoSubstituto(Produto produtoSubstituto) {
        this.produtoSubstituto = produtoSubstituto;
    }

    @Column(name="OBSERVACOES", length=500)
    public String getObservacoes() {
        return this.observacoes;
    }

    public void setObservacoes(String observacoes) {
        this.observacoes = observacoes;
    }

    @Column(name="VALOR_PRECO_MEDIO_CONT", precision=15, scale=6)
    public Double getValorPrecoMedioCont() {
        return this.valorPrecoMedioCont;
    }

    public void setValorPrecoMedioCont(Double valorPrecoMedioCont) {
        this.valorPrecoMedioCont = valorPrecoMedioCont;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PRODUTO_ORIGINAL", foreignKey=@ForeignKey(name="FK_ITEM_REQUISICAO_PRODUTO_ORIG"))
    public Produto getProdutoOriginal() {
        return this.produtoOriginal;
    }

    public void setProdutoOriginal(Produto produtoOriginal) {
        this.produtoOriginal = produtoOriginal;
    }
}

