/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.annotations.tests.Ignore;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumProvisionamentoLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumTipoLancamentoCTBGerencial;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="LANCAMENTO_CTB_GERENCIAL")
public class LancamentoCtbGerencial
implements InterfaceVO {
    private Long identificador;
    private Short debCred;
    private Double valor = 0.0;
    private String historico;
    private CentroCusto centroCusto;
    private PlanoContaGerencial planoContaGerencial;
    private Date dataCadastro;
    private Date dataAtualizacao;
    private Empresa empresa;
    private Short gerado = EnumConstantsMentorSimNao.SIM.getValue();
    private Short provRealizado = EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getValue();
    private Short tipoLancamento;
    private Date dataPrevista;
    private Long idLancOrigem;

    public LancamentoCtbGerencial() {
        this.debCred = EnumLancamentoCTBGerencial.DEBITO.getValue();
        this.tipoLancamento = EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue();
    }

    @Id
    @Column(name="ID_LANCAMENTO_CTB_GERENCIAL")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_LANCAMENTO_CTB_GERENCIAL")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DEB_CRED")
    public Short getDebCred() {
        return this.debCred;
    }

    public void setDebCred(Short debCred) {
        this.debCred = debCred;
    }

    @Column(name="VALOR", precision=12, scale=2)
    public Double getValor() {
        return this.valor;
    }

    public void setValor(Double valor) {
        this.valor = valor;
    }

    @Column(name="HISTORICO", length=1000)
    public String getHistorico() {
        return this.historico;
    }

    public void setHistorico(String historico) {
        this.historico = historico;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_CUSTO", foreignKey=@ForeignKey(name="FK_LANCAMENTO_CTB_GER_CC"))
    public CentroCusto getCentroCusto() {
        return this.centroCusto;
    }

    public void setCentroCusto(CentroCusto centroCusto) {
        this.centroCusto = centroCusto;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_GERENCIAL", foreignKey=@ForeignKey(name="FK_LANCAMENTO_CTB_GER_PC_GER"))
    public PlanoContaGerencial getPlanoContaGerencial() {
        return this.planoContaGerencial;
    }

    public void setPlanoContaGerencial(PlanoContaGerencial planoContaGerencial) {
        this.planoContaGerencial = planoContaGerencial;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_ATUALIZACAO")
    public Date getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Date dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_LANCAMENTO_CTB_GER_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="GERADO")
    public Short getGerado() {
        return this.gerado;
    }

    public void setGerado(Short gerado) {
        this.gerado = gerado;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="PROV_REALIZADO")
    public Short getProvRealizado() {
        return this.provRealizado;
    }

    public void setProvRealizado(Short provisionado) {
        this.provRealizado = provisionado;
    }

    @Column(name="TIPO_LANCAMENTO")
    public Short getTipoLancamento() {
        return this.tipoLancamento;
    }

    public void setTipoLancamento(Short tipoLancamento) {
        this.tipoLancamento = tipoLancamento;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_PREVISTA")
    public Date getDataPrevista() {
        return this.dataPrevista;
    }

    public void setDataPrevista(Date dataPrevista) {
        this.dataPrevista = dataPrevista;
    }

    @Ignore
    @Column(name="ID_LANC_ORIGEM")
    public Long getIdLancOrigem() {
        return this.idLancOrigem;
    }

    public void setIdLancOrigem(Long idLancOrigem) {
        this.idLancOrigem = idLancOrigem;
    }
}

