/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.LeadTimeFornProdutoInfFiscal;
import com.touchcomp.basementor.model.vo.LeadTimeFornecedor;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="LEAD_TIME_FORN_PRODUTO")
public class LeadTimeFornProduto
implements InterfaceVO {
    private Long identificador;
    private Integer leadTime = 0;
    private Short aquisicaoPreferencial = 0;
    private LeadTimeFornecedor leadTimeFornecedor;
    private GradeCor gradeCor;
    private Date ultimaEntrada;
    private List<LeadTimeFornProdutoInfFiscal> infFiscalLeadTime = new ArrayList<LeadTimeFornProdutoInfFiscal>();
    private Integer leadTimeEmissao = 0;
    private Integer leadTimePrevFaturamento = 0;
    private Integer leadTimePrevChegada = 0;
    private Short homologado = 0;

    @Id
    @Column(name="ID_LEAD_TIME_FORN_PRODUTO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_LEAD_TIME_FORN_PRODUTO")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Column(name="LEAD_TIME")
    public Integer getLeadTime() {
        return this.leadTime;
    }

    @Column(name="AQUISICAO_PREFERENCIAL")
    public Short getAquisicaoPreferencial() {
        return this.aquisicaoPreferencial;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_LEAD_TIME_FORNECEDOR", foreignKey=@ForeignKey(name="FK_LEAD_TIME_FORN_PROD_LEAD_T_F"))
    public LeadTimeFornecedor getLeadTimeFornecedor() {
        return this.leadTimeFornecedor;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setLeadTime(Integer leadTime) {
        this.leadTime = leadTime;
    }

    public void setAquisicaoPreferencial(Short aquisicaoPreferencial) {
        this.aquisicaoPreferencial = aquisicaoPreferencial;
    }

    public void setLeadTimeFornecedor(LeadTimeFornecedor leadTimeFornecedor) {
        this.leadTimeFornecedor = leadTimeFornecedor;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @JoinColumn(name="ID_GRADE_COR", foreignKey=@ForeignKey(name="FK_LEAD_TIME_FORN_PRODUTO_GC"))
    @ManyToOne(fetch=FetchType.LAZY)
    public GradeCor getGradeCor() {
        return this.gradeCor;
    }

    public void setGradeCor(GradeCor gradeCor) {
        this.gradeCor = gradeCor;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="ULTIMA_ENTRADA")
    public Date getUltimaEntrada() {
        return this.ultimaEntrada;
    }

    public void setUltimaEntrada(Date ultimaEntrada) {
        this.ultimaEntrada = ultimaEntrada;
    }

    @OneToMany(mappedBy="leadTimeFornProduto")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<LeadTimeFornProdutoInfFiscal> getInfFiscalLeadTime() {
        return this.infFiscalLeadTime;
    }

    public void setInfFiscalLeadTime(List<LeadTimeFornProdutoInfFiscal> infFiscalLeadTime) {
        this.infFiscalLeadTime = infFiscalLeadTime;
    }

    @Column(name="LEAD_TIME_EMISSAO")
    public Integer getLeadTimeEmissao() {
        return this.leadTimeEmissao;
    }

    public void setLeadTimeEmissao(Integer leadTimeEmissao) {
        this.leadTimeEmissao = leadTimeEmissao;
    }

    @Column(name="LEAD_TIME_PREV_FAT")
    public Integer getLeadTimePrevFaturamento() {
        return this.leadTimePrevFaturamento;
    }

    public void setLeadTimePrevFaturamento(Integer leadTimePrevFaturamento) {
        this.leadTimePrevFaturamento = leadTimePrevFaturamento;
    }

    @Column(name="LEAD_TIME_PREV_CHEG")
    public Integer getLeadTimePrevChegada() {
        return this.leadTimePrevChegada;
    }

    public void setLeadTimePrevChegada(Integer leadTimePrevChegada) {
        this.leadTimePrevChegada = leadTimePrevChegada;
    }

    @Column(name="HOMOLOGADO")
    public Short getHomologado() {
        return this.homologado;
    }

    public void setHomologado(Short homologado) {
        this.homologado = homologado;
    }
}

