/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.LiberacaoNecCompraItem;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="LIBERACAO_NEC_COMPRA")
public class LiberacaoNecCompra
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Empresa empresa;
    private Usuario usuarioLiberacao;
    private List<LiberacaoNecCompraItem> itensLiberacao = new ArrayList<LiberacaoNecCompraItem>();

    @Id
    @Column(name="ID_LIBERACAO_NEC_COMPRA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_LIBERACAO_NEC_COMPRA")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_LIBERACAO_NEC_COMPRA_EMP"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO_LIBERACAO", foreignKey=@ForeignKey(name="FK_LIBERACAO_NEC_COMPRA_USER"))
    public Usuario getUsuarioLiberacao() {
        return this.usuarioLiberacao;
    }

    public void setUsuarioLiberacao(Usuario usuarioLiberacao) {
        this.usuarioLiberacao = usuarioLiberacao;
    }

    @OneToMany(mappedBy="liberacaoNecCompra")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<LiberacaoNecCompraItem> getItensLiberacao() {
        return this.itensLiberacao;
    }

    public void setItensLiberacao(List<LiberacaoNecCompraItem> itensLiberacao) {
        this.itensLiberacao = itensLiberacao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return this.getUsuarioLiberacao() != null ? ToolBaseMethodsVO.toString((String)"Liberacao numero: {0} Usuario: {1}", (Object[])new Object[]{this.getIdentificador(), this.getUsuarioLiberacao()}) : ToolBaseMethodsVO.toString((String)"Liberacao numero: {0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

