/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.annotations.tests.Ignore;
import com.touchcomp.basementor.constants.enums.relpessoacontato.EnumConstTicketAtendStatus;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.LocalTicketAtSolReab;
import com.touchcomp.basementor.model.vo.LocalTicketAtendNotaTouch;
import com.touchcomp.basementor.model.vo.LocalTicketAtendPrevisoes;
import com.touchcomp.basementor.model.vo.LocalTicketAtendTouchFile;
import com.touchcomp.basementor.model.vo.LocalTicketAtendTouchLog;
import com.touchcomp.basementor.model.vo.Nodo;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="LOCAL_TICKET_ATEND_TOUCH")
public class LocalTicketAtendTouch
implements InterfaceVO {
    private Long identificador;
    private Long nrProtocolo;
    private Usuario usuario;
    private Empresa empresa;
    private String email;
    private String observacao;
    private Date dataCadastro;
    private Date dataAtualizacao;
    private Nodo nodo;
    private Short status;
    private Date dataPrevista;
    private Date dataFechamento;
    private String dadosAtendimento;
    private String codigoVersao;
    private List<LocalTicketAtendTouchFile> arquivos = new ArrayList<LocalTicketAtendTouchFile>();
    private List<LocalTicketAtendTouchLog> logsAtendimento;
    private List<LocalTicketAtSolReab> solicitacoesReabertura;
    private List<LocalTicketAtendPrevisoes> logsPrevisoes;
    private String solucao;
    private Short versaoTicket = 0;
    private LocalTicketAtendNotaTouch notaAtendimento;

    public LocalTicketAtendTouch() {
        this.status = EnumConstTicketAtendStatus.ABERTO.getValue();
        this.logsAtendimento = new ArrayList<LocalTicketAtendTouchLog>();
        this.arquivos = new ArrayList<LocalTicketAtendTouchFile>();
        this.solicitacoesReabertura = new ArrayList<LocalTicketAtSolReab>();
        this.logsPrevisoes = new ArrayList<LocalTicketAtendPrevisoes>();
    }

    @Id
    @Column(nullable=false, name="ID_LOCAL_TICKET_ATEND_TOUCH")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_LOCAL_TICKET_ATEND_TOUCH")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Ignore
    @Column(name="NR_PROTOCOLO")
    public Long getNrProtocolo() {
        return this.nrProtocolo;
    }

    public void setNrProtocolo(Long nrProtocolo) {
        this.nrProtocolo = nrProtocolo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_LOCAL_TICKET_ATEND_TOUCH_USE"))
    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_LOCAL_TICKET_ATEND_TOUCH_EM"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="EMAIL", length=300)
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Column(name="OBSERVACAO", length=1000)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NODO", foreignKey=@ForeignKey(name="FK_LOCAL_TICKET_ATEND_TOUCH_NDO"))
    public Nodo getNodo() {
        return this.nodo;
    }

    public void setNodo(Nodo nodo) {
        this.nodo = nodo;
    }

    @Column(name="STATUS")
    public Short getStatus() {
        return this.status;
    }

    public void setStatus(Short status) {
        this.status = status;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_PREVISAO")
    public Date getDataPrevista() {
        return this.dataPrevista;
    }

    public void setDataPrevista(Date dataPrevista) {
        this.dataPrevista = dataPrevista;
    }

    @Column(name="DADOS_ATENDIMENTO", length=2000)
    public String getDadosAtendimento() {
        return this.dadosAtendimento;
    }

    public void setDadosAtendimento(String dadosAtendimento) {
        this.dadosAtendimento = dadosAtendimento;
    }

    @Column(name="CODIGO_VERSAO", length=50)
    public String getCodigoVersao() {
        return this.codigoVersao;
    }

    public void setCodigoVersao(String codigoVersao) {
        this.codigoVersao = codigoVersao;
    }

    @OneToMany(mappedBy="localTicketAtendTouch")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<LocalTicketAtendTouchFile> getArquivos() {
        return this.arquivos;
    }

    public void setArquivos(List<LocalTicketAtendTouchFile> arquivos) {
        this.arquivos = arquivos;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getObservacao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToMany(mappedBy="localTicketAtendTouch")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<LocalTicketAtendTouchLog> getLogsAtendimento() {
        return this.logsAtendimento;
    }

    public void setLogsAtendimento(List<LocalTicketAtendTouchLog> logsAtendimento) {
        this.logsAtendimento = logsAtendimento;
    }

    @Column(name="SOLUCAO", length=5000)
    public String getSolucao() {
        return this.solucao;
    }

    public void setSolucao(String solucao) {
        this.solucao = solucao;
    }

    @Column(name="VERSAO_TICKET")
    public Short getVersaoTicket() {
        return this.versaoTicket;
    }

    public void setVersaoTicket(Short versaoTicket) {
        this.versaoTicket = versaoTicket;
    }

    public void setNotaAtendimento(LocalTicketAtendNotaTouch notaAtendimento) {
        this.notaAtendimento = notaAtendimento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NOTA_ATENDIMENTO", foreignKey=@ForeignKey(name="FK_LOCAL_TICKET_ATEND_TOUCH_NOT"))
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public LocalTicketAtendNotaTouch getNotaAtendimento() {
        return this.notaAtendimento;
    }

    @OneToMany(mappedBy="localTicketAtendTouch")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<LocalTicketAtSolReab> getSolicitacoesReabertura() {
        return this.solicitacoesReabertura;
    }

    public void setSolicitacoesReabertura(List<LocalTicketAtSolReab> solicitacoesReabertura) {
        this.solicitacoesReabertura = solicitacoesReabertura;
    }

    @OneToMany(mappedBy="localTicketAtendTouch")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<LocalTicketAtendPrevisoes> getLogsPrevisoes() {
        return this.logsPrevisoes;
    }

    public void setLogsPrevisoes(List<LocalTicketAtendPrevisoes> logsPrevisoes) {
        this.logsPrevisoes = logsPrevisoes;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_FECHAMENTO")
    public Date getDataFechamento() {
        return this.dataFechamento;
    }

    public void setDataFechamento(Date dataFechamento) {
        this.dataFechamento = dataFechamento;
    }

    @Version
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_ATUALIZACAO")
    public Date getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Date dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }
}

