/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ClienteFinanceiro;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="LOG_DADOS_FINAN_CLIENTE")
public class LogDadosFinanceirosCliente
implements InterfaceVO {
    private Long identificador;
    private Short naoAvaliarFinanceiro = 0;
    private Integer habilParaCompra = 0;
    private Double limiteCredito = 0.0;
    private Double limiteCreditoFinanceiro = 0.0;
    private Date dataLiberacaoCredito;
    private Integer diasVigorLimiteCred = 0;
    private ClienteFinanceiro clienteFinanceiro;
    private Timestamp dataAlteracao;
    private Usuario usuario;

    @Id
    @Column(name="ID_LOG_DADOS_FINAN_CLIENTE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_LOG_DADOS_FINAN_CLIENTE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="NAO_AVALIAR_FINANCEIRO")
    public Short getNaoAvaliarFinanceiro() {
        return this.naoAvaliarFinanceiro;
    }

    public void setNaoAvaliarFinanceiro(Short naoAvaliarFinanceiro) {
        this.naoAvaliarFinanceiro = naoAvaliarFinanceiro;
    }

    @Column(name="HABIL_PARA_COMPRA")
    public Integer getHabilParaCompra() {
        return this.habilParaCompra;
    }

    public void setHabilParaCompra(Integer habilParaCompra) {
        this.habilParaCompra = habilParaCompra;
    }

    @Column(name="LIMITE_CREDITO", precision=15, scale=2)
    public Double getLimiteCredito() {
        return this.limiteCredito;
    }

    public void setLimiteCredito(Double limiteCredito) {
        this.limiteCredito = limiteCredito;
    }

    @Column(name="LIMITE_CREDITO_FINANCEIRO", precision=15, scale=2)
    public Double getLimiteCreditoFinanceiro() {
        return this.limiteCreditoFinanceiro;
    }

    public void setLimiteCreditoFinanceiro(Double limiteCreditoFinanceiro) {
        this.limiteCreditoFinanceiro = limiteCreditoFinanceiro;
    }

    @Column(name="DATA_LIBERACAO_CREDITO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataLiberacaoCredito() {
        return this.dataLiberacaoCredito;
    }

    public void setDataLiberacaoCredito(Date dataLiberacaoCredito) {
        this.dataLiberacaoCredito = dataLiberacaoCredito;
    }

    @Column(name="DIAS_VIGOR_LIMITE_CRED")
    public Integer getDiasVigorLimiteCred() {
        return this.diasVigorLimiteCred;
    }

    public void setDiasVigorLimiteCred(Integer diasVigorLimiteCred) {
        this.diasVigorLimiteCred = diasVigorLimiteCred;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLIENTE_FINANCEIRO", foreignKey=@ForeignKey(name="FK_LOG_DADOS_FINAN_CLI_CLI_FIN"))
    public ClienteFinanceiro getClienteFinanceiro() {
        return this.clienteFinanceiro;
    }

    public void setClienteFinanceiro(ClienteFinanceiro clienteFinanceiro) {
        this.clienteFinanceiro = clienteFinanceiro;
    }

    @Column(name="DATA_ALTERACAO")
    public Timestamp getDataAlteracao() {
        return this.dataAlteracao;
    }

    public void setDataAlteracao(Timestamp dataAlteracao) {
        this.dataAlteracao = dataAlteracao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_LOG_DADOS_FINAN_CLI_USUARIO"))
    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

