/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.OcorrenciaRetornoCnab;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="LOG_TITULO_CNAB")
public class LogTituloCnab
implements InterfaceVO {
    private Long identificador;
    private Titulo titulo;
    private OcorrenciaRetornoCnab ocorrenciaRetorno;
    private Date dataCadastro;
    private String codMovimentoRetorno;
    private String descMovimentoRetorno;
    private String codOcorrencia;
    private String motivoOcorrencia;
    private Double valorTarifa = 0.0;
    private Short rejeitado = 0;

    @Id
    @Column(name="ID_LOG_TITULO_CNAB")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_LOG_TITULO_CNAB")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TITULO", foreignKey=@ForeignKey(name="FK_LOG_TITULO_CNAB_TITULO"))
    public Titulo getTitulo() {
        return this.titulo;
    }

    public void setTitulo(Titulo titulo) {
        this.titulo = titulo;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_OCORRENCIA_RETORNO_CNAB", foreignKey=@ForeignKey(name="FK_LOG_TITULO_CNAB_OCO_RET_CNAB"))
    public OcorrenciaRetornoCnab getOcorrenciaRetorno() {
        return this.ocorrenciaRetorno;
    }

    public void setOcorrenciaRetorno(OcorrenciaRetornoCnab ocorrenciaRetorno) {
        this.ocorrenciaRetorno = ocorrenciaRetorno;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Column(name="COD_MOV_RETORNO", length=10)
    public String getCodMovimentoRetorno() {
        return this.codMovimentoRetorno;
    }

    public void setCodMovimentoRetorno(String codMovimentoRetorno) {
        this.codMovimentoRetorno = codMovimentoRetorno;
    }

    @Column(name="DESC_MOV_RETORNO", length=1000)
    public String getDescMovimentoRetorno() {
        return this.descMovimentoRetorno;
    }

    public void setDescMovimentoRetorno(String descMovimentoRetorno) {
        this.descMovimentoRetorno = descMovimentoRetorno;
    }

    @Column(name="COD_OCORRENCIA", length=10)
    public String getCodOcorrencia() {
        return this.codOcorrencia;
    }

    public void setCodOcorrencia(String codOcorrencia) {
        this.codOcorrencia = codOcorrencia;
    }

    @Column(name="MOTIVO_OCORRENCIA", length=1000)
    public String getMotivoOcorrencia() {
        return this.motivoOcorrencia;
    }

    public void setMotivoOcorrencia(String motivoOcorrencia) {
        this.motivoOcorrencia = motivoOcorrencia;
    }

    @Column(name="VALOR_TARIFA", precision=15, scale=2)
    public Double getValorTarifa() {
        return this.valorTarifa;
    }

    public void setValorTarifa(Double valorTarifa) {
        this.valorTarifa = valorTarifa;
    }

    @Column(name="REJEITADO")
    public Short getRejeitado() {
        return this.rejeitado;
    }

    public void setRejeitado(Short rejeitado) {
        this.rejeitado = rejeitado;
    }
}

