/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Cte;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.PeriodoEmissaoCTe;
import com.touchcomp.basementor.model.vo.VersaoCTe;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="LOTE_FATURAMENTO_CTE")
public class LoteFaturamentoCTe
implements InterfaceVO {
    private Long identificador;
    private Date dataEmissao;
    private String numeroReciboLote;
    private List<Cte> ctes = new ArrayList<Cte>();
    private Short enviadoReceita = 0;
    private Short statusLote = 0;
    private String motivo;
    private Timestamp dataAtualizacao;
    private Date dataEnvio;
    private PeriodoEmissaoCTe periodoEmissaoCte;
    private VersaoCTe versaoCTe;
    private Empresa empresa;

    @Id
    @Column(name="ID_LOTE_FATURAMENTO_CTE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_LOTE_FATURAMENTO_CTE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_EMISSAO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(Date dataEntradaSaida) {
        this.dataEmissao = dataEntradaSaida;
    }

    @OneToMany(fetch=FetchType.EAGER, mappedBy="loteFaturamentoCTe", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    public List<Cte> getCtes() {
        return this.ctes;
    }

    public void setCtes(List<Cte> ctes) {
        this.ctes = ctes;
    }

    @Column(name="NUMERO_RECIBO_LOTE", length=15)
    public String getNumeroReciboLote() {
        return this.numeroReciboLote;
    }

    public void setNumeroReciboLote(String numeroReciboLote) {
        this.numeroReciboLote = numeroReciboLote;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="STATUS_LOTE")
    public Short getStatusLote() {
        return this.statusLote;
    }

    public void setStatusLote(Short statusLote) {
        this.statusLote = statusLote;
    }

    @Column(name="DATA_ENVIO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataEnvio() {
        return this.dataEnvio;
    }

    public void setDataEnvio(Date dataEnvio) {
        this.dataEnvio = dataEnvio;
    }

    @Column(name="MOTIVO", length=255)
    public String getMotivo() {
        return this.motivo;
    }

    public void setMotivo(String motivo) {
        this.motivo = motivo;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="ENVIADO_RECEITA")
    public Short getEnviadoReceita() {
        return this.enviadoReceita;
    }

    public void setEnviadoReceita(Short enviadoReceita) {
        this.enviadoReceita = enviadoReceita;
    }

    @JoinColumn(name="ID_PERIODO_EMISSAO_CTE", foreignKey=@ForeignKey(name="FK_LOTE_FATURAMENTO_CTE_PER_CTE"))
    @ManyToOne(fetch=FetchType.LAZY)
    public PeriodoEmissaoCTe getPeriodoEmissaoCte() {
        return this.periodoEmissaoCte;
    }

    public void setPeriodoEmissaoCte(PeriodoEmissaoCTe periodoEmissaoCte) {
        this.periodoEmissaoCte = periodoEmissaoCte;
    }

    @JoinColumn(name="ID_VERSAO_CTE", foreignKey=@ForeignKey(name="FK_LOTE_FATURAMENTO_CTE_VER_CTE"))
    @ManyToOne(fetch=FetchType.LAZY)
    public VersaoCTe getVersaoCTe() {
        return this.versaoCTe;
    }

    public void setVersaoCTe(VersaoCTe versaoCTe) {
        this.versaoCTe = versaoCTe;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_LOTE_FATURAMENTO_CTE_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }
}

