/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroResultadoContFin;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.Cooperado;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EventoCooperado;
import com.touchcomp.basementor.model.vo.HistoricoPadrao;
import com.touchcomp.basementor.model.vo.LancamentoEventoCooperado;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="LOTE_LANC_EVT_COOPERADO")
public class LoteLancamentoEventoCooperado
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private EventoCooperado eventoCooperado;
    private Pessoa pessoaTerceiros;
    private Double valorTotal = 0.0;
    private String observacao;
    private Cooperado cooperado;
    private CondicoesPagamento condicoesPagamento;
    private String parcelas;
    private HistoricoPadrao historicoPadrao;
    private String historico;
    private Cliente cliente;
    private Short tipoLancamento = 0;
    private Date dataVencimentoRepasse;
    private MeioPagamento meioPagamentoRepasse;
    private Date dataVencimento;
    private Usuario usuario;
    private List<Titulo> titulosRepasse = new ArrayList<Titulo>();
    private List<LancamentoEventoCooperado> lancamentosCooperado = new ArrayList<LancamentoEventoCooperado>();
    private Date dataEmissaoRepasse;
    private CentroResultadoContFin centroResultadoContFin;

    @Id
    @Column(nullable=false, name="ID_LOTE_LANC_EVT_COOPERADO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_LOTE_LANC_EVT_COOPERADO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_LOTE_LANC_EVT_COOP_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EVENTO_COOPERADO", foreignKey=@ForeignKey(name="FK_LOTE_LANC_EVT_COOP_EVENTO"))
    public EventoCooperado getEventoCooperado() {
        return this.eventoCooperado;
    }

    public void setEventoCooperado(EventoCooperado eventoCooperado) {
        this.eventoCooperado = eventoCooperado;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA_TERCEIROS", foreignKey=@ForeignKey(name="FK_LOTE_LANC_EVT_COOP_PES_TERC"))
    public Pessoa getPessoaTerceiros() {
        return this.pessoaTerceiros;
    }

    public void setPessoaTerceiros(Pessoa pessoaTerceiros) {
        this.pessoaTerceiros = pessoaTerceiros;
    }

    @Column(nullable=false, name="VALOR_TOTAL", precision=15, scale=2)
    public Double getValorTotal() {
        return this.valorTotal;
    }

    public void setValorTotal(Double valorTotal) {
        this.valorTotal = valorTotal;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToMany(mappedBy="loteLancamentoCooperado", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<Titulo> getTitulosRepasse() {
        return this.titulosRepasse;
    }

    public void setTitulosRepasse(List<Titulo> titulosRepasse) {
        this.titulosRepasse = titulosRepasse;
    }

    @Column(name="OBSERVACAO", length=300)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COOPERADO", foreignKey=@ForeignKey(name="FK_LOTE_LANC_EVT_COOP_COOPERADO"))
    public Cooperado getCooperado() {
        return this.cooperado;
    }

    public void setCooperado(Cooperado cooperado) {
        this.cooperado = cooperado;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONDICAO_PAGAMENTO", foreignKey=@ForeignKey(name="FK_LOTE_LANC_EVT_COOP_COND_PAG"))
    public CondicoesPagamento getCondicoesPagamento() {
        return this.condicoesPagamento;
    }

    public void setCondicoesPagamento(CondicoesPagamento condicoesPagamento) {
        this.condicoesPagamento = condicoesPagamento;
    }

    @Column(name="PARCELAS", length=100)
    public String getParcelas() {
        return this.parcelas;
    }

    public void setParcelas(String parcelas) {
        this.parcelas = parcelas;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_HISTORICO_PADRAO", foreignKey=@ForeignKey(name="FK_LOTE_LANC_EVT_COOP_HIST_PAD"))
    public HistoricoPadrao getHistoricoPadrao() {
        return this.historicoPadrao;
    }

    public void setHistoricoPadrao(HistoricoPadrao historicoPadrao) {
        this.historicoPadrao = historicoPadrao;
    }

    @Column(name="HISTORICO", length=500)
    public String getHistorico() {
        return this.historico;
    }

    public void setHistorico(String historico) {
        this.historico = historico;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLIENTE", foreignKey=@ForeignKey(name="FK_LOTE_LANC_EVT_COOP_CLIENTE"))
    public Cliente getCliente() {
        return this.cliente;
    }

    public void setCliente(Cliente cliente) {
        this.cliente = cliente;
    }

    @Column(name="TIPO_LANCAMENTO")
    public Short getTipoLancamento() {
        return this.tipoLancamento;
    }

    public void setTipoLancamento(Short tipoLancamento) {
        this.tipoLancamento = tipoLancamento;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_VENCIMENTO_REPASSE")
    public Date getDataVencimentoRepasse() {
        return this.dataVencimentoRepasse;
    }

    public void setDataVencimentoRepasse(Date dataVencimentoRepasse) {
        this.dataVencimentoRepasse = dataVencimentoRepasse;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MEIO_PAGAMENTO_REPASSE", foreignKey=@ForeignKey(name="FK_LOTE_LANC_EVT_COOP_MEIO_PAG"))
    public MeioPagamento getMeioPagamentoRepasse() {
        return this.meioPagamentoRepasse;
    }

    public void setMeioPagamentoRepasse(MeioPagamento meioPagamentoRepasse) {
        this.meioPagamentoRepasse = meioPagamentoRepasse;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_VENCIMENTO")
    public Date getDataVencimento() {
        return this.dataVencimento;
    }

    public void setDataVencimento(Date dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_LOTE_LANC_EVT_COOP_USUARIO"))
    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @OneToMany(mappedBy="loteLancamentoCooperado", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<LancamentoEventoCooperado> getLancamentosCooperado() {
        return this.lancamentosCooperado;
    }

    public void setLancamentosCooperado(List<LancamentoEventoCooperado> lancamentosCooperado) {
        this.lancamentosCooperado = lancamentosCooperado;
    }

    @Column(name="DATA_EMISSAO_REPASSE")
    @Temporal(value=TemporalType.DATE)
    public Date getDataEmissaoRepasse() {
        return this.dataEmissaoRepasse;
    }

    public void setDataEmissaoRepasse(Date dataEmissaoRepasse) {
        this.dataEmissaoRepasse = dataEmissaoRepasse;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_RESULTADO_CONT_FIN", foreignKey=@ForeignKey(name="FK_L_LANC_EV_COOP_CEN_RES_CON"))
    public CentroResultadoContFin getCentroResultadoContFin() {
        return this.centroResultadoContFin;
    }

    public void setCentroResultadoContFin(CentroResultadoContFin centroResultadoContFin) {
        this.centroResultadoContFin = centroResultadoContFin;
    }
}

