/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ManifestoCteEletronico;
import com.touchcomp.basementor.model.vo.TipoCarroceriaVeiculo;
import com.touchcomp.basementor.model.vo.TipoRodadoVeiculo;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity
@Table(name="MAN_CTE_VEICULO")
public class ManifestoCteVeiculo
implements InterfaceVO {
    private Long identificador;
    private String placa;
    private Double tara = 0.0;
    private Double capPeso = 0.0;
    private Double capVolumetrica = 0.0;
    private TipoRodadoVeiculo tipoRodadoVeiculo;
    private TipoCarroceriaVeiculo tipoCarroceriaVeiculo;
    private UnidadeFederativa ufLicenciamento;
    private Short principal = 0;
    private ManifestoCteEletronico manifestoCteEletronico;

    @Id
    @Column(nullable=false, name="ID_MAN_CTE_VEICULO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_MAN_CTE_VEICULO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(nullable=false, name="PLACA", length=7)
    public String getPlaca() {
        return this.placa;
    }

    public void setPlaca(String placa) {
        this.placa = placa;
    }

    @Column(nullable=false, name="TARA", precision=15, scale=4)
    public Double getTara() {
        return this.tara;
    }

    public void setTara(Double tara) {
        this.tara = tara;
    }

    @Column(nullable=false, name="CAP_PESO", precision=15, scale=4)
    public Double getCapPeso() {
        return this.capPeso;
    }

    public void setCapPeso(Double capPeso) {
        this.capPeso = capPeso;
    }

    @Column(name="CAP_VOLUMETRICA", precision=15, scale=4)
    public Double getCapVolumetrica() {
        return this.capVolumetrica;
    }

    public void setCapVolumetrica(Double capVolumetrica) {
        this.capVolumetrica = capVolumetrica;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_TIPO_RODADO_VEICULO", foreignKey=@ForeignKey(name="FK_MAN_CTE_VEICULO_TIP_ROD_VEIC"))
    public TipoRodadoVeiculo getTipoRodadoVeiculo() {
        return this.tipoRodadoVeiculo;
    }

    public void setTipoRodadoVeiculo(TipoRodadoVeiculo tipoRodadoVeiculo) {
        this.tipoRodadoVeiculo = tipoRodadoVeiculo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_TIPO_CARROCERIA_VEIC", foreignKey=@ForeignKey(name="FK_MAN_CTE_VEICULO_TIP_CAR_VEIC"))
    public TipoCarroceriaVeiculo getTipoCarroceriaVeiculo() {
        return this.tipoCarroceriaVeiculo;
    }

    public void setTipoCarroceriaVeiculo(TipoCarroceriaVeiculo tipoCarroceriaVeiculo) {
        this.tipoCarroceriaVeiculo = tipoCarroceriaVeiculo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_UF_LICENCIAMENTO", foreignKey=@ForeignKey(name="FK_MAN_CTE_VEICULO_UF_LICENCIAM"))
    public UnidadeFederativa getUfLicenciamento() {
        return this.ufLicenciamento;
    }

    public void setUfLicenciamento(UnidadeFederativa ufLicenciamento) {
        this.ufLicenciamento = ufLicenciamento;
    }

    @Column(nullable=false, name="PRINCIPAL")
    public Short getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(Short principal) {
        this.principal = principal;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_MAN_CTE_ELETRONICO", foreignKey=@ForeignKey(name="FK_MAN_CTE_VEICULO_MAN_CTE_ELET"))
    public ManifestoCteEletronico getManifestoCteEletronico() {
        return this.manifestoCteEletronico;
    }

    public void setManifestoCteEletronico(ManifestoCteEletronico manifestoCteEletronico) {
        this.manifestoCteEletronico = manifestoCteEletronico;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getPlaca()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

