/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.meiopagamento.EnumConstTipoMeioPagamento;
import com.touchcomp.basementor.constants.enums.titulo.EnumConstGerarDocFinanceiro;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.BandeiraCartaoNFe;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.TipoPagamentoNFe;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="MEIO_PAGAMENTO", uniqueConstraints={@UniqueConstraint(name="UNQ1_MEIO_PAGAMENTO", columnNames={"DESCRICAO"})})
public class MeioPagamento
implements InterfaceVO {
    private Long identificador;
    private String descricao;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private Date dataCadastro;
    private Short ativo = 1;
    private Short alterarPessoaTitulo = 0;
    private Pessoa pessoa;
    private PlanoConta planoConta;
    private TipoPagamentoNFe tipoPagamentoNFe;
    private BandeiraCartaoNFe bandeiraCartaoNFe;
    private Pessoa credenciadoraCreditoDebito;
    private PlanoConta planoContaCredenciadoraCreditoDebito;
    private Short tipoIntegracao = 1;
    private Short gerarFinanceiro;
    private Short tipoMeioPagamento;
    private Short pagamentoAVista = 0;

    public MeioPagamento() {
        this.gerarFinanceiro = EnumConstGerarDocFinanceiro.GERAR_TITULOS.value;
        this.tipoMeioPagamento = EnumConstTipoMeioPagamento.NAO_APLICA.value;
    }

    @Id
    @Column(nullable=false, name="ID_MEIO_PAGAMENTO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_MEIO_PAGAMENTO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DESCRICAO", length=255)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Version
    @Generated(value=GenerationTime.ALWAYS)
    @Column(nullable=false, updatable=false, insertable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=true, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_MEIO_PAG_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(nullable=false, name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @Column(name="ALTERAR_PESSOA_TITULO")
    public Short getAlterarPessoaTitulo() {
        return this.alterarPessoaTitulo;
    }

    public void setAlterarPessoaTitulo(Short alterarPessoaTitulo) {
        this.alterarPessoaTitulo = alterarPessoaTitulo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_MEIO_PAG_PESSOA"))
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA", foreignKey=@ForeignKey(name="FK_MEIO_PAG_PLANO_CONTA"))
    public PlanoConta getPlanoConta() {
        return this.planoConta;
    }

    public void setPlanoConta(PlanoConta planoConta) {
        this.planoConta = planoConta;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_PAGAMENTO_NFE", foreignKey=@ForeignKey(name="FK_MEIO_PAG_TIPO_PAG_NFE"))
    public TipoPagamentoNFe getTipoPagamentoNFe() {
        return this.tipoPagamentoNFe;
    }

    public void setTipoPagamentoNFe(TipoPagamentoNFe tipoPagamentoNFe) {
        this.tipoPagamentoNFe = tipoPagamentoNFe;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_BANDEIRA_CARTAO_NFE", foreignKey=@ForeignKey(name="FK_MEIO_PAGAMENTO_BANDEIRA_NFE"))
    public BandeiraCartaoNFe getBandeiraCartaoNFe() {
        return this.bandeiraCartaoNFe;
    }

    public void setBandeiraCartaoNFe(BandeiraCartaoNFe bandeiraCartaoNFe) {
        this.bandeiraCartaoNFe = bandeiraCartaoNFe;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CREDENCIADORA_CRED_DEB", foreignKey=@ForeignKey(name="FK_MEIO_PAGAMENTO_CREDENCIADORA"))
    public Pessoa getCredenciadoraCreditoDebito() {
        return this.credenciadoraCreditoDebito;
    }

    public void setCredenciadoraCreditoDebito(Pessoa credenciadoraCreditoDebito) {
        this.credenciadoraCreditoDebito = credenciadoraCreditoDebito;
    }

    @Column(name="TIPO_INTEGRACAO")
    public Short getTipoIntegracao() {
        return this.tipoIntegracao;
    }

    public void setTipoIntegracao(Short tipoIntegracao) {
        this.tipoIntegracao = tipoIntegracao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PC_CREDENCIADORA_CRED_DEB", foreignKey=@ForeignKey(name="FK_MEIO_PAG_PC_CREDENCIADORA"))
    public PlanoConta getPlanoContaCredenciadoraCreditoDebito() {
        return this.planoContaCredenciadoraCreditoDebito;
    }

    public void setPlanoContaCredenciadoraCreditoDebito(PlanoConta planoContaCredenciadoraCreditoDebito) {
        this.planoContaCredenciadoraCreditoDebito = planoContaCredenciadoraCreditoDebito;
    }

    @Column(name="GERAR_FINANCEIRO")
    public Short getGerarFinanceiro() {
        return this.gerarFinanceiro;
    }

    public void setGerarFinanceiro(Short gerarFinanceiro) {
        this.gerarFinanceiro = gerarFinanceiro;
    }

    @Column(name="TIPO_MEIO_PAGAMENTO")
    public Short getTipoMeioPagamento() {
        return this.tipoMeioPagamento;
    }

    public void setTipoMeioPagamento(Short tipoMeioPagamento) {
        this.tipoMeioPagamento = tipoMeioPagamento;
    }

    @Column(name="PAG_A_VISTA")
    public Short getPagamentoAVista() {
        return this.pagamentoAVista;
    }

    public void setPagamentoAVista(Short pagamentoAVista) {
        this.pagamentoAVista = pagamentoAVista;
    }
}

