/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.mensagemmuralusuario.EnumConstMensagemChaveMural;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.MensagemMuralAgendamento;
import com.touchcomp.basementor.model.vo.MensagemMuralUsuario;
import com.touchcomp.basementor.model.vo.PrioridadeMarketing;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;

@Entity
@Table(name="MENSAGEM_MURAL")
public class MensagemMural
implements InterfaceVO {
    private Long identificador;
    private String mensagem;
    private String tituloMensagem;
    private Usuario autorMensagem;
    private Date dataMensagem;
    private Date dataVencimento;
    private List<MensagemMuralUsuario> mensagemMuralMsgUsuario;
    private List<MensagemMuralAgendamento> agendamentos;
    private String codigoMensagem;
    private String chaveMensagem = EnumConstMensagemChaveMural.CHAVE_MSG_AVULSA.getValue();
    private PrioridadeMarketing prioridadeMarketing;
    private Short finalizado = 0;

    public MensagemMural() {
        this.codigoMensagem = EnumConstMensagemChaveMural.CHAVE_MSG_AVULSA.getValue();
        this.mensagemMuralMsgUsuario = new ArrayList<MensagemMuralUsuario>();
        this.agendamentos = new ArrayList<MensagemMuralAgendamento>();
    }

    @Id
    @Column(nullable=false, unique=true, name="ID_MENSAGEM_MURAL")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_MENSAGEM_MURAL")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="MENSAGEM", length=5000)
    public String getMensagem() {
        return this.mensagem;
    }

    public void setMensagem(String mensagem) {
        this.mensagem = mensagem;
    }

    @JoinColumn(name="ID_AUTOR_MENSAGEM", foreignKey=@ForeignKey(name="FK_MENSAGEM_MURAL_USUARIO"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Usuario getAutorMensagem() {
        return this.autorMensagem;
    }

    public void setAutorMensagem(Usuario autorMensagem) {
        this.autorMensagem = autorMensagem;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_MENSAGEM")
    public Date getDataMensagem() {
        return this.dataMensagem;
    }

    public void setDataMensagem(Date dataMensagem) {
        this.dataMensagem = dataMensagem;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_VENC_MENSAGEM")
    public Date getDataVencimento() {
        return this.dataVencimento;
    }

    public void setDataVencimento(Date dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    @Column(name="TITULO_MENSAGEM", length=100)
    public String getTituloMensagem() {
        return this.tituloMensagem;
    }

    public void setTituloMensagem(String tituloMensagem) {
        this.tituloMensagem = tituloMensagem;
    }

    @OneToMany(mappedBy="mensagemMural", fetch=FetchType.EAGER)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<MensagemMuralUsuario> getMensagemMuralMsgUsuario() {
        return this.mensagemMuralMsgUsuario;
    }

    public void setMensagemMuralMsgUsuario(List<MensagemMuralUsuario> mensagemMuralMsgUsuario) {
        this.mensagemMuralMsgUsuario = mensagemMuralMsgUsuario;
    }

    @OneToMany(mappedBy="mensagemMural")
    @LazyCollection(value=LazyCollectionOption.FALSE)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<MensagemMuralAgendamento> getAgendamentos() {
        return this.agendamentos;
    }

    public void setAgendamentos(List<MensagemMuralAgendamento> agendamentos) {
        this.agendamentos = agendamentos;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getTituloMensagem() != null ? this.getTituloMensagem() : this.getMensagem()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="CHAVE_MENSAGEM")
    public String getChaveMensagem() {
        return this.chaveMensagem;
    }

    public void setChaveMensagem(String chaveMensagem) {
        this.chaveMensagem = chaveMensagem;
    }

    @JoinColumn(name="ID_PRIORIDADE_MARKETING", foreignKey=@ForeignKey(name="FK_MENSAGEM_MURAL_PRIO_MARKETING"))
    @ManyToOne(fetch=FetchType.LAZY)
    public PrioridadeMarketing getPrioridadeMarketing() {
        return this.prioridadeMarketing;
    }

    public void setPrioridadeMarketing(PrioridadeMarketing prioridadeMarketing) {
        this.prioridadeMarketing = prioridadeMarketing;
    }

    @Column(name="finalizado")
    public Short getFinalizado() {
        return this.finalizado;
    }

    public void setFinalizado(Short finalizado) {
        this.finalizado = finalizado;
    }

    @Column(name="codigo_mensagem")
    public String getCodigoMensagem() {
        return this.codigoMensagem;
    }

    public void setCodigoMensagem(String codigoMensagem) {
        this.codigoMensagem = codigoMensagem;
    }
}

