/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.IndiceGerencial;
import com.touchcomp.basementor.model.vo.IntervaloControleGer;
import com.touchcomp.basementor.model.vo.MetaControleGerLinha;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="META_CONTROLE_GERENCIAL")
public class MetaControleGerencial
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private String descricao;
    private Empresa empresa;
    private List<MetaControleGerLinha> metasLinhas = new ArrayList<MetaControleGerLinha>();
    private IndiceGerencial indiceGerencial;
    private IntervaloControleGer intervaloControleGer;

    @Id
    @Column(nullable=false, name="ID_META_CONTROLE_GERENCIAL")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_META_CONTROLE_GER")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="DESCRICAO", length=500)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_META_CONTROLE_GERENCIAL_EMP"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @OneToMany(mappedBy="metaControleGerencial")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<MetaControleGerLinha> getMetasLinhas() {
        return this.metasLinhas;
    }

    public void setMetasLinhas(List<MetaControleGerLinha> metasLinhas) {
        this.metasLinhas = metasLinhas;
    }

    @JoinColumn(name="ID_INDICE_GERENCIAL", foreignKey=@ForeignKey(name="FK_META_CONTROLE_GERENCIAL_IND"))
    @ManyToOne(fetch=FetchType.LAZY)
    public IndiceGerencial getIndiceGerencial() {
        return this.indiceGerencial;
    }

    public void setIndiceGerencial(IndiceGerencial indiceGerencial) {
        this.indiceGerencial = indiceGerencial;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @JoinColumn(name="ID_INTERVALO_CONTROLE_GER", foreignKey=@ForeignKey(name="FK_META_CONTROLE_GERENCIAL_INT"))
    @ManyToOne(fetch=FetchType.LAZY)
    public IntervaloControleGer getIntervaloControleGer() {
        return this.intervaloControleGer;
    }

    public void setIntervaloControleGer(IntervaloControleGer intervaloControleGer) {
        this.intervaloControleGer = intervaloControleGer;
    }
}

