/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.modelofichatecnica.EnumConstTipoModFichaTec;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.FichaTecnicaAvaliador;
import com.touchcomp.basementor.model.vo.ItemModeloFichaTecnica;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderColumn;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import lombok.Generated;

@Entity
@Table(name="MODELO_FICHA_TECNICA", uniqueConstraints={@UniqueConstraint(name="UNQ1_MODELO_FICHA_TECNICA_DES", columnNames={"DESCRICAO"})})
public class ModeloFichaTecnica
implements InterfaceVO {
    @Id
    @Column(nullable=false, unique=true, name="ID_MODELO_FICHA_TECNICA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_MODELO_FICHA_TECNICA")
    private Long identificador;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_MODELO_FICHA_TECNICA_EMPRESA"))
    private Empresa empresa;
    @Version
    @Column(name="DATA_ATUALIZACAO")
    private Timestamp dataAtualizacao;
    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_CADASTRO")
    private Date dataCadastro;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="modeloFichaTecnica", orphanRemoval=true)
    @OrderColumn(name="indice")
    private List<ItemModeloFichaTecnica> itensModeloFichaTecnica = new ArrayList<ItemModeloFichaTecnica>();
    @Column(name="ATIVO")
    private Short ativo = 1;
    @Column(name="TIPO_USO_FICHA_TECNICA")
    private Short tipoUsoFichaTecnica;
    @Column(name="DESCRICAO", length=80)
    private String descricao;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="modeloFicha", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<FichaTecnicaAvaliador> fichasTecnicasAvaliador = new ArrayList<FichaTecnicaAvaliador>();

    public ModeloFichaTecnica() {
        this.tipoUsoFichaTecnica = EnumConstTipoModFichaTec.GERAL.getValue();
    }

    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return this.getDescricao() != null ? ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()}) : ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Generated
    public Long getIdentificador() {
        return this.identificador;
    }

    @Generated
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Generated
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @Generated
    public List<ItemModeloFichaTecnica> getItensModeloFichaTecnica() {
        return this.itensModeloFichaTecnica;
    }

    @Generated
    public Short getAtivo() {
        return this.ativo;
    }

    @Generated
    public Short getTipoUsoFichaTecnica() {
        return this.tipoUsoFichaTecnica;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public List<FichaTecnicaAvaliador> getFichasTecnicasAvaliador() {
        return this.fichasTecnicasAvaliador;
    }

    @Generated
    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Generated
    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Generated
    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Generated
    public void setItensModeloFichaTecnica(List<ItemModeloFichaTecnica> itensModeloFichaTecnica) {
        this.itensModeloFichaTecnica = itensModeloFichaTecnica;
    }

    @Generated
    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @Generated
    public void setTipoUsoFichaTecnica(Short tipoUsoFichaTecnica) {
        this.tipoUsoFichaTecnica = tipoUsoFichaTecnica;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setFichasTecnicasAvaliador(List<FichaTecnicaAvaliador> fichasTecnicasAvaliador) {
        this.fichasTecnicasAvaliador = fichasTecnicasAvaliador;
    }
}

