/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.naturezaoperacao.EnumConstNatOpSugVlrNFe;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CNAE;
import com.touchcomp.basementor.model.vo.CategoriaPessoaModFiscal;
import com.touchcomp.basementor.model.vo.ConfigAjusteIcmsDocFiscalModFiscal;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ModeloFiscalCbsIbs;
import com.touchcomp.basementor.model.vo.ModeloFiscalEmpresa;
import com.touchcomp.basementor.model.vo.ModeloFiscalIcms;
import com.touchcomp.basementor.model.vo.ModeloFiscalIpi;
import com.touchcomp.basementor.model.vo.ModeloFiscalIs;
import com.touchcomp.basementor.model.vo.ModeloFiscalObsContrib;
import com.touchcomp.basementor.model.vo.ModeloFiscalObsFisco;
import com.touchcomp.basementor.model.vo.ModeloFiscalPisCofins;
import com.touchcomp.basementor.model.vo.ModeloFiscalProduto;
import com.touchcomp.basementor.model.vo.ModeloFiscalUF;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.NaturezaOperacaoModFiscal;
import com.touchcomp.basementor.model.vo.NcmModFiscal;
import com.touchcomp.basementor.model.vo.ObsFaturamento;
import com.touchcomp.basementor.model.vo.ReinfNaturezaRendimento;
import com.touchcomp.basementor.model.vo.ReinfTipoServico;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="MODELO_FISCAL", uniqueConstraints={@UniqueConstraint(name="UNQ1_MODELO_FISCAL", columnNames={"DESCRICAO"})})
public class ModeloFiscal
implements InterfaceVO {
    private Long identificador;
    private NaturezaOperacao naturezaOperacaoDev;
    private String cfopDevolucao;
    private Short compoeFluxoVenda = 0;
    private Short suframa = 0;
    private String cfop;
    private Short tipoInscricaoFederal = 0;
    private Short tipoInscricaoEstadual = 0;
    private List<ModeloFiscalObsContrib> observacoesContrib;
    private List<ModeloFiscalObsFisco> observacoesFisco;
    private List<ObsFaturamento> observacoesDevolucao;
    private Short ativo = 1;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private Short opcaoContabilizacao = 0;
    private Short opcaoContabilizacaoCPV = 0;
    private List<ModeloFiscalUF> unidadeFederativas;
    private Short movimentacaoFisica = 0;
    private Short gerarFinanceiro = 0;
    private String descricao;
    private Short issRetido = 0;
    private Short tipoFunrural = 0;
    private Short tipoOutros = 0;
    private Short tipoContSoc = 0;
    private Short tipoIRRF = 0;
    private Short tipoSestSenat = 0;
    private Short tipoINSS = 0;
    private Short tipoLei10833 = 0;
    private ModeloFiscalProduto modeloFiscalProduto;
    private Short tipoCfop = 0;
    private Short integrarPatrimonio = 0;
    private Short tipoCalculoCide = 0;
    private Short tipoCalculoImpImportacao = 0;
    private Short tipoRat = 0;
    private Short tipoSenar = 0;
    private Short tipoTaxaAnimal = 0;
    private ModeloFiscalIpi modeloFiscalIpi;
    private ModeloFiscalPisCofins modeloFiscalPisCofins;
    private ModeloFiscalIcms modeloFiscalIcms;
    private ModeloFiscalCbsIbs modeloFiscalCbsIbs;
    private ModeloFiscalIs modeloFiscalIs;
    private Short imprimirPrevImpInfProd = 0;
    private List<ModeloFiscalEmpresa> empresas;
    private List<NcmModFiscal> ncms;
    private Double valorMinimoCSLL = 0.0;
    private Double valorMinimoIR = 0.0;
    private Double valorMinimoInss = 0.0;
    private Double valorMinimoOutros = 0.0;
    private Double valorMinimoISS = 0.0;
    private List<CategoriaPessoaModFiscal> categoriaPessoa = new ArrayList<CategoriaPessoaModFiscal>();
    private List<NaturezaOperacaoModFiscal> naturezaOperacao = new ArrayList<NaturezaOperacaoModFiscal>();
    private Short criarAjustesDocumentoFiscal = 0;
    private List<ConfigAjusteIcmsDocFiscalModFiscal> configuracaoAjusteIcmsDocFiscal = new ArrayList<ConfigAjusteIcmsDocFiscalModFiscal>();
    private CNAE cnae;
    private ReinfTipoServico tipoServico;
    private Short utilizaCodigoFCI = 0;
    private Short disponivelNFCe = 0;
    private Short descartarDapi = 0;
    private Short compoeAquisicaoRural = 0;
    private Short naoCalcularSuframa = 0;
    private ReinfNaturezaRendimento reinfNaturezaRendimento;
    private Short sugValorUnitarioFatNFe;

    public ModeloFiscal() {
        this.observacoesContrib = new ArrayList<ModeloFiscalObsContrib>();
        this.observacoesFisco = new ArrayList<ModeloFiscalObsFisco>();
        this.observacoesDevolucao = new ArrayList<ObsFaturamento>();
        this.unidadeFederativas = new ArrayList<ModeloFiscalUF>();
        this.empresas = new ArrayList<ModeloFiscalEmpresa>();
        this.ncms = new ArrayList<NcmModFiscal>();
        this.sugValorUnitarioFatNFe = EnumConstNatOpSugVlrNFe.VALOR_NATUREZA_OPERACAO.getEnumId();
    }

    @Id
    @Column(name="ID_MODELO_FISCAL")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_MODELO_FISCAL")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(nullable=false, name="CFOP", length=3)
    public String getCfop() {
        return this.cfop;
    }

    public void setCfop(String cfop) {
        this.cfop = cfop;
    }

    @Column(nullable=false, name="TIPO_INSCRICAO_FEDERAL")
    public Short getTipoInscricaoFederal() {
        return this.tipoInscricaoFederal;
    }

    public void setTipoInscricaoFederal(Short tipoInscricaoFederal) {
        this.tipoInscricaoFederal = tipoInscricaoFederal;
    }

    @Column(nullable=false, name="TIPO_INSCRICAO_ESTADUAL")
    public Short getTipoInscricaoEstadual() {
        return this.tipoInscricaoEstadual;
    }

    public void setTipoInscricaoEstadual(Short tipoincricaoEstadual) {
        this.tipoInscricaoEstadual = tipoincricaoEstadual;
    }

    @Column(nullable=false, name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Generated(value=GenerationTime.ALWAYS)
    @Column(nullable=false, updatable=false, insertable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_MODELO_FISCAL_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(nullable=false, name="OPCAO_CONTABILIZACAO")
    public Short getOpcaoContabilizacao() {
        return this.opcaoContabilizacao;
    }

    public void setOpcaoContabilizacao(Short opcaoContabilizacao) {
        this.opcaoContabilizacao = opcaoContabilizacao;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="modeloFiscal", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<ModeloFiscalUF> getUnidadeFederativas() {
        return this.unidadeFederativas;
    }

    public void setUnidadeFederativas(List<ModeloFiscalUF> unidadeFederativas) {
        this.unidadeFederativas = unidadeFederativas;
    }

    @Column(nullable=false, name="MOVIMENTACAO_FISICA")
    public Short getMovimentacaoFisica() {
        return this.movimentacaoFisica;
    }

    public void setMovimentacaoFisica(Short movimentacaoFisica) {
        this.movimentacaoFisica = movimentacaoFisica;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1} - {2}", (Object[])new Object[]{this.getIdentificador(), this.getDescricao(), this.getCfop()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(nullable=false, name="GERAR_FINANCEIRO")
    public Short getGerarFinanceiro() {
        return this.gerarFinanceiro;
    }

    public void setGerarFinanceiro(Short gerarFinanceiro) {
        this.gerarFinanceiro = gerarFinanceiro;
    }

    @Column(nullable=false, unique=true, name="DESCRICAO", length=100)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Column(name="ISS_RETIDO")
    public Short getIssRetido() {
        return this.issRetido;
    }

    public void setIssRetido(Short issRetido) {
        this.issRetido = issRetido;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NATUREZA_OPERACAO_DEV", foreignKey=@ForeignKey(name="FK_MODELO_FISCAL_NAT_OP_DEV"))
    public NaturezaOperacao getNaturezaOperacaoDev() {
        return this.naturezaOperacaoDev;
    }

    public void setNaturezaOperacaoDev(NaturezaOperacao naturezaOperacaoDev) {
        this.naturezaOperacaoDev = naturezaOperacaoDev;
    }

    @Column(name="CFOP_DEVOLUCAO", length=3)
    public String getCfopDevolucao() {
        return this.cfopDevolucao;
    }

    public void setCfopDevolucao(String cfopDevolucao) {
        this.cfopDevolucao = cfopDevolucao;
    }

    @OneToMany(fetch=FetchType.LAZY)
    @JoinTable(name="OBS_MODELO_fiscal_dev", joinColumns={@JoinColumn(name="ID_MODELO_fiscal")}, inverseJoinColumns={@JoinColumn(name="ID_OBS_FATURAMENTO")}, uniqueConstraints={@UniqueConstraint(name="UNQ1_OBS_MODELO_FATURAMENTO", columnNames={"ID_OBS_FATURAMENTO", "ID_MODELO_FISCAL"})})
    public List<ObsFaturamento> getObservacoesDevolucao() {
        return this.observacoesDevolucao;
    }

    public void setObservacoesDevolucao(List<ObsFaturamento> observacoesDevolucao) {
        this.observacoesDevolucao = observacoesDevolucao;
    }

    @Column(name="SUFRAMA")
    public Short getSuframa() {
        return this.suframa;
    }

    public void setSuframa(Short suframa) {
        this.suframa = suframa;
    }

    @Column(name="COMPOE_FLUXO_VENDA")
    public Short getCompoeFluxoVenda() {
        return this.compoeFluxoVenda;
    }

    public void setCompoeFluxoVenda(Short compoeFluxoVenda) {
        this.compoeFluxoVenda = compoeFluxoVenda;
    }

    @Column(name="TIPO_FUNRURAL")
    public Short getTipoFunrural() {
        return this.tipoFunrural;
    }

    public void setTipoFunrural(Short tipoFunrural) {
        this.tipoFunrural = tipoFunrural;
    }

    @Column(name="TIPO_OUTROS")
    public Short getTipoOutros() {
        return this.tipoOutros;
    }

    public void setTipoOutros(Short tipoOutros) {
        this.tipoOutros = tipoOutros;
    }

    @Column(name="TIPO_CONT_SOC")
    public Short getTipoContSoc() {
        return this.tipoContSoc;
    }

    public void setTipoContSoc(Short tipoContSoc) {
        this.tipoContSoc = tipoContSoc;
    }

    @Column(name="TIPO_IRRF")
    public Short getTipoIRRF() {
        return this.tipoIRRF;
    }

    public void setTipoIRRF(Short tipoIRRF) {
        this.tipoIRRF = tipoIRRF;
    }

    @Column(name="TIPO_SEST_SENAT")
    public Short getTipoSestSenat() {
        return this.tipoSestSenat;
    }

    public void setTipoSestSenat(Short tipoSestSenat) {
        this.tipoSestSenat = tipoSestSenat;
    }

    @Column(name="TIPO_INSS")
    public Short getTipoINSS() {
        return this.tipoINSS;
    }

    public void setTipoINSS(Short tipoINSS) {
        this.tipoINSS = tipoINSS;
    }

    @Column(name="TIPO_LEI10833")
    public Short getTipoLei10833() {
        return this.tipoLei10833;
    }

    public void setTipoLei10833(Short tipoLei10833) {
        this.tipoLei10833 = tipoLei10833;
    }

    @OneToOne(mappedBy="modeloFiscal", fetch=FetchType.LAZY, targetEntity=ModeloFiscalProduto.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public ModeloFiscalProduto getModeloFiscalProduto() {
        return this.modeloFiscalProduto;
    }

    public void setModeloFiscalProduto(ModeloFiscalProduto modeloFiscalProduto) {
        this.modeloFiscalProduto = modeloFiscalProduto;
    }

    @Column(name="TIPO_CFOP")
    public Short getTipoCfop() {
        return this.tipoCfop;
    }

    public void setTipoCfop(Short tipoCfop) {
        this.tipoCfop = tipoCfop;
    }

    @Column(name="INTEGRAR_PATRIMONIO")
    public Short getIntegrarPatrimonio() {
        return this.integrarPatrimonio;
    }

    public void setIntegrarPatrimonio(Short integrarPatrimonio) {
        this.integrarPatrimonio = integrarPatrimonio;
    }

    @Column(name="TIPO_CALCULO_CIDE")
    public Short getTipoCalculoCide() {
        return this.tipoCalculoCide;
    }

    public void setTipoCalculoCide(Short tipoCalculoCide) {
        this.tipoCalculoCide = tipoCalculoCide;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.MERGE})
    @JoinColumn(name="ID_MODELO_FISCAL_IPI", foreignKey=@ForeignKey(name="FK_MODELO_FISCAL_MOD_IPI"))
    public ModeloFiscalIpi getModeloFiscalIpi() {
        return this.modeloFiscalIpi;
    }

    public void setModeloFiscalIpi(ModeloFiscalIpi modeloFiscalIpi) {
        this.modeloFiscalIpi = modeloFiscalIpi;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.MERGE})
    @JoinColumn(name="ID_MODELO_FISCAL_PIS_COFINS", foreignKey=@ForeignKey(name="FK_MODELO_FISCAL_MOD_PIS_COFINS"))
    public ModeloFiscalPisCofins getModeloFiscalPisCofins() {
        return this.modeloFiscalPisCofins;
    }

    public void setModeloFiscalPisCofins(ModeloFiscalPisCofins modeloFiscalPisCofins) {
        this.modeloFiscalPisCofins = modeloFiscalPisCofins;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.MERGE})
    @JoinColumn(name="ID_MODELO_FISCAL_ICMS", foreignKey=@ForeignKey(name="FK_MODELO_FISCAL_MOD_ICMS"))
    public ModeloFiscalIcms getModeloFiscalIcms() {
        return this.modeloFiscalIcms;
    }

    public void setModeloFiscalIcms(ModeloFiscalIcms modeloFiscalIcms) {
        this.modeloFiscalIcms = modeloFiscalIcms;
    }

    @Column(name="IMPRIMIR_PREV_IMP_INF_PROD")
    public Short getImprimirPrevImpInfProd() {
        return this.imprimirPrevImpInfProd;
    }

    public void setImprimirPrevImpInfProd(Short imprimirPrevImpInfProd) {
        this.imprimirPrevImpInfProd = imprimirPrevImpInfProd;
    }

    @OneToMany(mappedBy="modeloFiscal", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<ModeloFiscalEmpresa> getEmpresas() {
        return this.empresas;
    }

    public void setEmpresas(List<ModeloFiscalEmpresa> empresas) {
        this.empresas = empresas;
    }

    @Column(name="TIPO_CALCUL_IMP_IMPORT")
    public Short getTipoCalculoImpImportacao() {
        return this.tipoCalculoImpImportacao;
    }

    public void setTipoCalculoImpImportacao(Short tipoCalculoImpImportacao) {
        this.tipoCalculoImpImportacao = tipoCalculoImpImportacao;
    }

    @Column(name="VALOR_MINIMO_CSLL", precision=15, scale=2)
    public Double getValorMinimoCSLL() {
        return this.valorMinimoCSLL;
    }

    public void setValorMinimoCSLL(Double valorMinimoCSLL) {
        this.valorMinimoCSLL = valorMinimoCSLL;
    }

    @Column(nullable=false, name="VALOR_MINIMO_IR", precision=15, scale=2)
    public Double getValorMinimoIR() {
        return this.valorMinimoIR;
    }

    public void setValorMinimoIR(Double valorMinimoIR) {
        this.valorMinimoIR = valorMinimoIR;
    }

    @Column(name="VALOR_MINIMO_INSS", precision=15, scale=2)
    public Double getValorMinimoInss() {
        return this.valorMinimoInss;
    }

    public void setValorMinimoInss(Double valorMinimoInss) {
        this.valorMinimoInss = valorMinimoInss;
    }

    @Column(nullable=false, name="VALOR_MINIMO_OUTROS", precision=15, scale=2)
    public Double getValorMinimoOutros() {
        return this.valorMinimoOutros;
    }

    public void setValorMinimoOutros(Double valorMinimoOutros) {
        this.valorMinimoOutros = valorMinimoOutros;
    }

    @Column(nullable=false, name="VALOR_MINIMO_ISS", precision=15, scale=2)
    public Double getValorMinimoISS() {
        return this.valorMinimoISS;
    }

    public void setValorMinimoISS(Double valorMinimoISS) {
        this.valorMinimoISS = valorMinimoISS;
    }

    @OneToMany(mappedBy="modeloFiscal", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<CategoriaPessoaModFiscal> getCategoriaPessoa() {
        return this.categoriaPessoa;
    }

    public void setCategoriaPessoa(List<CategoriaPessoaModFiscal> categoriaPessoa) {
        this.categoriaPessoa = categoriaPessoa;
    }

    @OneToMany(mappedBy="modeloFiscal", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<NaturezaOperacaoModFiscal> getNaturezaOperacao() {
        return this.naturezaOperacao;
    }

    public void setNaturezaOperacao(List<NaturezaOperacaoModFiscal> naturezaOperacao) {
        this.naturezaOperacao = naturezaOperacao;
    }

    @Column(name="CRIAR_AJUSTE_DOC_FISCAL")
    public Short getCriarAjustesDocumentoFiscal() {
        return this.criarAjustesDocumentoFiscal;
    }

    public void setCriarAjustesDocumentoFiscal(Short criarAjustesDocumentoFiscal) {
        this.criarAjustesDocumentoFiscal = criarAjustesDocumentoFiscal;
    }

    @OneToMany(mappedBy="modeloFiscal", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ConfigAjusteIcmsDocFiscalModFiscal> getConfiguracaoAjusteIcmsDocFiscal() {
        return this.configuracaoAjusteIcmsDocFiscal;
    }

    public void setConfiguracaoAjusteIcmsDocFiscal(List<ConfigAjusteIcmsDocFiscalModFiscal> configuracaoAjusteIcmsDocFiscal) {
        this.configuracaoAjusteIcmsDocFiscal = configuracaoAjusteIcmsDocFiscal;
    }

    @OneToMany(mappedBy="modeloFiscal", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<NcmModFiscal> getNcms() {
        return this.ncms;
    }

    public void setNcms(List<NcmModFiscal> ncms) {
        this.ncms = ncms;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CNAE", foreignKey=@ForeignKey(name="FK_MODELO_FISCAL_CNAE"))
    public CNAE getCnae() {
        return this.cnae;
    }

    public void setCnae(CNAE cnae) {
        this.cnae = cnae;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_SERVICO_REINF", foreignKey=@ForeignKey(name="FK_MODELO_FISCAL_TP_SERVICO"))
    public ReinfTipoServico getTipoServico() {
        return this.tipoServico;
    }

    public void setTipoServico(ReinfTipoServico tipoServico) {
        this.tipoServico = tipoServico;
    }

    @Column(name="UTILIZA_CODIGO_FCI")
    public Short getUtilizaCodigoFCI() {
        return this.utilizaCodigoFCI;
    }

    public void setUtilizaCodigoFCI(Short utilizaCodigoFCI) {
        this.utilizaCodigoFCI = utilizaCodigoFCI;
    }

    @Column(name="OPCAO_CONTABILIZACAO_CPV")
    public Short getOpcaoContabilizacaoCPV() {
        return this.opcaoContabilizacaoCPV;
    }

    public void setOpcaoContabilizacaoCPV(Short opcaoContabilizacaoCPV) {
        this.opcaoContabilizacaoCPV = opcaoContabilizacaoCPV;
    }

    @Column(name="TIPO_RAT")
    public Short getTipoRat() {
        return this.tipoRat;
    }

    public void setTipoRat(Short tipoRat) {
        this.tipoRat = tipoRat;
    }

    @Column(name="TIPO_SENAR")
    public Short getTipoSenar() {
        return this.tipoSenar;
    }

    public void setTipoSenar(Short tipoSenar) {
        this.tipoSenar = tipoSenar;
    }

    @Column(name="TIPO_TAXA_ANIMAL")
    public Short getTipoTaxaAnimal() {
        return this.tipoTaxaAnimal;
    }

    public void setTipoTaxaAnimal(Short tipoTaxaAnimal) {
        this.tipoTaxaAnimal = tipoTaxaAnimal;
    }

    @Column(name="DISPONIVEL_NFCE")
    public Short getDisponivelNFCe() {
        return this.disponivelNFCe;
    }

    public void setDisponivelNFCe(Short disponivelNFCe) {
        this.disponivelNFCe = disponivelNFCe;
    }

    @OneToMany(mappedBy="modeloFiscal", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<ModeloFiscalObsFisco> getObservacoesFisco() {
        return this.observacoesFisco;
    }

    public void setObservacoesFisco(List<ModeloFiscalObsFisco> observacoesFisco) {
        this.observacoesFisco = observacoesFisco;
    }

    @OneToMany(mappedBy="modeloFiscal", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<ModeloFiscalObsContrib> getObservacoesContrib() {
        return this.observacoesContrib;
    }

    public void setObservacoesContrib(List<ModeloFiscalObsContrib> observacoesContrib) {
        this.observacoesContrib = observacoesContrib;
    }

    @Column(name="descartar_dapi")
    public Short getDescartarDapi() {
        return this.descartarDapi;
    }

    public void setDescartarDapi(Short descartarDapi) {
        this.descartarDapi = descartarDapi;
    }

    @Column(name="compoe_aquisicao_rural")
    public Short getCompoeAquisicaoRural() {
        return this.compoeAquisicaoRural;
    }

    public void setCompoeAquisicaoRural(Short compoeAquisicaoRural) {
        this.compoeAquisicaoRural = compoeAquisicaoRural;
    }

    @Column(name="NAO_CALCULAR_SUFRAMA")
    public Short getNaoCalcularSuframa() {
        return this.naoCalcularSuframa;
    }

    public void setNaoCalcularSuframa(Short naoCalcularSuframa) {
        this.naoCalcularSuframa = naoCalcularSuframa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_natureza_rendimento_reinf")
    public ReinfNaturezaRendimento getReinfNaturezaRendimento() {
        return this.reinfNaturezaRendimento;
    }

    public void setReinfNaturezaRendimento(ReinfNaturezaRendimento reinfNaturezaRendimento) {
        this.reinfNaturezaRendimento = reinfNaturezaRendimento;
    }

    @Column(name="SUG_VR_UNITARIO_FAT_NFE")
    public Short getSugValorUnitarioFatNFe() {
        return this.sugValorUnitarioFatNFe;
    }

    public void setSugValorUnitarioFatNFe(Short sugValorUnitarioFatNFe) {
        this.sugValorUnitarioFatNFe = sugValorUnitarioFatNFe;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_modelo_fiscal_is")
    public ModeloFiscalIs getModeloFiscalIs() {
        return this.modeloFiscalIs;
    }

    public void setModeloFiscalIs(ModeloFiscalIs modeloFiscalIs) {
        this.modeloFiscalIs = modeloFiscalIs;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_modelo_fiscal_cbs_ibs")
    public ModeloFiscalCbsIbs getModeloFiscalCbsIbs() {
        return this.modeloFiscalCbsIbs;
    }

    public void setModeloFiscalCbsIbs(ModeloFiscalCbsIbs modeloFiscalCbsIbs) {
        this.modeloFiscalCbsIbs = modeloFiscalCbsIbs;
    }
}

