/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CategoriaPessoa;
import com.touchcomp.basementor.model.vo.Cfop;
import com.touchcomp.basementor.model.vo.ComponenteFrete;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.IncidenciaIcms;
import com.touchcomp.basementor.model.vo.IncidenciaPisCofins;
import com.touchcomp.basementor.model.vo.ModeloFiscalCbsIbs;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.ObsFaturamento;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.TipoModal;
import com.touchcomp.basementor.model.vo.TipoOperacaoCte;
import com.touchcomp.basementor.model.vo.TipoServicoCte;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="MODELO_FISCAL_CTE")
public class ModeloFiscalCte
implements InterfaceVO {
    private Long identificador;
    private NaturezaOperacao naturezaOperacao;
    private IncidenciaIcms incidenciaIcms;
    private Double aliquotaIcms = 0.0;
    private PlanoConta planoContaDevedora;
    private Short aliquotaInformada = EnumConstantsMentorSimNao.NAO.getValue();
    private Short acrescentarIcmsCte = EnumConstantsMentorSimNao.NAO.getValue();
    private Short calcIcmsOutraUf = EnumConstantsMentorSimNao.NAO.getValue();
    private List<ObsFaturamento> observacoes = new ArrayList<ObsFaturamento>();
    private List<ObsFaturamento> observacoesIntFisco = new ArrayList<ObsFaturamento>();
    private Short ativo = EnumConstantsMentorSimNao.SIM.getValue();
    private Cfop cfop;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private Short opcaoContabilizacao = EnumConstantsMentorSimNao.NAO.getValue();
    private List<UnidadeFederativa> unidadeFederativasTomador = new ArrayList<UnidadeFederativa>();
    private List<UnidadeFederativa> unidadeFederativas = new ArrayList<UnidadeFederativa>();
    private List<UnidadeFederativa> unidadeFederativasDest = new ArrayList<UnidadeFederativa>();
    private Short gerarFinanceiro = EnumConstantsMentorSimNao.NAO.getValue();
    private String descricao;
    private IncidenciaPisCofins incidenciaPisCofins;
    private PlanoConta planoContaIcmsCredor;
    private PlanoConta planoContaPisCredor;
    private PlanoConta planoContaCofinsCredor;
    private PlanoConta planoContaIcmsDevedor;
    private PlanoConta planoContaPisDevedor;
    private PlanoConta planoContaCofinsDevedor;
    private Double reducaoBaseCalcIcms = 0.0;
    private Double aliquotaPis = 0.0;
    private Double aliquotaCofins = 0.0;
    private TipoServicoCte tipoServicoCte;
    private List<ComponenteFrete> componenteFrete = new ArrayList<ComponenteFrete>();
    private String observacaoGeral;
    private CategoriaPessoa categoriaPessoa;
    private TipoOperacaoCte tipoOperacaoCte;
    private TipoModal tipoModal;
    private Short reembolso;
    private Short incluirVrIcmsBc;
    private Short calcularDifal;
    private Double aliqFcp = 0.0;
    private ModeloFiscalCbsIbs modeloFiscalCbsIbs;
    private List<Empresa> empresas = new ArrayList<Empresa>();

    public ModeloFiscalCte() {
        this.reembolso = EnumConstantsMentorSimNao.NAO.getValue();
        this.incluirVrIcmsBc = EnumConstantsMentorSimNao.NAO.getValue();
        this.calcularDifal = EnumConstantsMentorSimNao.NAO.getValue();
    }

    @Id
    @Column(name="ID_MODELO_FISCAL_CTE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_MODELO_FISCAL_CTE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_NATUREZA_OPERACAO", foreignKey=@ForeignKey(name="FK_MODELO_FISCAL_CTE_NAT_OP"))
    public NaturezaOperacao getNaturezaOperacao() {
        return this.naturezaOperacao;
    }

    public void setNaturezaOperacao(NaturezaOperacao naturezaOperacao) {
        this.naturezaOperacao = naturezaOperacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_INCIDENCIA_ICMS", foreignKey=@ForeignKey(name="FK_MODELO_FISCAL_CTE_INC_ICMS"))
    public IncidenciaIcms getIncidenciaIcms() {
        return this.incidenciaIcms;
    }

    public void setIncidenciaIcms(IncidenciaIcms incidenciaIcms) {
        this.incidenciaIcms = incidenciaIcms;
    }

    @Column(nullable=false, name="ALIQUOTA_ICMS", precision=15, scale=2)
    public Double getAliquotaIcms() {
        return this.aliquotaIcms;
    }

    public void setAliquotaIcms(Double aliquotaIcms) {
        this.aliquotaIcms = aliquotaIcms;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_DEVEDORA", foreignKey=@ForeignKey(name="FK_MODELO_FISCAL_CTE_PC_DEV"))
    public PlanoConta getPlanoContaDevedora() {
        return this.planoContaDevedora;
    }

    public void setPlanoContaDevedora(PlanoConta planoContaCredora) {
        this.planoContaDevedora = planoContaCredora;
    }

    @OneToMany(fetch=FetchType.LAZY)
    @JoinTable(name="OBS_MODELO_Fiscal_cte", joinColumns={@JoinColumn(name="ID_MODELO_Fiscal_cte")}, inverseJoinColumns={@JoinColumn(name="ID_OBS_FATURAMENTO")})
    public List<ObsFaturamento> getObservacoes() {
        return this.observacoes;
    }

    public void setObservacoes(List<ObsFaturamento> observacoes) {
        this.observacoes = observacoes;
    }

    @Column(nullable=false, name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_MODELO_FISCAL_CTE_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(nullable=false, name="OPCAO_CONTABILIZACAO")
    public Short getOpcaoContabilizacao() {
        return this.opcaoContabilizacao;
    }

    public void setOpcaoContabilizacao(Short opcaoContabilizacao) {
        this.opcaoContabilizacao = opcaoContabilizacao;
    }

    @OneToMany(fetch=FetchType.LAZY)
    @JoinTable(name="UF_TOMADOR_MODELO_Fiscal_cte", joinColumns={@JoinColumn(name="ID_MODELO_Fiscal_cte")}, inverseJoinColumns={@JoinColumn(name="ID_UF")})
    public List<UnidadeFederativa> getUnidadeFederativasTomador() {
        return this.unidadeFederativasTomador;
    }

    public void setUnidadeFederativasTomador(List<UnidadeFederativa> unidadeFederativasTomador) {
        this.unidadeFederativasTomador = unidadeFederativasTomador;
    }

    @OneToMany(fetch=FetchType.LAZY)
    @JoinTable(name="UF_MODELO_Fiscal_cte", joinColumns={@JoinColumn(name="ID_MODELO_Fiscal_cte")}, inverseJoinColumns={@JoinColumn(name="ID_UF")})
    public List<UnidadeFederativa> getUnidadeFederativas() {
        return this.unidadeFederativas;
    }

    public void setUnidadeFederativas(List<UnidadeFederativa> Uf) {
        this.unidadeFederativas = Uf;
    }

    @OneToMany(fetch=FetchType.LAZY)
    @JoinTable(name="UF_dest_MODELO_Fiscal_cte", joinColumns={@JoinColumn(name="ID_MODELO_Fiscal_cte")}, inverseJoinColumns={@JoinColumn(name="ID_UF")})
    public List<UnidadeFederativa> getUnidadeFederativasDest() {
        return this.unidadeFederativasDest;
    }

    public void setUnidadeFederativasDest(List<UnidadeFederativa> Uf) {
        this.unidadeFederativasDest = Uf;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1} - {2}", (Object[])new Object[]{this.getIdentificador(), this.getDescricao(), this.getCfop()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(nullable=false, name="GERAR_FINANCEIRO")
    public Short getGerarFinanceiro() {
        return this.gerarFinanceiro;
    }

    public void setGerarFinanceiro(Short gerarFinanceiro) {
        this.gerarFinanceiro = gerarFinanceiro;
    }

    @Column(nullable=false, unique=true, name="DESCRICAO", length=100)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_INCIDENCIA_PIS_COFINS", foreignKey=@ForeignKey(name="FK_MODELO_FISCAL_CTE_INC_PIS_CO"))
    public IncidenciaPisCofins getIncidenciaPisCofins() {
        return this.incidenciaPisCofins;
    }

    public void setIncidenciaPisCofins(IncidenciaPisCofins incidenciaPisCofins) {
        this.incidenciaPisCofins = incidenciaPisCofins;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_ICMS_CREDOR", foreignKey=@ForeignKey(name="FK_MODELO_FISCAL_CTE_PC_ICMS"))
    public PlanoConta getPlanoContaIcmsCredor() {
        return this.planoContaIcmsCredor;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_PIS_CREDOR", foreignKey=@ForeignKey(name="FK_MODELO_FISCAL_CTE_PC_PIS"))
    public PlanoConta getPlanoContaPisCredor() {
        return this.planoContaPisCredor;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_COFINS_CREDOR", foreignKey=@ForeignKey(name="FK_MODELO_FISCAL_CTE_PC_COFINS"))
    public PlanoConta getPlanoContaCofinsCredor() {
        return this.planoContaCofinsCredor;
    }

    public void setPlanoContaIcmsCredor(PlanoConta planoContaIcmsCredor) {
        this.planoContaIcmsCredor = planoContaIcmsCredor;
    }

    public void setPlanoContaPisCredor(PlanoConta planoContaPisCredor) {
        this.planoContaPisCredor = planoContaPisCredor;
    }

    public void setPlanoContaCofinsCredor(PlanoConta planoContaCofinsCredor) {
        this.planoContaCofinsCredor = planoContaCofinsCredor;
    }

    @Column(name="REDUCAO_BASE_CALC_ICMS", precision=15, scale=2)
    public Double getReducaoBaseCalcIcms() {
        return this.reducaoBaseCalcIcms;
    }

    public void setReducaoBaseCalcIcms(Double reducaoBaseCalcIcms) {
        this.reducaoBaseCalcIcms = reducaoBaseCalcIcms;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_SERVICO_CTE", foreignKey=@ForeignKey(name="FK_MODELO_FISCAL_CTE_TP_SERVICO"))
    public TipoServicoCte getTipoServicoCte() {
        return this.tipoServicoCte;
    }

    public void setTipoServicoCte(TipoServicoCte tipoServicoCte) {
        this.tipoServicoCte = tipoServicoCte;
    }

    @OneToMany(fetch=FetchType.LAZY)
    @JoinTable(name="OBS_MOD_fiscal_cte_int_fisco", joinColumns={@JoinColumn(name="ID_MODELO_fiscal_cte")}, inverseJoinColumns={@JoinColumn(name="ID_OBS_FATURAMENTO")})
    public List<ObsFaturamento> getObservacoesIntFisco() {
        return this.observacoesIntFisco;
    }

    public void setObservacoesIntFisco(List<ObsFaturamento> observacoesIntFisco) {
        this.observacoesIntFisco = observacoesIntFisco;
    }

    @OneToMany(fetch=FetchType.LAZY)
    @JoinTable(name="COMP_FRETE_MODELO_FISCAL_cte", joinColumns={@JoinColumn(name="ID_MODELO_FISCAL_cte")}, inverseJoinColumns={@JoinColumn(name="ID_COMPONENTE_FRETE")})
    public List<ComponenteFrete> getComponenteFrete() {
        return this.componenteFrete;
    }

    public void setComponenteFrete(List<ComponenteFrete> componenteFrete) {
        this.componenteFrete = componenteFrete;
    }

    @Column(name="ALIQUOTA_PIS", precision=15, scale=2)
    public Double getAliquotaPis() {
        return this.aliquotaPis;
    }

    public void setAliquotaPis(Double aliquotaPis) {
        this.aliquotaPis = aliquotaPis;
    }

    @Column(name="ALIQUOTA_COFINS", precision=15, scale=2)
    public Double getAliquotaCofins() {
        return this.aliquotaCofins;
    }

    public void setAliquotaCofins(Double aliquotaCofins) {
        this.aliquotaCofins = aliquotaCofins;
    }

    @Column(name="ALIQUOTA_INFORMADA")
    public Short getAliquotaInformada() {
        return this.aliquotaInformada;
    }

    public void setAliquotaInformada(Short aliquotaInformada) {
        this.aliquotaInformada = aliquotaInformada;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_ICMS_DEV", foreignKey=@ForeignKey(name="FK_MODELO_FISCAL_CTE_PC_ICMS_DE"))
    public PlanoConta getPlanoContaIcmsDevedor() {
        return this.planoContaIcmsDevedor;
    }

    public void setPlanoContaIcmsDevedor(PlanoConta planoContaIcmsDevedor) {
        this.planoContaIcmsDevedor = planoContaIcmsDevedor;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_PIS_DEV", foreignKey=@ForeignKey(name="FK_MODELO_FISCAL_CTE_PC_PIS_DEV"))
    public PlanoConta getPlanoContaPisDevedor() {
        return this.planoContaPisDevedor;
    }

    public void setPlanoContaPisDevedor(PlanoConta planoContaPisDevedor) {
        this.planoContaPisDevedor = planoContaPisDevedor;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_COFINS_DEV", foreignKey=@ForeignKey(name="FK_MODELO_FISCAL_CTE_PC_COF_DEV"))
    public PlanoConta getPlanoContaCofinsDevedor() {
        return this.planoContaCofinsDevedor;
    }

    public void setPlanoContaCofinsDevedor(PlanoConta planoContaCofinsDevedor) {
        this.planoContaCofinsDevedor = planoContaCofinsDevedor;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CFOP", foreignKey=@ForeignKey(name="FK_MODELO_FISCAL_CTE_CFOP"))
    public Cfop getCfop() {
        return this.cfop;
    }

    public void setCfop(Cfop cfop) {
        this.cfop = cfop;
    }

    @Column(name="CALC_ICMS_OUTRA_UF")
    public Short getCalcIcmsOutraUf() {
        return this.calcIcmsOutraUf;
    }

    public void setCalcIcmsOutraUf(Short calcIcmsOutraUf) {
        this.calcIcmsOutraUf = calcIcmsOutraUf;
    }

    @Column(name="OBSERVACAO_GERAL", length=2000)
    public String getObservacaoGeral() {
        return this.observacaoGeral;
    }

    public void setObservacaoGeral(String observacaoGeral) {
        this.observacaoGeral = observacaoGeral;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CATEGORIA_PESSOA", foreignKey=@ForeignKey(name="FK_MODELO_FISCAL_CTE_CAT_PESSOA"))
    public CategoriaPessoa getCategoriaPessoa() {
        return this.categoriaPessoa;
    }

    public void setCategoriaPessoa(CategoriaPessoa categoriaPessoa) {
        this.categoriaPessoa = categoriaPessoa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_OPER_CTE", foreignKey=@ForeignKey(name="FK_MODELO_FISCAL_CTE_TP_OP_CTE"))
    public TipoOperacaoCte getTipoOperacaoCte() {
        return this.tipoOperacaoCte;
    }

    public void setTipoOperacaoCte(TipoOperacaoCte tipoOperacaoCte) {
        this.tipoOperacaoCte = tipoOperacaoCte;
    }

    @Column(name="ACRESCENTAR_ICMS_CTE")
    public Short getAcrescentarIcmsCte() {
        return this.acrescentarIcmsCte;
    }

    public void setAcrescentarIcmsCte(Short acrescentarIcmsCte) {
        this.acrescentarIcmsCte = acrescentarIcmsCte;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_MODAL", foreignKey=@ForeignKey(name="FK_MODELO_FISCAL_CTE_TP_MODAL"))
    public TipoModal getTipoModal() {
        return this.tipoModal;
    }

    public void setTipoModal(TipoModal tipoModal) {
        this.tipoModal = tipoModal;
    }

    @OneToMany(fetch=FetchType.LAZY)
    @JoinTable(name="mod_fiscal_cte_empresa", joinColumns={@JoinColumn(name="id_modelo_fiscal_cte")}, inverseJoinColumns={@JoinColumn(name="id_empresa")})
    public List<Empresa> getEmpresas() {
        return this.empresas;
    }

    public void setEmpresas(List<Empresa> empresas) {
        this.empresas = empresas;
    }

    @Column(name="REEMBOLSO")
    public Short getReembolso() {
        return this.reembolso;
    }

    public void setReembolso(Short reembolso) {
        this.reembolso = reembolso;
    }

    @Column(name="INCLUIR_VR_ICMS_BC")
    public Short getIncluirVrIcmsBc() {
        return this.incluirVrIcmsBc;
    }

    public void setIncluirVrIcmsBc(Short incluirVrIcmsBc) {
        this.incluirVrIcmsBc = incluirVrIcmsBc;
    }

    @Column(name="CALCULAR_DIFAL")
    public Short getCalcularDifal() {
        return this.calcularDifal;
    }

    public void setCalcularDifal(Short calcularDifal) {
        this.calcularDifal = calcularDifal;
    }

    @Column(name="ALIQ_FCP", precision=15, scale=2)
    public Double getAliqFcp() {
        return this.aliqFcp;
    }

    public void setAliqFcp(Double aliqFcp) {
        this.aliqFcp = aliqFcp;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="id_modelo_fiscal_cbs_ibs")
    public ModeloFiscalCbsIbs getModeloFiscalCbsIbs() {
        return this.modeloFiscalCbsIbs;
    }

    public void setModeloFiscalCbsIbs(ModeloFiscalCbsIbs modeloFiscalCbsIbs) {
        this.modeloFiscalCbsIbs = modeloFiscalCbsIbs;
    }
}

