/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;

@Entity
@Table(name="MOEDA", uniqueConstraints={@UniqueConstraint(name="UNQ1_MOEDA", columnNames={"DESCRICAO"})})
public class Moeda
implements InterfaceVO {
    private Long identificador;
    private String descricao;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Short preferencial = 0;
    private Integer codModedaBC = 1;
    private Short ativo = EnumConstantsMentorSimNao.SIM.getValue();

    @Id
    @Column(name="ID_MOEDA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_MOEDA")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DESCRICAO", length=100)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="PREFERENCIAL")
    public Short getPreferencial() {
        return this.preferencial;
    }

    public void setPreferencial(Short preferencial) {
        this.preferencial = preferencial;
    }

    @Column(name="COD_MOEDA_BC", precision=12, scale=2)
    public Integer getCodModedaBC() {
        return this.codModedaBC;
    }

    public void setCodModedaBC(Integer codModedaBC) {
        this.codModedaBC = codModedaBC;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }
}

