/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.BusinessIntelligence;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.NaturezaOperacaoObservacaoFiscal;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="NATUREZA_OP_TICKET", uniqueConstraints={@UniqueConstraint(name="UNQ1_NATUREZA_OP_TICKET", columnNames={"DESCRICAO"})})
public class NaturezaOperacaoTicketFiscal
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Short ativo = 1;
    private String descricao;
    private String serie;
    private Short mvEstoque = 0;
    private CentroEstoque centroEstoque;
    private BusinessIntelligence biImpTicketFiscal;
    private BusinessIntelligence biImpTicketFiscalAbertura;
    private List<NaturezaOperacaoObservacaoFiscal> naturezaOperacaoObservacaoFiscal = new ArrayList<NaturezaOperacaoObservacaoFiscal>();

    @Id
    @Column(nullable=false, name="ID_NATUREZA_OP_TICKET")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_NATUREZA_TICKET")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_NATUREZA_OP_TICKET_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(nullable=false, name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @Column(nullable=false, unique=true, name="DESCRICAO", length=100)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Column(nullable=false, name="SERIE", length=3)
    public String getSerie() {
        return this.serie;
    }

    public void setSerie(String serie) {
        this.serie = serie;
    }

    @Column(nullable=false, name="MOV_ESTOQUE")
    public Short getMvEstoque() {
        return this.mvEstoque;
    }

    public void setMvEstoque(Short mvEstoque) {
        this.mvEstoque = mvEstoque;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_ESTOQUE", foreignKey=@ForeignKey(name="FK_NATUREZA_OP_TICKET_CENTRO_ES"))
    public CentroEstoque getCentroEstoque() {
        return this.centroEstoque;
    }

    public void setCentroEstoque(CentroEstoque centroEstoque) {
        this.centroEstoque = centroEstoque;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_BI_IMP_TICKET_FISCAL", foreignKey=@ForeignKey(name="FK_NATUREZA_OP_TICKET_BI_IMP_TF"))
    public BusinessIntelligence getBiImpTicketFiscal() {
        return this.biImpTicketFiscal;
    }

    public void setBiImpTicketFiscal(BusinessIntelligence biImpTicketFiscal) {
        this.biImpTicketFiscal = biImpTicketFiscal;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_BI_IMP_TICKET_FISCAL_ABERTUR", foreignKey=@ForeignKey(name="FK_NATUREZA_OP_TICKET_BI_IMP_FA"))
    public BusinessIntelligence getBiImpTicketFiscalAbertura() {
        return this.biImpTicketFiscalAbertura;
    }

    public void setBiImpTicketFiscalAbertura(BusinessIntelligence biImpTicketFiscalAbertura) {
        this.biImpTicketFiscalAbertura = biImpTicketFiscalAbertura;
    }

    @OneToMany(mappedBy="naturezaOperacaoTicketFiscal", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<NaturezaOperacaoObservacaoFiscal> getNaturezaOperacaoObservacaoFiscal() {
        return this.naturezaOperacaoObservacaoFiscal;
    }

    public void setNaturezaOperacaoObservacaoFiscal(List<NaturezaOperacaoObservacaoFiscal> naturezaOperacaoObservacaoFiscal) {
        this.naturezaOperacaoObservacaoFiscal = naturezaOperacaoObservacaoFiscal;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

