/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.GrupoNCMRelNCM;
import com.touchcomp.basementor.model.vo.NcmAliquotaUF;
import com.touchcomp.basementor.model.vo.ParamReceitaPisCofinsNatReceita;
import com.touchcomp.basementor.model.vo.RegraExcecaoCbsIbs;
import com.touchcomp.basementor.model.vo.RegraExcecaoNCM;
import com.touchcomp.basementor.model.vo.ReinfCodAtividadeEconomica;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="NCM")
public class Ncm
implements InterfaceVO {
    private Long identificador;
    private String codigo;
    private String descricao;
    private Double aliquotaIpi = 0.0;
    private List<RegraExcecaoNCM> regraExcecaoNCM = new ArrayList<RegraExcecaoNCM>();
    private Timestamp dataAtualizacao;
    private List<NcmAliquotaUF> aliquotasUF;
    private Date dataInicial;
    private Date dataFinal;
    private List<GrupoNCMRelNCM> grupoNCMRel = new ArrayList<GrupoNCMRelNCM>();
    private ReinfCodAtividadeEconomica reinfCodAtividadeEconomica;
    private List<ParamReceitaPisCofinsNatReceita> naturezasReceita;
    private List<RegraExcecaoCbsIbs> regrasExcecoesCbsIbs;

    public Ncm() {
        this.aliquotasUF = new ArrayList<NcmAliquotaUF>();
        this.naturezasReceita = new ArrayList<ParamReceitaPisCofinsNatReceita>();
        this.regrasExcecoesCbsIbs = new ArrayList<RegraExcecaoCbsIbs>();
    }

    @Id
    @Column(nullable=false, name="ID_NCM")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_NCM")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Column(nullable=false, name="CODIGO", length=12)
    public String getCodigo() {
        return this.codigo;
    }

    @Column(nullable=false, name="DESCRICAO", length=1000)
    public String getDescricao() {
        return this.descricao;
    }

    @Column(nullable=false, name="ALIQUOTA_IPI")
    public Double getAliquotaIpi() {
        return this.aliquotaIpi;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setCodigo(String codigo) {
        this.codigo = codigo;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public void setAliquotaIpi(Double calculaIpi) {
        this.aliquotaIpi = calculaIpi;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getCodigo(), this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToMany(mappedBy="ncm", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<RegraExcecaoNCM> getRegraExcecaoNCM() {
        return this.regraExcecaoNCM;
    }

    public void setRegraExcecaoNCM(List<RegraExcecaoNCM> regraExcecaoNCM) {
        this.regraExcecaoNCM = regraExcecaoNCM;
    }

    @Version
    @Generated(value=GenerationTime.ALWAYS)
    @Column(nullable=false, updatable=false, insertable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @OneToMany(mappedBy="ncm", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<NcmAliquotaUF> getAliquotasUF() {
        return this.aliquotasUF;
    }

    public void setAliquotasUF(List<NcmAliquotaUF> aliquotasUF) {
        this.aliquotasUF = aliquotasUF;
    }

    @Column(name="DATA_INICIAL")
    @Temporal(value=TemporalType.DATE)
    public Date getDataInicial() {
        return this.dataInicial;
    }

    public void setDataInicial(Date dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Column(name="DATA_FINAL")
    @Temporal(value=TemporalType.DATE)
    public Date getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    @OneToMany(mappedBy="ncm")
    public List<GrupoNCMRelNCM> getGrupoNCMRel() {
        return this.grupoNCMRel;
    }

    public void setGrupoNCMRel(List<GrupoNCMRelNCM> grupoNCMRel) {
        this.grupoNCMRel = grupoNCMRel;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_REINF_COD_ATIVIDADE_ECON", foreignKey=@ForeignKey(name="FK_NCM_REINF_COD_ATIV_ECON"))
    public ReinfCodAtividadeEconomica getReinfCodAtividadeEconomica() {
        return this.reinfCodAtividadeEconomica;
    }

    public void setReinfCodAtividadeEconomica(ReinfCodAtividadeEconomica reinfCodAtividadeEconomica) {
        this.reinfCodAtividadeEconomica = reinfCodAtividadeEconomica;
    }

    @OneToMany(mappedBy="ncm", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<ParamReceitaPisCofinsNatReceita> getNaturezasReceita() {
        return this.naturezasReceita;
    }

    public void setNaturezasReceita(List<ParamReceitaPisCofinsNatReceita> naturezasReceita) {
        this.naturezasReceita = naturezasReceita;
    }

    @OneToMany(mappedBy="ncm", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<RegraExcecaoCbsIbs> getRegrasExcecoesCbsIbs() {
        return this.regrasExcecoesCbsIbs;
    }

    public void setRegrasExcecoesCbsIbs(List<RegraExcecaoCbsIbs> regrasExcecoesCbsIbs) {
        this.regrasExcecoesCbsIbs = regrasExcecoesCbsIbs;
    }
}

