/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.annotations.tests.Ignore;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ApuracaoLocacaoContrato;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoApuracaoLocacao;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.NotaContratoLocacaoBem;
import com.touchcomp.basementor.model.vo.NotaContratoLocacaoFuncao;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.RepresentanteContratoComissao;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="NOTA_CONTRATO_LOCACAO", uniqueConstraints={@UniqueConstraint(name="UNQ1_NOTA_CONTRATO_LOCACAO", columnNames={"ID_APURACAO_LOCACAO_CONTRATO"})})
public class NotaContratoLocacao
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Long numero;
    private Date dataEmissao;
    private ApuracaoLocacaoContrato apuracaoLocacaoContrato;
    private UnidadeFatCliente unidadeFatCliente;
    private List<NotaContratoLocacaoBem> notaContratoLocacaoBens = new ArrayList<NotaContratoLocacaoBem>();
    private List<NotaContratoLocacaoFuncao> notaContratoLocacaoFuncoes = new ArrayList<NotaContratoLocacaoFuncao>();
    private Double valorTotal = 0.0;
    private Double valorDesconto = 0.0;
    private Double valorTotalLiquido = 0.0;
    private CondicoesPagamento condicoesPagamento;
    private String parcelas;
    private List<Titulo> titulos = new ArrayList<Titulo>();
    private Short gerarFinanceiro = 0;
    private Short gerarContabil = 0;
    private PlanoContaGerencial planoContaGerencial;
    private LoteContabil loteContabil;
    private String observacao;
    private Short cancelada = 0;
    private String motivoCancelamento;
    private Double percComissao = 0.0;
    private List<RepresentanteContratoComissao> representantesComissao = new ArrayList<RepresentanteContratoComissao>();
    private GrupoApuracaoLocacao grupoApuracaoLocacao;

    @Id
    @Column(nullable=false, name="ID_NOTA_CONTRATO_LOCACAO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_NOTA_CONTRATO_LOCACAO")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_NOTA_CONTRATO_LOC_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Ignore
    @Column(name="NUMERO")
    @Generated(value=GenerationTime.ALWAYS)
    public Long getNumero() {
        return this.numero;
    }

    public void setNumero(Long numero) {
        this.numero = numero;
    }

    @Column(name="DATA_EMISSAO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(Date dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_APURACAO_LOCACAO_CONTRATO", foreignKey=@ForeignKey(name="FK_NOTA_CONTRATO_LOC_APUR_LOCA"))
    public ApuracaoLocacaoContrato getApuracaoLocacaoContrato() {
        return this.apuracaoLocacaoContrato;
    }

    public void setApuracaoLocacaoContrato(ApuracaoLocacaoContrato apuracaoLocacaoContrato) {
        this.apuracaoLocacaoContrato = apuracaoLocacaoContrato;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return this.getNumero() != null ? ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getNumero()}) : "";
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_UNIDADE_FAT_CLIENTE", foreignKey=@ForeignKey(name="FK_NOTA_CONTRATO_LOC_UNID_FAT_C"))
    public UnidadeFatCliente getUnidadeFatCliente() {
        return this.unidadeFatCliente;
    }

    public void setUnidadeFatCliente(UnidadeFatCliente unidadeFatCliente) {
        this.unidadeFatCliente = unidadeFatCliente;
    }

    @OneToMany(mappedBy="notaContratoLocacao", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<NotaContratoLocacaoBem> getNotaContratoLocacaoBens() {
        return this.notaContratoLocacaoBens;
    }

    public void setNotaContratoLocacaoBens(List<NotaContratoLocacaoBem> notaContratoLocacaoBens) {
        this.notaContratoLocacaoBens = notaContratoLocacaoBens;
    }

    @Column(name="VALOR_TOTAL", precision=15, scale=2)
    public Double getValorTotal() {
        return this.valorTotal;
    }

    public void setValorTotal(Double valorTotal) {
        this.valorTotal = valorTotal;
    }

    @Column(name="VALOR_DESCONTO", precision=15, scale=2)
    public Double getValorDesconto() {
        return this.valorDesconto;
    }

    public void setValorDesconto(Double valorDesconto) {
        this.valorDesconto = valorDesconto;
    }

    @Column(name="VALOR_TOTAL_LIQUIDO", precision=15, scale=2)
    public Double getValorTotalLiquido() {
        return this.valorTotalLiquido;
    }

    public void setValorTotalLiquido(Double valorTotalLiquido) {
        this.valorTotalLiquido = valorTotalLiquido;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONDICOES_PAGAMENTO", foreignKey=@ForeignKey(name="FK_NOTA_CONTRATO_LOC_COND_PAGAM"))
    public CondicoesPagamento getCondicoesPagamento() {
        return this.condicoesPagamento;
    }

    public void setCondicoesPagamento(CondicoesPagamento condicoesPagamento) {
        this.condicoesPagamento = condicoesPagamento;
    }

    @Column(name="PARCELAS", length=100)
    public String getParcelas() {
        return this.parcelas;
    }

    public void setParcelas(String parcelas) {
        this.parcelas = parcelas;
    }

    @OneToMany(mappedBy="notaContratoLocacao", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<Titulo> getTitulos() {
        return this.titulos;
    }

    public void setTitulos(List<Titulo> titulos) {
        this.titulos = titulos;
    }

    @Column(name="GERAR_FINANCEIRO")
    public Short getGerarFinanceiro() {
        return this.gerarFinanceiro;
    }

    public void setGerarFinanceiro(Short gerarFinanceiro) {
        this.gerarFinanceiro = gerarFinanceiro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_GERENCIAL", foreignKey=@ForeignKey(name="FK_NOTA_CONTRATO_LOC_PC_GERENCI"))
    public PlanoContaGerencial getPlanoContaGerencial() {
        return this.planoContaGerencial;
    }

    public void setPlanoContaGerencial(PlanoContaGerencial planoContaGerencial) {
        this.planoContaGerencial = planoContaGerencial;
    }

    @JoinColumn(name="ID_LOTE_CONTABIL", foreignKey=@ForeignKey(name="FK_NOTA_CONTRATO_LOC_LOTE_CONT"))
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    @ManyToOne(fetch=FetchType.LAZY)
    public LoteContabil getLoteContabil() {
        return this.loteContabil;
    }

    public void setLoteContabil(LoteContabil loteContabil) {
        this.loteContabil = loteContabil;
    }

    @Column(name="GERAR_CONTABIL")
    public Short getGerarContabil() {
        return this.gerarContabil;
    }

    public void setGerarContabil(Short gerarContabil) {
        this.gerarContabil = gerarContabil;
    }

    @Column(name="OBSERVACAO", length=1000)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Column(name="CANCELADA")
    public Short getCancelada() {
        return this.cancelada;
    }

    public void setCancelada(Short cancelada) {
        this.cancelada = cancelada;
    }

    @Column(name="MOTIVO_CANCELAMENTO", length=200)
    public String getMotivoCancelamento() {
        return this.motivoCancelamento;
    }

    public void setMotivoCancelamento(String motivoCancelamento) {
        this.motivoCancelamento = motivoCancelamento;
    }

    @Column(nullable=false, name="PERC_COMISSAO", precision=15, scale=4)
    public Double getPercComissao() {
        return this.percComissao;
    }

    public void setPercComissao(Double percComissao) {
        this.percComissao = percComissao;
    }

    @OneToMany(mappedBy="notaContratoLocacao", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.SAVE_UPDATE, CascadeType.REFRESH, CascadeType.MERGE})
    public List<RepresentanteContratoComissao> getRepresentantesComissao() {
        return this.representantesComissao;
    }

    public void setRepresentantesComissao(List<RepresentanteContratoComissao> representantesComissao) {
        this.representantesComissao = representantesComissao;
    }

    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRUPO_APURACAO", foreignKey=@ForeignKey(name="FK_NOTA_CONTRATO_LOC_GR_APURACA"))
    public GrupoApuracaoLocacao getGrupoApuracaoLocacao() {
        return this.grupoApuracaoLocacao;
    }

    public void setGrupoApuracaoLocacao(GrupoApuracaoLocacao grupoApuracaoLocacao) {
        this.grupoApuracaoLocacao = grupoApuracaoLocacao;
    }

    @OneToMany(mappedBy="notaContratoLocacao", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<NotaContratoLocacaoFuncao> getNotaContratoLocacaoFuncoes() {
        return this.notaContratoLocacaoFuncoes;
    }

    public void setNotaContratoLocacaoFuncoes(List<NotaContratoLocacaoFuncao> notaContratoLocacaoFuncoes) {
        this.notaContratoLocacaoFuncoes = notaContratoLocacaoFuncoes;
    }
}

