/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.Embalagem;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.OpcoesEstoqueOp;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="OPCOES_ESTOQUE")
public class OpcoesEstoque
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private Date dataCadastro;
    private CondicoesPagamento condicoesPagamentoTransfNF;
    private NaturezaOperacao naturezaOperacaoTransfNF;
    private Short usarParamCentEstEspecie = 1;
    private Short usarParamCentEstSubespecie = 0;
    private Short usarParamCentEstUsuario = 0;
    private Short usarParamCentEstCliente = 0;
    private Short usarParamCentEstNatOperacao = 0;
    private Short usarParamCentEstLocProdCenEst = 0;
    private Short usarParamCentEstFornecedor = 0;
    private Short calcVolAutoFaturarPreFat = 0;
    private Short permitirAtendPedAlmoxQtdMaior = 0;
    private String customSugestCentEst;
    private Embalagem embalagemPreFat;
    private Timestamp dataAtualizacao;
    private Double vlrToleranciaEstQtd = 1.0E-6;
    private Double vlrToleranciaEstVlr = 1.0E-6;
    private Short permitirEstoqueNegVlr = 0;
    private Short permitirEstoqueNegQtd = 0;
    private Integer diasDeToleranciaMovimentacaoFutura = 0;
    private List<OpcoesEstoqueOp> opcoesEstoqueOp = new LinkedList<OpcoesEstoqueOp>();

    @Id
    @Column(name="ID_OPCOES_ESTOQUE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_OPCOES_ESTOQUE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_OPCOES_ESTOQUE_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COND_PAGAMENTO_TRANSF_NF", foreignKey=@ForeignKey(name="FK_OPCOES_ESTOQUE_COND_PAGAMENT"))
    public CondicoesPagamento getCondicoesPagamentoTransfNF() {
        return this.condicoesPagamentoTransfNF;
    }

    public void setCondicoesPagamentoTransfNF(CondicoesPagamento condicoesPagamentoTransfNF) {
        this.condicoesPagamentoTransfNF = condicoesPagamentoTransfNF;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NATUREZA_OPERACAO_TR_NF", foreignKey=@ForeignKey(name="FK_OPCOES_ESTOQUE_NAT_OP_TRANSF"))
    public NaturezaOperacao getNaturezaOperacaoTransfNF() {
        return this.naturezaOperacaoTransfNF;
    }

    public void setNaturezaOperacaoTransfNF(NaturezaOperacao naturezaOperacaoTransfNF) {
        this.naturezaOperacaoTransfNF = naturezaOperacaoTransfNF;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="USAR_PARAM_CENT_EST_ESPECIE")
    public Short getUsarParamCentEstEspecie() {
        return this.usarParamCentEstEspecie;
    }

    public void setUsarParamCentEstEspecie(Short usarParamCentEstEspecie) {
        this.usarParamCentEstEspecie = usarParamCentEstEspecie;
    }

    @Column(name="USAR_PARAM_CENT_EST_SUBESPECIE")
    public Short getUsarParamCentEstSubespecie() {
        return this.usarParamCentEstSubespecie;
    }

    public void setUsarParamCentEstSubespecie(Short usarParamCentEstSubespecie) {
        this.usarParamCentEstSubespecie = usarParamCentEstSubespecie;
    }

    @Column(name="USAR_PARAM_CENT_EST_USUARIO")
    public Short getUsarParamCentEstUsuario() {
        return this.usarParamCentEstUsuario;
    }

    public void setUsarParamCentEstUsuario(Short usarParamCentEstUsuario) {
        this.usarParamCentEstUsuario = usarParamCentEstUsuario;
    }

    @Column(name="USAR_PARAM_CENT_EST_CLIENTE")
    public Short getUsarParamCentEstCliente() {
        return this.usarParamCentEstCliente;
    }

    public void setUsarParamCentEstCliente(Short usarParamCentEstCliente) {
        this.usarParamCentEstCliente = usarParamCentEstCliente;
    }

    @Column(name="USAR_PARAM_CENT_EST_NAT_OP")
    public Short getUsarParamCentEstNatOperacao() {
        return this.usarParamCentEstNatOperacao;
    }

    public void setUsarParamCentEstNatOperacao(Short usarParamCentEstNatOperacao) {
        this.usarParamCentEstNatOperacao = usarParamCentEstNatOperacao;
    }

    @Column(name="USAR_PARAM_CENT_EST_LOC_PR_CEN")
    public Short getUsarParamCentEstLocProdCenEst() {
        return this.usarParamCentEstLocProdCenEst;
    }

    public void setUsarParamCentEstLocProdCenEst(Short usarParamCentEstLocProdCenEst) {
        this.usarParamCentEstLocProdCenEst = usarParamCentEstLocProdCenEst;
    }

    @Column(name="USAR_PARAM_CENT_EST_FORN")
    public Short getUsarParamCentEstFornecedor() {
        return this.usarParamCentEstFornecedor;
    }

    public void setUsarParamCentEstFornecedor(Short usarParamCentEstFornecedor) {
        this.usarParamCentEstFornecedor = usarParamCentEstFornecedor;
    }

    @Column(name="CALC_VOL_AUTO_FAT_PRE_FAT")
    public Short getCalcVolAutoFaturarPreFat() {
        return this.calcVolAutoFaturarPreFat;
    }

    public void setCalcVolAutoFaturarPreFat(Short calcVolAutoFaturarPreFat) {
        this.calcVolAutoFaturarPreFat = calcVolAutoFaturarPreFat;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMBALAGEM_PRE_FAT", foreignKey=@ForeignKey(name="FK_OPCOES_ESTOQUE_EMBALAGEM"))
    public Embalagem getEmbalagemPreFat() {
        return this.embalagemPreFat;
    }

    public void setEmbalagemPreFat(Embalagem embalagemPreFat) {
        this.embalagemPreFat = embalagemPreFat;
    }

    @Column(name="PERM_ATEND_PED_ALMOX_QTD_MAIOR")
    public Short getPermitirAtendPedAlmoxQtdMaior() {
        return this.permitirAtendPedAlmoxQtdMaior;
    }

    public void setPermitirAtendPedAlmoxQtdMaior(Short permitirAtendPedAlmoxQtdMaior) {
        this.permitirAtendPedAlmoxQtdMaior = permitirAtendPedAlmoxQtdMaior;
    }

    @Column(name="CUSTOM_SUGEST_CENT_EST", length=100)
    public String getCustomSugestCentEst() {
        return this.customSugestCentEst;
    }

    public void setCustomSugestCentEst(String customSugestCentEst) {
        this.customSugestCentEst = customSugestCentEst;
    }

    @Column(name="VLR_TOL_ESTOQUE_NEG_QTD", precision=15, scale=6)
    public Double getVlrToleranciaEstQtd() {
        return this.vlrToleranciaEstQtd;
    }

    public void setVlrToleranciaEstQtd(Double vlrToleranciaEstQtd) {
        this.vlrToleranciaEstQtd = vlrToleranciaEstQtd;
    }

    @Column(name="VLR_TOL_ESTOQUE_NEG_VLR", precision=15, scale=6)
    public Double getVlrToleranciaEstVlr() {
        return this.vlrToleranciaEstVlr;
    }

    public void setVlrToleranciaEstVlr(Double vlrToleranciaEstVlr) {
        this.vlrToleranciaEstVlr = vlrToleranciaEstVlr;
    }

    @Column(name="PERMITIR_ESTOQUE_NEG_VLR")
    public Short getPermitirEstoqueNegVlr() {
        return this.permitirEstoqueNegVlr;
    }

    public void setPermitirEstoqueNegVlr(Short permitirEstoqueNegVlr) {
        this.permitirEstoqueNegVlr = permitirEstoqueNegVlr;
    }

    @Column(name="PERMITIR_ESTOQUE_NEG_QTD")
    public Short getPermitirEstoqueNegQtd() {
        return this.permitirEstoqueNegQtd;
    }

    public void setPermitirEstoqueNegQtd(Short permitirEstoqueNegQtd) {
        this.permitirEstoqueNegQtd = permitirEstoqueNegQtd;
    }

    @Column(name="DIAS_TOLERANCIA_MOV_FUTURA")
    public Integer getDiasDeToleranciaMovimentacaoFutura() {
        return this.diasDeToleranciaMovimentacaoFutura;
    }

    public void setDiasDeToleranciaMovimentacaoFutura(Integer diasDeToleranciaMovimentacaoFutura) {
        this.diasDeToleranciaMovimentacaoFutura = diasDeToleranciaMovimentacaoFutura;
    }

    @OneToMany(mappedBy="opcoesEstoque", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<OpcoesEstoqueOp> getOpcoesEstoqueOp() {
        return this.opcoesEstoqueOp;
    }

    public void setOpcoesEstoqueOp(List<OpcoesEstoqueOp> opcoesEstoqueOp) {
        this.opcoesEstoqueOp = opcoesEstoqueOp;
    }
}

