/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.HistoricoPadrao;
import com.touchcomp.basementor.model.vo.OpcoesPatrimonioIncidenciaIcmsTotal;
import com.touchcomp.basementor.model.vo.OpcoesPatrimonioIncidenciaIcmsTrib;
import com.touchcomp.basementor.model.vo.OpcoesPatrimonioOp;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="OPCOES_PATRIMONIO")
public class OpcoesPatrimonio
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private PlanoConta planoContaLucro;
    private PlanoConta planoContaPrejuizo;
    private PlanoConta planoContaCustoDeb;
    private PlanoConta planoContaCustoCred;
    private PlanoConta planoContaDepreAcum;
    private HistoricoPadrao historicoBaixaBem;
    private HistoricoPadrao historicoDepreAcum;
    private List<OpcoesPatrimonioIncidenciaIcmsTotal> incidenciaIcmsTotais = new ArrayList<OpcoesPatrimonioIncidenciaIcmsTotal>();
    private List<OpcoesPatrimonioIncidenciaIcmsTrib> incidenciaIcmsTrib = new ArrayList<OpcoesPatrimonioIncidenciaIcmsTrib>();
    private Short abaterIcmsStTotal = 0;
    private Short abaterIpiTotal = 0;
    private Short abaterDevolucaoVendasTotal = 0;
    private Short naoIncluirIndustrializacaoTotal = 0;
    private Short naoIncluirTransferenciaTotal = 0;
    private Short abaterIcmsStTrib = 0;
    private Short abaterIpiTrib = 0;
    private Short abaterDevolucaoVendasTrib = 0;
    private Short naoIncluirIndustrializacaoTrib = 0;
    private Short naoIncluirTransferenciaTrib = 0;
    private Short incluirExportacoesTrib = 0;
    private Short habRecCiapBemDepreciacaoCiap = 0;
    private PlanoConta planoContaPisCred;
    private PlanoConta planoContaCofinsCred;
    private PlanoConta planoContaPisDeb;
    private PlanoConta planoContaCofinsDeb;
    private HistoricoPadrao historicoPis;
    private HistoricoPadrao historicoCofins;
    private List<OpcoesPatrimonioOp> opcoesPatrimonioOp = new LinkedList<OpcoesPatrimonioOp>();

    @Id
    @Column(name="ID_OPCOES_PATRIMONIO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_OPCOES_PATRIMONIO")
    public Long getIdentificador() {
        return this.identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_OPCOES_PATRIMONIO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_LUCRO", foreignKey=@ForeignKey(name="FK_OPCOES_PATRIMONIO_PC_LUCRO"))
    public PlanoConta getPlanoContaLucro() {
        return this.planoContaLucro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_PREJUIZO", foreignKey=@ForeignKey(name="FK_OPCOES_PATRIMONIO_PC_PREJUI"))
    public PlanoConta getPlanoContaPrejuizo() {
        return this.planoContaPrejuizo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_CUSTO_DEB", foreignKey=@ForeignKey(name="FK_OPCOES_PATRIMONIO_PC_DEB"))
    public PlanoConta getPlanoContaCustoDeb() {
        return this.planoContaCustoDeb;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_CUSTO_CRED", foreignKey=@ForeignKey(name="FK_OPCOES_PATRIMONIO_PC_CRED"))
    public PlanoConta getPlanoContaCustoCred() {
        return this.planoContaCustoCred;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_DEPRE_ACUM", foreignKey=@ForeignKey(name="FK_OPCOES_PATRIMONIO_PC_DEPRE_ACUM"))
    public PlanoConta getPlanoContaDepreAcum() {
        return this.planoContaDepreAcum;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_HISTORICO_BAIXA_BEM", foreignKey=@ForeignKey(name="FK_OPCOES_PATRIMONIO_HIST_BX_BEM"))
    public HistoricoPadrao getHistoricoBaixaBem() {
        return this.historicoBaixaBem;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_HISTORICO_DEPRE_ACUM", foreignKey=@ForeignKey(name="FK_OPCOES_PATRIMONIO_HIST_DEP_ACUM"))
    public HistoricoPadrao getHistoricoDepreAcum() {
        return this.historicoDepreAcum;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public void setPlanoContaLucro(PlanoConta planoContaLucro) {
        this.planoContaLucro = planoContaLucro;
    }

    public void setPlanoContaPrejuizo(PlanoConta planoContaPrejuizo) {
        this.planoContaPrejuizo = planoContaPrejuizo;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToMany(mappedBy="opcoesPatrimonio", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<OpcoesPatrimonioIncidenciaIcmsTotal> getIncidenciaIcmsTotais() {
        return this.incidenciaIcmsTotais;
    }

    public void setIncidenciaIcmsTotais(List<OpcoesPatrimonioIncidenciaIcmsTotal> incidenciaIcmsTotais) {
        this.incidenciaIcmsTotais = incidenciaIcmsTotais;
    }

    @OneToMany(mappedBy="opcoesPatrimonio", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<OpcoesPatrimonioIncidenciaIcmsTrib> getIncidenciaIcmsTrib() {
        return this.incidenciaIcmsTrib;
    }

    public void setIncidenciaIcmsTrib(List<OpcoesPatrimonioIncidenciaIcmsTrib> incidenciaIcmsTrib) {
        this.incidenciaIcmsTrib = incidenciaIcmsTrib;
    }

    @Column(name="ABATER_ICMS_ST_TOTAL")
    public Short getAbaterIcmsStTotal() {
        return this.abaterIcmsStTotal;
    }

    public void setAbaterIcmsStTotal(Short abaterIcmsStTotal) {
        this.abaterIcmsStTotal = abaterIcmsStTotal;
    }

    @Column(name="ABATER_IPI_TOTAL")
    public Short getAbaterIpiTotal() {
        return this.abaterIpiTotal;
    }

    public void setAbaterIpiTotal(Short abaterIpiTotal) {
        this.abaterIpiTotal = abaterIpiTotal;
    }

    @Column(name="ABATER_DEV_VENDAS_TOTAL")
    public Short getAbaterDevolucaoVendasTotal() {
        return this.abaterDevolucaoVendasTotal;
    }

    public void setAbaterDevolucaoVendasTotal(Short abaterDevolucaoVendasTotal) {
        this.abaterDevolucaoVendasTotal = abaterDevolucaoVendasTotal;
    }

    @Column(name="NAO_INCLUIR_INDUST_TOTAL")
    public Short getNaoIncluirIndustrializacaoTotal() {
        return this.naoIncluirIndustrializacaoTotal;
    }

    public void setNaoIncluirIndustrializacaoTotal(Short naoIncluirIndustrializacaoTotal) {
        this.naoIncluirIndustrializacaoTotal = naoIncluirIndustrializacaoTotal;
    }

    @Column(name="NAO_INCLUIR_TRANSF_TOTAL")
    public Short getNaoIncluirTransferenciaTotal() {
        return this.naoIncluirTransferenciaTotal;
    }

    public void setNaoIncluirTransferenciaTotal(Short naoIncluirTransferenciaTotal) {
        this.naoIncluirTransferenciaTotal = naoIncluirTransferenciaTotal;
    }

    @Column(name="ABATER_ICMS_ST_TRIB")
    public Short getAbaterIcmsStTrib() {
        return this.abaterIcmsStTrib;
    }

    public void setAbaterIcmsStTrib(Short abaterIcmsStTrib) {
        this.abaterIcmsStTrib = abaterIcmsStTrib;
    }

    @Column(name="ABATER_IPI_TRIB")
    public Short getAbaterIpiTrib() {
        return this.abaterIpiTrib;
    }

    public void setAbaterIpiTrib(Short abaterIpiTrib) {
        this.abaterIpiTrib = abaterIpiTrib;
    }

    @Column(name="ABATER_DEV_VENDAS_TRIB")
    public Short getAbaterDevolucaoVendasTrib() {
        return this.abaterDevolucaoVendasTrib;
    }

    public void setAbaterDevolucaoVendasTrib(Short abaterDevolucaoVendasTrib) {
        this.abaterDevolucaoVendasTrib = abaterDevolucaoVendasTrib;
    }

    @Column(name="NAO_INCLUIR_INDUST_TRIB")
    public Short getNaoIncluirIndustrializacaoTrib() {
        return this.naoIncluirIndustrializacaoTrib;
    }

    public void setNaoIncluirIndustrializacaoTrib(Short naoIncluirIndustrializacaoTrib) {
        this.naoIncluirIndustrializacaoTrib = naoIncluirIndustrializacaoTrib;
    }

    @Column(name="NAO_INCLUIR_TRANSF_TRIB")
    public Short getNaoIncluirTransferenciaTrib() {
        return this.naoIncluirTransferenciaTrib;
    }

    public void setNaoIncluirTransferenciaTrib(Short naoIncluirTransferenciaTrib) {
        this.naoIncluirTransferenciaTrib = naoIncluirTransferenciaTrib;
    }

    @Column(name="INCLUIR_EXPORTACAO_TRIB")
    public Short getIncluirExportacoesTrib() {
        return this.incluirExportacoesTrib;
    }

    public void setIncluirExportacoesTrib(Short incluirExportacoesTrib) {
        this.incluirExportacoesTrib = incluirExportacoesTrib;
    }

    @Column(name="HAB_REC_CIAP_BEM_DEPREC_CIAP")
    public Short getHabRecCiapBemDepreciacaoCiap() {
        return this.habRecCiapBemDepreciacaoCiap;
    }

    public void setHabRecCiapBemDepreciacaoCiap(Short habRecCiapBemDepreciacaoCiap) {
        this.habRecCiapBemDepreciacaoCiap = habRecCiapBemDepreciacaoCiap;
    }

    public void setHistoricoDepreAcum(HistoricoPadrao historicoDepreAcum) {
        this.historicoDepreAcum = historicoDepreAcum;
    }

    public void setHistoricoBaixaBem(HistoricoPadrao historicoBaixaBem) {
        this.historicoBaixaBem = historicoBaixaBem;
    }

    public void setPlanoContaDepreAcum(PlanoConta planoContaDepreAcum) {
        this.planoContaDepreAcum = planoContaDepreAcum;
    }

    public void setPlanoContaCustoCred(PlanoConta planoContaCustoCred) {
        this.planoContaCustoCred = planoContaCustoCred;
    }

    public void setPlanoContaCustoDeb(PlanoConta planoContaCustoDeb) {
        this.planoContaCustoDeb = planoContaCustoDeb;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_PIS_CRED", foreignKey=@ForeignKey(name="FK_OPCOES_PATRIMONIO_PC_PC_C"))
    public PlanoConta getPlanoContaPisCred() {
        return this.planoContaPisCred;
    }

    public void setPlanoContaPisCred(PlanoConta planoContaPisCred) {
        this.planoContaPisCred = planoContaPisCred;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_COFINS_CRED", foreignKey=@ForeignKey(name="FK_OPCOES_PATRIMONIO_PC_PC_C"))
    public PlanoConta getPlanoContaCofinsCred() {
        return this.planoContaCofinsCred;
    }

    public void setPlanoContaCofinsCred(PlanoConta planoContaCofinsCred) {
        this.planoContaCofinsCred = planoContaCofinsCred;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_PIS_DEB", foreignKey=@ForeignKey(name="FK_OPCOES_PATRIMONIO_PC_PC_C"))
    public PlanoConta getPlanoContaPisDeb() {
        return this.planoContaPisDeb;
    }

    public void setPlanoContaPisDeb(PlanoConta planoContaPisDeb) {
        this.planoContaPisDeb = planoContaPisDeb;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_COFINS_DEB", foreignKey=@ForeignKey(name="FK_OPCOES_PATRIMONIO_PC_PC_C"))
    public PlanoConta getPlanoContaCofinsDeb() {
        return this.planoContaCofinsDeb;
    }

    public void setPlanoContaCofinsDeb(PlanoConta planoContaCofinsDeb) {
        this.planoContaCofinsDeb = planoContaCofinsDeb;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_HISTORICO_PIS", foreignKey=@ForeignKey(name="FK_OPCOES_PATRIMONIO_HIS_PC_C"))
    public HistoricoPadrao getHistoricoPis() {
        return this.historicoPis;
    }

    public void setHistoricoPis(HistoricoPadrao historicoPis) {
        this.historicoPis = historicoPis;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_HISTORICO_COFINS", foreignKey=@ForeignKey(name="FK_OPCOES_PATRIMONIO_HIS_PC_C"))
    public HistoricoPadrao getHistoricoCofins() {
        return this.historicoCofins;
    }

    public void setHistoricoCofins(HistoricoPadrao historicoCofins) {
        this.historicoCofins = historicoCofins;
    }

    @OneToMany(mappedBy="opcoesPatrimonio", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<OpcoesPatrimonioOp> getOpcoesPatrimonioOp() {
        return this.opcoesPatrimonioOp;
    }

    public void setOpcoesPatrimonioOp(List<OpcoesPatrimonioOp> opcoesPatrimonioOp) {
        this.opcoesPatrimonioOp = opcoesPatrimonioOp;
    }
}

