/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.ClassificacaoOrdemCompra;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.Cotacao;
import com.touchcomp.basementor.model.vo.CotacaoCompra;
import com.touchcomp.basementor.model.vo.EmailsOrdemCompra;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.ItemOrdemCompra;
import com.touchcomp.basementor.model.vo.LiberacaoOrdemCompra;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementor.model.vo.ObservacaoOrdemCompra;
import com.touchcomp.basementor.model.vo.OrdemCompraVencimentos;
import com.touchcomp.basementor.model.vo.RecepcaoMercadorias;
import com.touchcomp.basementor.model.vo.StatusOrdemCompra;
import com.touchcomp.basementor.model.vo.TipoFrete;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.Transportador;
import com.touchcomp.basementor.model.vo.UnidadeFatFornecedor;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;

@Entity
@Table(name="ORDEM_COMPRA")
public class OrdemCompra
implements InterfaceVO {
    private Long identificador;
    private String motivoCancelamento;
    private String parcelas;
    private String observacao;
    private String pessoaContato;
    private String prazoEntrega;
    private Date dataPrevFaturamento;
    private Date dataPrevChegada;
    private Date dataEmissao;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Double valorTotal = 0.0;
    private Double valorDesconto = 0.0;
    private Double valorFrete = 0.0;
    private Double valorSeguro = 0.0;
    private Double valorDespAcess = 0.0;
    private Double valorProduto = 0.0;
    private Double valorServico = 0.0;
    private Double valorIpiIsento = 0.0;
    private Double valorIpiOutros = 0.0;
    private Double valorIpiTributado = 0.0;
    private Double valorIpiObservacao = 0.0;
    private Double valorIpiIndustria = 0.0;
    private Double valorIcms = 0.0;
    private Double valorIcmsSa = 0.0;
    private Double bcIcmsSt = 0.0;
    private Double valorIcmsSt = 0.0;
    private Double valorLei10833 = 0.0;
    private Double valorInss = 0.0;
    private Double valorIss = 0.0;
    private Double valorFunrural = 0.0;
    private Double valorPis = 0.0;
    private Double valorCofins = 0.0;
    private Double valorContSoc = 0.0;
    private Double valorOutros = 0.0;
    private Double valorSestSenat = 0.0;
    private Double valorIrrf = 0.0;
    private Double valorIcmsIsento = 0.0;
    private Double valorIcmsTributado = 0.0;
    private Double valorIcmsOutros = 0.0;
    private Double valorAgregado = 0.0;
    private Usuario usuario;
    private Empresa empresa;
    private Cotacao cotacao;
    private CotacaoCompra cotacaoCompra;
    private TipoFrete tipoFrete;
    private Transportador transportador;
    private CondicoesPagamento condicaoPagamento;
    private UnidadeFatFornecedor unidadeFatFornecedor;
    private LiberacaoOrdemCompra liberacaoOrdemCompra;
    private List<Titulo> titulos = new ArrayList<Titulo>();
    private List<ItemOrdemCompra> itemOrdemCompra;
    private List<RecepcaoMercadorias> recepcaoMercadorias;
    private List<ObservacaoOrdemCompra> observacoes = new ArrayList<ObservacaoOrdemCompra>();
    private List<OrdemCompraVencimentos> vencimentosOrdemCompra;
    private Long prazoMaxEntregaItens = 0L;
    private Double valorPisST = 0.0;
    private Double valorCofinsST = 0.0;
    private Short tipoDescontoInf = 1;
    private Short tipoFreteInf = 1;
    private Short tipoSeguroInf = 1;
    private Short tipoDespAcessInf = 1;
    private Double percFreteInf = 0.0;
    private Double valorFreteInf = 0.0;
    private Double percDescontoInf = 0.0;
    private Double valorDescontoInf = 0.0;
    private Double percSeguroInf = 0.0;
    private Double valorSeguroInf = 0.0;
    private Double percDespAcessoriaInf = 0.0;
    private Double valorDespAcessoriaInf = 0.0;
    private List<EmailsOrdemCompra> emailsOrdemCompra;
    private MeioPagamento meioPagamento;
    private Short tipoDataTitulo = 1;
    private ClassificacaoOrdemCompra classificacaoOC;
    private StatusOrdemCompra statusOrdemCompra;
    private Short liberada;
    private Short informarEnderecoEntrega;
    private Endereco enderecoEntrega;

    public OrdemCompra() {
        this.itemOrdemCompra = new ArrayList<ItemOrdemCompra>();
        this.recepcaoMercadorias = new ArrayList<RecepcaoMercadorias>();
        this.vencimentosOrdemCompra = new ArrayList<OrdemCompraVencimentos>();
        this.emailsOrdemCompra = new ArrayList<EmailsOrdemCompra>();
        this.liberada = EnumConstantsMentorSimNao.NAO.getValue();
        this.informarEnderecoEntrega = EnumConstantsMentorSimNao.NAO.getValue();
    }

    @Id
    @Column(name="ID_ORDEM_COMPRA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_ORDEM_COMPRA")
    public Long getIdentificador() {
        return this.identificador;
    }

    @OneToMany(targetEntity=ObservacaoOrdemCompra.class, mappedBy="ordemCompra")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ObservacaoOrdemCompra> getObservacoes() {
        return this.observacoes;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_CONDICOES_PAGAMENTO", foreignKey=@ForeignKey(name="FK_ORDEM_COMPRA_COND_PAG"))
    public CondicoesPagamento getCondicaoPagamento() {
        return this.condicaoPagamento;
    }

    @Column(name="DATA_PREV_CHEGADA")
    @Temporal(value=TemporalType.DATE)
    public Date getDataPrevChegada() {
        return this.dataPrevChegada;
    }

    @Column(name="DATA_PREV_FATURAMENTO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataPrevFaturamento() {
        return this.dataPrevFaturamento;
    }

    @Column(name="PESSOA_CONTATO", length=40)
    public String getPessoaContato() {
        return this.pessoaContato;
    }

    @Column(name="PRAZO_ENTREGA", length=30)
    public String getPrazoEntrega() {
        return this.prazoEntrega;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TRANSPORTADOR", foreignKey=@ForeignKey(name="FK_ORDEM_COMPRA_TRANSP"))
    public Transportador getTransportador() {
        return this.transportador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_UNIDADE_FAT_FORN", foreignKey=@ForeignKey(name="FK_ORDEM_COMPRA_UN_FAT_FORN"))
    public UnidadeFatFornecedor getUnidadeFatFornecedor() {
        return this.unidadeFatFornecedor;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="ordemCompra", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<Titulo> getTitulos() {
        return this.titulos;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COTACAO", foreignKey=@ForeignKey(name="FK_ORDEM_COMPRA_COTACAO"))
    public Cotacao getCotacao() {
        return this.cotacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_COTACAO_COMPRA", foreignKey=@ForeignKey(name="FK_ORDEM_COMPRA_COTACAO_COMPRA"))
    public CotacaoCompra getCotacaoCompra() {
        return this.cotacaoCompra;
    }

    @ManyToMany(targetEntity=RecepcaoMercadorias.class)
    @JoinTable(name="rec_mercadorias_ordem_compra", joinColumns={@JoinColumn(name="id_ordem_compra")}, inverseJoinColumns={@JoinColumn(name="id_rec_mercadorias")})
    public List<RecepcaoMercadorias> getRecepcaoMercadorias() {
        return this.recepcaoMercadorias;
    }

    @ManyToOne(targetEntity=LiberacaoOrdemCompra.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.MERGE})
    @JoinColumn(name="ID_LIBERACAO_ORDEM_COMPRA", foreignKey=@ForeignKey(name="FK_ORDEM_COMPRA_LIB_OC"), unique=true)
    public LiberacaoOrdemCompra getLiberacaoOrdemCompra() {
        return this.liberacaoOrdemCompra;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_ORDEM_COMPRA_USUARIO"))
    public Usuario getUsuario() {
        return this.usuario;
    }

    @Column(name="PARCELAS", length=100)
    public String getParcelas() {
        return this.parcelas;
    }

    @JoinColumn(name="ID_TIPO_FRETE", foreignKey=@ForeignKey(name="FK_ORDEM_COMPRA_TIPO_FRETE"))
    @ManyToOne(fetch=FetchType.LAZY)
    public TipoFrete getTipoFrete() {
        return this.tipoFrete;
    }

    @Column(name="OBSERVACAO")
    public String getObservacao() {
        return this.observacao;
    }

    @Column(name="VALOR_TOTAL", precision=15, scale=2)
    public Double getValorTotal() {
        return this.valorTotal;
    }

    @Column(name="VALOR_DESCONTO", precision=15, scale=2)
    public Double getValorDesconto() {
        return this.valorDesconto;
    }

    @Column(name="VALOR_FRETE", precision=15, scale=2)
    public Double getValorFrete() {
        return this.valorFrete;
    }

    @Column(name="VALOR_SEGURO", precision=15, scale=2)
    public Double getValorSeguro() {
        return this.valorSeguro;
    }

    @Column(name="VALOR_DESP_ACESS", precision=15, scale=2)
    public Double getValorDespAcess() {
        return this.valorDespAcess;
    }

    @Column(name="VALOR_PRODUTO", precision=15, scale=2)
    public Double getValorProduto() {
        return this.valorProduto;
    }

    @Column(name="VALOR_SERVICO", precision=15, scale=2)
    public Double getValorServico() {
        return this.valorServico;
    }

    @Column(name="VALOR_IPI_ISENTO", precision=15, scale=2)
    public Double getValorIpiIsento() {
        return this.valorIpiIsento;
    }

    @Column(name="VALOR_IPI_OUTROS", precision=15, scale=2)
    public Double getValorIpiOutros() {
        return this.valorIpiOutros;
    }

    @Column(name="VALOR_IPI_TRIBUTADO", precision=15, scale=2)
    public Double getValorIpiTributado() {
        return this.valorIpiTributado;
    }

    @Column(name="VALOR_IPI_OBSERVACAO", precision=15, scale=2)
    public Double getValorIpiObservacao() {
        return this.valorIpiObservacao;
    }

    @Column(name="VALOR_IPI_INDUSTRIA", precision=15, scale=2)
    public Double getValorIpiIndustria() {
        return this.valorIpiIndustria;
    }

    @Column(name="VALOR_ICMS", precision=15, scale=2)
    public Double getValorIcms() {
        return this.valorIcms;
    }

    @Column(name="VALOR_ICMSSA", precision=15, scale=2)
    public Double getValorIcmsSa() {
        return this.valorIcmsSa;
    }

    @Column(name="VALOR_BC_ICMSST", precision=15, scale=2)
    public Double getBcIcmsSt() {
        return this.bcIcmsSt;
    }

    @Column(name="VALOR_ICMSST", precision=15, scale=2)
    public Double getValorIcmsSt() {
        return this.valorIcmsSt;
    }

    @Column(name="VALOR_LEI10833", precision=15, scale=2)
    public Double getValorLei10833() {
        return this.valorLei10833;
    }

    @Column(name="VALOR_INSS", precision=15, scale=2)
    public Double getValorInss() {
        return this.valorInss;
    }

    @Column(name="VALOR_ISS", precision=15, scale=2)
    public Double getValorIss() {
        return this.valorIss;
    }

    @Column(name="VALOR_FUNRURAL", precision=15, scale=2)
    public Double getValorFunrural() {
        return this.valorFunrural;
    }

    @Column(name="VALOR_PIS", precision=15, scale=2)
    public Double getValorPis() {
        return this.valorPis;
    }

    @Column(name="VALOR_COFINS", precision=15, scale=2)
    public Double getValorCofins() {
        return this.valorCofins;
    }

    @Column(name="VALOR_CONT_SOC", precision=15, scale=2)
    public Double getValorContSoc() {
        return this.valorContSoc;
    }

    @Column(name="VALOR_OUTROS", precision=15, scale=2)
    public Double getValorOutros() {
        return this.valorOutros;
    }

    @Column(name="VALOR_SEST_SENAT", precision=15, scale=2)
    public Double getValorSestSenat() {
        return this.valorSestSenat;
    }

    @Column(name="VALOR_IRRF", precision=15, scale=2)
    public Double getValorIrrf() {
        return this.valorIrrf;
    }

    @Column(name="VALOR_ICMS_ISENTO", precision=15, scale=2)
    public Double getValorIcmsIsento() {
        return this.valorIcmsIsento;
    }

    @Column(name="VALOR_ICMS_TRIBUTADO", precision=15, scale=2)
    public Double getValorIcmsTributado() {
        return this.valorIcmsTributado;
    }

    @Column(name="VALOR_ICMS_OUTROS", precision=15, scale=2)
    public Double getValorIcmsOutros() {
        return this.valorIcmsOutros;
    }

    @Column(name="VALOR_AGREGADO", precision=15, scale=4)
    public Double getValorAgregado() {
        return this.valorAgregado;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_EMISSAO")
    public Date getDataEmissao() {
        return this.dataEmissao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_ORDEM_COMPRA_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @OneToMany(mappedBy="ordemCompra", cascade={CascadeType.ALL})
    @LazyCollection(value=LazyCollectionOption.FALSE)
    @Cascade(value={org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ItemOrdemCompra> getItemOrdemCompra() {
        return this.itemOrdemCompra;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setParcelas(String parcelas) {
        this.parcelas = parcelas;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    public void setPessoaContato(String pessoaContato) {
        this.pessoaContato = pessoaContato;
    }

    public void setPrazoEntrega(String prazoEntrega) {
        this.prazoEntrega = prazoEntrega;
    }

    public void setDataPrevFaturamento(Date dataPrevFaturamento) {
        this.dataPrevFaturamento = dataPrevFaturamento;
    }

    public void setDataPrevChegada(Date dataPrevChegada) {
        this.dataPrevChegada = dataPrevChegada;
    }

    public void setDataEmissao(Date dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public void setValorTotal(Double valorTotal) {
        this.valorTotal = valorTotal;
    }

    public void setValorDesconto(Double valorDesconto) {
        this.valorDesconto = valorDesconto;
    }

    public void setValorFrete(Double valorFrete) {
        this.valorFrete = valorFrete;
    }

    public void setValorSeguro(Double valorSeguro) {
        this.valorSeguro = valorSeguro;
    }

    public void setValorDespAcess(Double valorDespAcess) {
        this.valorDespAcess = valorDespAcess;
    }

    public void setValorProduto(Double valorProduto) {
        this.valorProduto = valorProduto;
    }

    public void setValorServico(Double valorServico) {
        this.valorServico = valorServico;
    }

    public void setValorIpiIsento(Double valorIpiIsento) {
        this.valorIpiIsento = valorIpiIsento;
    }

    public void setValorIpiOutros(Double valorIpiOutros) {
        this.valorIpiOutros = valorIpiOutros;
    }

    public void setValorIpiTributado(Double valorIpiTributado) {
        this.valorIpiTributado = valorIpiTributado;
    }

    public void setValorIpiObservacao(Double valorIpiObservacao) {
        this.valorIpiObservacao = valorIpiObservacao;
    }

    public void setValorIpiIndustria(Double valorIpiIndustria) {
        this.valorIpiIndustria = valorIpiIndustria;
    }

    public void setValorIcms(Double valorIcms) {
        this.valorIcms = valorIcms;
    }

    public void setValorIcmsSa(Double valorIcmsSa) {
        this.valorIcmsSa = valorIcmsSa;
    }

    public void setBcIcmsSt(Double bcIcmsSt) {
        this.bcIcmsSt = bcIcmsSt;
    }

    public void setValorIcmsSt(Double valorIcmsSt) {
        this.valorIcmsSt = valorIcmsSt;
    }

    public void setValorLei10833(Double valorLei10833) {
        this.valorLei10833 = valorLei10833;
    }

    public void setValorInss(Double valorInss) {
        this.valorInss = valorInss;
    }

    public void setValorIss(Double valorIss) {
        this.valorIss = valorIss;
    }

    public void setValorFunrural(Double valorFunrural) {
        this.valorFunrural = valorFunrural;
    }

    public void setValorPis(Double valorPis) {
        this.valorPis = valorPis;
    }

    public void setValorCofins(Double valorCofins) {
        this.valorCofins = valorCofins;
    }

    public void setValorContSoc(Double valorContSoc) {
        this.valorContSoc = valorContSoc;
    }

    public void setValorOutros(Double valorOutros) {
        this.valorOutros = valorOutros;
    }

    public void setValorSestSenat(Double valorSestSenat) {
        this.valorSestSenat = valorSestSenat;
    }

    public void setValorIrrf(Double valorIrrf) {
        this.valorIrrf = valorIrrf;
    }

    public void setValorIcmsIsento(Double valorIcmsIsento) {
        this.valorIcmsIsento = valorIcmsIsento;
    }

    public void setValorIcmsTributado(Double valorIcmsTributado) {
        this.valorIcmsTributado = valorIcmsTributado;
    }

    public void setValorIcmsOutros(Double valorIcmsOutros) {
        this.valorIcmsOutros = valorIcmsOutros;
    }

    public void setValorAgregado(Double valorAgregado) {
        this.valorAgregado = valorAgregado;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public void setCotacao(Cotacao cotacao) {
        this.cotacao = cotacao;
    }

    public void setCotacaoCompra(CotacaoCompra cotacaoCompra) {
        this.cotacaoCompra = cotacaoCompra;
    }

    public void setTipoFrete(TipoFrete tipoFrete) {
        this.tipoFrete = tipoFrete;
    }

    public void setTransportador(Transportador transportador) {
        this.transportador = transportador;
    }

    public void setCondicaoPagamento(CondicoesPagamento condicaoPagamento) {
        this.condicaoPagamento = condicaoPagamento;
    }

    public void setUnidadeFatFornecedor(UnidadeFatFornecedor unidadeFatFornecedor) {
        this.unidadeFatFornecedor = unidadeFatFornecedor;
    }

    public void setLiberacaoOrdemCompra(LiberacaoOrdemCompra liberacaoOrdemCompra) {
        this.liberacaoOrdemCompra = liberacaoOrdemCompra;
    }

    public void setTitulos(List<Titulo> titulos) {
        this.titulos = titulos;
    }

    public void setItemOrdemCompra(List<ItemOrdemCompra> itemOrdemCompra) {
        this.itemOrdemCompra = itemOrdemCompra;
    }

    public void setRecepcaoMercadorias(List<RecepcaoMercadorias> recepcaoMercadorias) {
        this.recepcaoMercadorias = recepcaoMercadorias;
    }

    public void setObservacoes(List<ObservacaoOrdemCompra> observacoes) {
        this.observacoes = observacoes;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"Ordem de compra numero: {0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToMany(mappedBy="ordemCompra")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<OrdemCompraVencimentos> getVencimentosOrdemCompra() {
        return this.vencimentosOrdemCompra;
    }

    public void setVencimentosOrdemCompra(List<OrdemCompraVencimentos> vencimentosOrdemCompra) {
        this.vencimentosOrdemCompra = vencimentosOrdemCompra;
    }

    @Column(name="PRAZO_MAX_ENTREGA_ITENS")
    public Long getPrazoMaxEntregaItens() {
        return this.prazoMaxEntregaItens;
    }

    public void setPrazoMaxEntregaItens(Long prazoMaxEntregaItens) {
        this.prazoMaxEntregaItens = prazoMaxEntregaItens;
    }

    @Column(nullable=false, name="PERC_FRETE_INF", precision=15, scale=4)
    public Double getPercFreteInf() {
        return this.percFreteInf;
    }

    public void setPercFreteInf(Double percFreteInf) {
        this.percFreteInf = percFreteInf;
    }

    @Column(name="VALOR_FRETE_INF", precision=15, scale=2)
    public Double getValorFreteInf() {
        return this.valorFreteInf;
    }

    public void setValorFreteInf(Double valorFreteInf) {
        this.valorFreteInf = valorFreteInf;
    }

    @Column(name="PERC_DESCONTO_INF", precision=15, scale=4)
    public Double getPercDescontoInf() {
        return this.percDescontoInf;
    }

    public void setPercDescontoInf(Double percDescontoInf) {
        this.percDescontoInf = percDescontoInf;
    }

    @Column(name="VALOR_DESCONTO_INF", precision=15, scale=2)
    public Double getValorDescontoInf() {
        return this.valorDescontoInf;
    }

    public void setValorDescontoInf(Double valorDescontoInf) {
        this.valorDescontoInf = valorDescontoInf;
    }

    @Column(nullable=false, name="PERC_SEGURO_INF", precision=15, scale=4)
    public Double getPercSeguroInf() {
        return this.percSeguroInf;
    }

    public void setPercSeguroInf(Double percSeguroInf) {
        this.percSeguroInf = percSeguroInf;
    }

    @Column(name="VALOR_SEGURO_INF", precision=15, scale=2)
    public Double getValorSeguroInf() {
        return this.valorSeguroInf;
    }

    public void setValorSeguroInf(Double valorSeguroInf) {
        this.valorSeguroInf = valorSeguroInf;
    }

    @Column(name="PERC_DESP_ACESSORIA_INF", precision=15, scale=4)
    public Double getPercDespAcessoriaInf() {
        return this.percDespAcessoriaInf;
    }

    public void setPercDespAcessoriaInf(Double percDespAcessoriaInf) {
        this.percDespAcessoriaInf = percDespAcessoriaInf;
    }

    @Column(name="VALOR_DESP_ACESSORIA_INF", precision=15, scale=2)
    public Double getValorDespAcessoriaInf() {
        return this.valorDespAcessoriaInf;
    }

    public void setValorDespAcessoriaInf(Double valorDespAcessoriaInf) {
        this.valorDespAcessoriaInf = valorDespAcessoriaInf;
    }

    @Column(name="TIPO_FRETE_INF")
    public Short getTipoFreteInf() {
        return this.tipoFreteInf;
    }

    public void setTipoFreteInf(Short tipoFreteInf) {
        this.tipoFreteInf = tipoFreteInf;
    }

    @Column(name="TIPO_SEGURO_INF")
    public Short getTipoSeguroInf() {
        return this.tipoSeguroInf;
    }

    public void setTipoSeguroInf(Short tipoSeguroInf) {
        this.tipoSeguroInf = tipoSeguroInf;
    }

    @Column(name="TIPO_DESP_ACESS_INF")
    public Short getTipoDespAcessInf() {
        return this.tipoDespAcessInf;
    }

    public void setTipoDespAcessInf(Short tipoDespAcessInf) {
        this.tipoDespAcessInf = tipoDespAcessInf;
    }

    @Column(name="TIPO_DESCONTO_INF")
    public Short getTipoDescontoInf() {
        return this.tipoDescontoInf;
    }

    public void setTipoDescontoInf(Short tipoDescontoInf) {
        this.tipoDescontoInf = tipoDescontoInf;
    }

    @Column(nullable=false, name="VALOR_PIS_ST", precision=15, scale=2)
    public Double getValorPisST() {
        return this.valorPisST;
    }

    public void setValorPisST(Double valorPisST) {
        this.valorPisST = valorPisST;
    }

    @Column(nullable=false, name="VALOR_COFINS_ST", precision=15, scale=2)
    public Double getValorCofinsST() {
        return this.valorCofinsST;
    }

    public void setValorCofinsST(Double valorCofinsST) {
        this.valorCofinsST = valorCofinsST;
    }

    @Column(name="MOTIVO_CANCELAMENTO", length=500)
    public String getMotivoCancelamento() {
        return this.motivoCancelamento;
    }

    public void setMotivoCancelamento(String motivoCancelamento) {
        this.motivoCancelamento = motivoCancelamento;
    }

    @OneToMany(mappedBy="ordemCompra", cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<EmailsOrdemCompra> getEmailsOrdemCompra() {
        return this.emailsOrdemCompra;
    }

    public void setEmailsOrdemCompra(List<EmailsOrdemCompra> emailsOrdemCompra) {
        this.emailsOrdemCompra = emailsOrdemCompra;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MEIO_PAGAMENTO", foreignKey=@ForeignKey(name="FK_ORDEM_COMPRA_MEIO_PAG"))
    public MeioPagamento getMeioPagamento() {
        return this.meioPagamento;
    }

    public void setMeioPagamento(MeioPagamento meioPagamento) {
        this.meioPagamento = meioPagamento;
    }

    @Column(name="TIPO_DATA_TITULO")
    public Short getTipoDataTitulo() {
        return this.tipoDataTitulo;
    }

    public void setTipoDataTitulo(Short tipoDataTitulo) {
        this.tipoDataTitulo = tipoDataTitulo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLASSIFICACAO_OC", foreignKey=@ForeignKey(name="FK_ORDEM_COMPRA_CLAS_OC"))
    public ClassificacaoOrdemCompra getClassificacaoOC() {
        return this.classificacaoOC;
    }

    public void setClassificacaoOC(ClassificacaoOrdemCompra classificacaoOC) {
        this.classificacaoOC = classificacaoOC;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_STATUS_ORDEM_COMPRA", foreignKey=@ForeignKey(name="FK_ORDEM_COMPRA_STATUS_ORD_COM"))
    public StatusOrdemCompra getStatusOrdemCompra() {
        return this.statusOrdemCompra;
    }

    public void setStatusOrdemCompra(StatusOrdemCompra statusOrdemCompra) {
        this.statusOrdemCompra = statusOrdemCompra;
    }

    @Column(name="LIBERADA")
    public Short getLiberada() {
        return this.liberada;
    }

    public void setLiberada(Short liberada) {
        this.liberada = liberada;
    }

    @Column(name="INFORMAR_ENDERECO_ENTREGA")
    public Short getInformarEnderecoEntrega() {
        return this.informarEnderecoEntrega;
    }

    public void setInformarEnderecoEntrega(Short informarEnderecoEntrega) {
        this.informarEnderecoEntrega = informarEnderecoEntrega;
    }

    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="ID_ENDERECO_ENTREGA", foreignKey=@ForeignKey(name="FK_ORDEM_COMPRA_END_ENTREGA"))
    public Endereco getEnderecoEntrega() {
        return this.enderecoEntrega;
    }

    public void setEnderecoEntrega(Endereco enderecoEntrega) {
        this.enderecoEntrega = enderecoEntrega;
    }
}

