/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CotacaoVendas;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.MotivoDesistencia;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.SetorExecutante;
import com.touchcomp.basementor.model.vo.SituacaoCotacaoVendas;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="PRE_COTACAO_VENDAS")
public class PreCotacaoVendas
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private String numColeta;
    private Short desistencia = 0;
    private MotivoDesistencia motivoDesistencia;
    private Date dataVencimento;
    private Date dataEnvio;
    private UnidadeFatCliente unidadeFatCliente;
    private Representante representante;
    private Pessoa orcamentista;
    private SituacaoCotacaoVendas situacaoColeta;
    private SetorExecutante setor;
    private String observacao;
    private List<CotacaoVendas> cotacaoVendas = new ArrayList<CotacaoVendas>();
    private Date dataAprovacao;
    private Date dataLiberacao;

    @Id
    @Column(name="ID_PRE_COTACAO_VENDAS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_PRE_COTACAO_VENDAS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_PRE_COTACAO_VENDAS_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="NUM_COLETA", length=50)
    public String getNumColeta() {
        return this.numColeta;
    }

    public void setNumColeta(String numColeta) {
        this.numColeta = numColeta;
    }

    @Column(name="DESISTENCIA")
    public Short getDesistencia() {
        return this.desistencia;
    }

    public void setDesistencia(Short desistencia) {
        this.desistencia = desistencia;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MOTIVO_DESISTENCIA", foreignKey=@ForeignKey(name="FK_PRE_COTACAO_VENDAS_MOT_DISIS"))
    public MotivoDesistencia getMotivoDesistencia() {
        return this.motivoDesistencia;
    }

    public void setMotivoDesistencia(MotivoDesistencia motivoDesistencia) {
        this.motivoDesistencia = motivoDesistencia;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_VENCIMENTO")
    public Date getDataVencimento() {
        return this.dataVencimento;
    }

    public void setDataVencimento(Date dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_ENVIO")
    public Date getDataEnvio() {
        return this.dataEnvio;
    }

    public void setDataEnvio(Date dataEnvio) {
        this.dataEnvio = dataEnvio;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_UNID_FAT_CLIENTE", foreignKey=@ForeignKey(name="FK_PRE_COTACAO_VENDAS_U_FAT_CLI"))
    public UnidadeFatCliente getUnidadeFatCliente() {
        return this.unidadeFatCliente;
    }

    public void setUnidadeFatCliente(UnidadeFatCliente unidadeFatCliente) {
        this.unidadeFatCliente = unidadeFatCliente;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_REPRESENTANTE", foreignKey=@ForeignKey(name="FK_PRE_COTACAO_VENDAS_REPRESENT"))
    public Representante getRepresentante() {
        return this.representante;
    }

    public void setRepresentante(Representante representante) {
        this.representante = representante;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ORCAMENTISTA", foreignKey=@ForeignKey(name="FK_PRE_COTACAO_VENDAS_ORCAMENTI"))
    public Pessoa getOrcamentista() {
        return this.orcamentista;
    }

    public void setOrcamentista(Pessoa orcamentista) {
        this.orcamentista = orcamentista;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_SITUACAO_COLETA", foreignKey=@ForeignKey(name="FK_PRE_COTACAO_VENDAS_SIT_COLET"))
    public SituacaoCotacaoVendas getSituacaoColeta() {
        return this.situacaoColeta;
    }

    public void setSituacaoColeta(SituacaoCotacaoVendas situacaoColeta) {
        this.situacaoColeta = situacaoColeta;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_SETOR", foreignKey=@ForeignKey(name="FK_PRE_COTACAO_VENDAS_SETOR"))
    public SetorExecutante getSetor() {
        return this.setor;
    }

    public void setSetor(SetorExecutante setor) {
        this.setor = setor;
    }

    @Column(name="OBSERVACAO", length=500)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @OneToMany(mappedBy="preCotacaoVenda")
    public List<CotacaoVendas> getCotacaoVendas() {
        return this.cotacaoVendas;
    }

    public void setCotacaoVendas(List<CotacaoVendas> cotacaoVendas) {
        this.cotacaoVendas = cotacaoVendas;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_APROVACAO")
    public Date getDataAprovacao() {
        return this.dataAprovacao;
    }

    public void setDataAprovacao(Date dataAprovacao) {
        this.dataAprovacao = dataAprovacao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_LIBERACAO")
    public Date getDataLiberacao() {
        return this.dataLiberacao;
    }

    public void setDataLiberacao(Date dataLiberacao) {
        this.dataLiberacao = dataLiberacao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

