/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemPrevisaoFinanceiraFerias;
import com.touchcomp.basementor.model.vo.TipoFerias;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="PREVISAO_FINANCEIRA_FERIAS")
public class PrevisaoFinanceiraFerias
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Short filtrarCentroCusto = 0;
    private CentroCusto centroCusto;
    private String observacao;
    private TipoFerias tipoFerias;
    private List<ItemPrevisaoFinanceiraFerias> itensPrevisoes = new ArrayList<ItemPrevisaoFinanceiraFerias>();
    private Date dataInicio;
    private Short provisaoImpostoDesonerada = 0;
    private Short descartarValoresImpostos = 0;

    @Id
    @Column(nullable=false, unique=true, name="ID_PREVISAO_FINANCEIRA_FOLHA")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_PREVISAO_FINANCEIRA_FOLHA")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_PREV_FINANC_FERIAS_EMPRESA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_CUSTO", foreignKey=@ForeignKey(name="FK_PREV_FINANCEIRA_FERIAS_CC"))
    public CentroCusto getCentroCusto() {
        return this.centroCusto;
    }

    public void setCentroCusto(CentroCusto centroCusto) {
        this.centroCusto = centroCusto;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getObservacao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="OBSERVACAO", length=100)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_FERIAS", foreignKey=@ForeignKey(name="FK_PREV_FINANC_TIPO_FERIAS"))
    public TipoFerias getTipoFerias() {
        return this.tipoFerias;
    }

    public void setTipoFerias(TipoFerias tipoFerias) {
        this.tipoFerias = tipoFerias;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="previsaoFinanceira", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ItemPrevisaoFinanceiraFerias> getItensPrevisoes() {
        return this.itensPrevisoes;
    }

    public void setItensPrevisoes(List<ItemPrevisaoFinanceiraFerias> itensPrevisoes) {
        this.itensPrevisoes = itensPrevisoes;
    }

    @Column(name="DATA_INICIO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataInicio() {
        return this.dataInicio;
    }

    public void setDataInicio(Date dataInicio) {
        this.dataInicio = dataInicio;
    }

    @Column(name="FILTRAR_CENTRO_CUSTO")
    public Short getFiltrarCentroCusto() {
        return this.filtrarCentroCusto;
    }

    public void setFiltrarCentroCusto(Short filtrarCentroCusto) {
        this.filtrarCentroCusto = filtrarCentroCusto;
    }

    @Column(name="PROVISAO_IMPOSTO_DESONERADA")
    public Short getProvisaoImpostoDesonerada() {
        return this.provisaoImpostoDesonerada;
    }

    public void setProvisaoImpostoDesonerada(Short provisaoImpostoDesonerada) {
        this.provisaoImpostoDesonerada = provisaoImpostoDesonerada;
    }

    @Column(name="DESCARTAR_VALORES_IMPOSTOS")
    public Short getDescartarValoresImpostos() {
        return this.descartarValoresImpostos;
    }

    public void setDescartarValoresImpostos(Short descartarValoresImpostos) {
        this.descartarValoresImpostos = descartarValoresImpostos;
    }
}

