/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.HistoricoPadrao;
import com.touchcomp.basementor.model.vo.ItemCooperadoJuros;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.ProvisaoJurosEventoCooperado;
import com.touchcomp.basementor.model.vo.ProvisaoJurosLancamentosGerenciais;
import com.touchcomp.basementor.model.vo.TabelaJurosCooperado;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="PROVISAO_JUROS")
public class ProvisaoJuros
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private String descricao;
    private Short ativo = 1;
    private Date dataInicial;
    private Date dataFinal;
    private PlanoConta planoContaDeb;
    private PlanoConta planoContaCred;
    private PlanoContaGerencial planoContaGerencial;
    private HistoricoPadrao historico;
    private List<ProvisaoJurosEventoCooperado> provisaoJurosEventoCooperado;
    private TabelaJurosCooperado tabelaJurosCooperado;
    private List<ItemCooperadoJuros> itens = new ArrayList<ItemCooperadoJuros>();
    private LoteContabil lote;
    private LoteContabil loteIrrf;
    private List<ProvisaoJurosLancamentosGerenciais> lancamentosCtbGerenciais = new ArrayList<ProvisaoJurosLancamentosGerenciais>();
    private Short descProvSemImpostos;
    private Date dataMovimento;

    public ProvisaoJuros() {
        this.provisaoJurosEventoCooperado = new ArrayList<ProvisaoJurosEventoCooperado>();
        this.descProvSemImpostos = EnumConstantsMentorSimNao.NAO.getValue();
    }

    @Id
    @Column(nullable=false, name="ID_PROVISAO_JUROS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_PROVISAO_JUROS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_PROVISAO_JUROS_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="DESCRICAO", length=500)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @JoinColumn(name="ID_PLANO_CONTA_DEB", foreignKey=@ForeignKey(name="FK_PROVISAO_JUROS_PLANO_CONT_DE"))
    @ManyToOne(fetch=FetchType.LAZY)
    public PlanoConta getPlanoContaDeb() {
        return this.planoContaDeb;
    }

    public void setPlanoContaDeb(PlanoConta planoContaDeb) {
        this.planoContaDeb = planoContaDeb;
    }

    @JoinColumn(name="ID_PLANO_CONTA_CRED", foreignKey=@ForeignKey(name="FK_PROVISAO_JUROS_PLANO_CONT_CR"))
    @ManyToOne(fetch=FetchType.LAZY)
    public PlanoConta getPlanoContaCred() {
        return this.planoContaCred;
    }

    public void setPlanoContaCred(PlanoConta planoContaCred) {
        this.planoContaCred = planoContaCred;
    }

    @JoinColumn(name="ID_PLANO_CONTA_GER", foreignKey=@ForeignKey(name="FK_PROVISAO_JUROS_PLAN_CONT_GER"))
    @ManyToOne(fetch=FetchType.LAZY)
    public PlanoContaGerencial getPlanoContaGerencial() {
        return this.planoContaGerencial;
    }

    public void setPlanoContaGerencial(PlanoContaGerencial planoContaGerencial) {
        this.planoContaGerencial = planoContaGerencial;
    }

    @JoinColumn(name="ID_HISTORICO_PADRAO", foreignKey=@ForeignKey(name="FK_PROVISAO_JUROS_HIST_PADRAO"))
    @ManyToOne(fetch=FetchType.LAZY)
    public HistoricoPadrao getHistorico() {
        return this.historico;
    }

    public void setHistorico(HistoricoPadrao historico) {
        this.historico = historico;
    }

    @Column(nullable=false, name="DATA_INICIAL")
    @Temporal(value=TemporalType.DATE)
    public Date getDataInicial() {
        return this.dataInicial;
    }

    public void setDataInicial(Date dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Column(nullable=false, name="DATA_FINAL")
    @Temporal(value=TemporalType.DATE)
    public Date getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    @OneToMany(mappedBy="provisaoJuros", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ItemCooperadoJuros> getItens() {
        return this.itens;
    }

    public void setItens(List<ItemCooperadoJuros> itens) {
        this.itens = itens;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_LOTE", foreignKey=@ForeignKey(name="FK_PROVISAO_JUROS_LOTE"))
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public LoteContabil getLote() {
        return this.lote;
    }

    public void setLote(LoteContabil lote) {
        this.lote = lote;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_LOTE_IRRF", foreignKey=@ForeignKey(name="FK_PROVISAO_JUROS_LOTE_IRRF"))
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public LoteContabil getLoteIrrf() {
        return this.loteIrrf;
    }

    public void setLoteIrrf(LoteContabil loteIrrf) {
        this.loteIrrf = loteIrrf;
    }

    @OneToMany(mappedBy="provisaoJuros", fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<ProvisaoJurosLancamentosGerenciais> getLancamentosCtbGerenciais() {
        return this.lancamentosCtbGerenciais;
    }

    public void setLancamentosCtbGerenciais(List<ProvisaoJurosLancamentosGerenciais> lancamentosCtbGerenciais) {
        this.lancamentosCtbGerenciais = lancamentosCtbGerenciais;
    }

    @JoinColumn(name="ID_TABELA_JUROS_COOP", foreignKey=@ForeignKey(name="FK_PROVISAO_JUROS_TABELA_JUROS"))
    @ManyToOne(fetch=FetchType.LAZY)
    public TabelaJurosCooperado getTabelaJurosCooperado() {
        return this.tabelaJurosCooperado;
    }

    public void setTabelaJurosCooperado(TabelaJurosCooperado tabelaJurosCooperado) {
        this.tabelaJurosCooperado = tabelaJurosCooperado;
    }

    @OneToMany(mappedBy="provisaoJuros", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ProvisaoJurosEventoCooperado> getProvisaoJurosEventoCooperado() {
        return this.provisaoJurosEventoCooperado;
    }

    public void setProvisaoJurosEventoCooperado(List<ProvisaoJurosEventoCooperado> provisaoJurosEventoCooperado) {
        this.provisaoJurosEventoCooperado = provisaoJurosEventoCooperado;
    }

    @Column(name="DESC_PROV_SEM_IMPOSTOS")
    public Short getDescProvSemImpostos() {
        return this.descProvSemImpostos;
    }

    public void setDescProvSemImpostos(Short descProvSemImpostos) {
        this.descProvSemImpostos = descProvSemImpostos;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_MOVIMENTO")
    public Date getDataMovimento() {
        return this.dataMovimento;
    }

    public void setDataMovimento(Date dataMovimento) {
        this.dataMovimento = dataMovimento;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

