/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.interfaces.InterfaceVOReinf;
import com.touchcomp.basementor.model.vo.ConfiguracaoCertificado;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.ReinfClassificacaoTributaria;
import com.touchcomp.basementor.model.vo.ReinfPreEvento;
import com.touchcomp.basementor.model.vo.ReinfSituacaoPessoaJuridica;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="REINF_R_MIL")
public class R1000
implements InterfaceVO,
InterfaceVOReinf {
    private Long identificador;
    private Date inicioValidade;
    private ReinfClassificacaoTributaria classificacaoTributaria;
    private Short indEscrituracao = 0;
    private Short indDesoneracao = 0;
    private Short indAcordoInseMulta = 0;
    private ReinfSituacaoPessoaJuridica situacaoPessoaJuridica;
    private Pessoa pessoaContato;
    private Pessoa pessoaSoftwareHouse;
    private ConfiguracaoCertificado configuracaoCertificado;
    private Empresa empresa;
    private List<ReinfPreEvento> preEventosReinf = new ArrayList<ReinfPreEvento>();

    @Id
    @Column(nullable=false, unique=true, name="ID_REINF_R_MIL")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_REINF_R_MIL")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="INICIO_VALIDADE")
    @Temporal(value=TemporalType.DATE)
    public Date getInicioValidade() {
        return this.inicioValidade;
    }

    public void setInicioValidade(Date inicioValidade) {
        this.inicioValidade = inicioValidade;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_REINF_CLASS_TRIBUTARIA", foreignKey=@ForeignKey(name="FK_R_MIL_CLASS_TRIBUTARIA"))
    public ReinfClassificacaoTributaria getClassificacaoTributaria() {
        return this.classificacaoTributaria;
    }

    public void setClassificacaoTributaria(ReinfClassificacaoTributaria classificacaoTributaria) {
        this.classificacaoTributaria = classificacaoTributaria;
    }

    @Column(name="IND_ESCRITURACAO")
    public Short getIndEscrituracao() {
        return this.indEscrituracao;
    }

    public void setIndEscrituracao(Short indEscrituracao) {
        this.indEscrituracao = indEscrituracao;
    }

    @Column(name="IND_DESONERACAO")
    public Short getIndDesoneracao() {
        return this.indDesoneracao;
    }

    public void setIndDesoneracao(Short indDesoneracao) {
        this.indDesoneracao = indDesoneracao;
    }

    @Column(name="IND_ACORDO_INSE_MULTA")
    public Short getIndAcordoInseMulta() {
        return this.indAcordoInseMulta;
    }

    public void setIndAcordoInseMulta(Short indAcordoInseMulta) {
        this.indAcordoInseMulta = indAcordoInseMulta;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_SIT_PESSOA_JURIDICA", foreignKey=@ForeignKey(name="FK_SIT_PESSOA_JURIDICA_R_MIL"))
    public ReinfSituacaoPessoaJuridica getSituacaoPessoaJuridica() {
        return this.situacaoPessoaJuridica;
    }

    public void setSituacaoPessoaJuridica(ReinfSituacaoPessoaJuridica situacaoPessoaJuridica) {
        this.situacaoPessoaJuridica = situacaoPessoaJuridica;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA_CONTATO", foreignKey=@ForeignKey(name="FK_PESSOA_CONTATO_R_MIL"))
    public Pessoa getPessoaContato() {
        return this.pessoaContato;
    }

    public void setPessoaContato(Pessoa pessoaContato) {
        this.pessoaContato = pessoaContato;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA_SOFTHOUSE", foreignKey=@ForeignKey(name="FK_PESSOA_SOFTHOUSE_R_MIL"))
    public Pessoa getPessoaSoftwareHouse() {
        return this.pessoaSoftwareHouse;
    }

    public void setPessoaSoftwareHouse(Pessoa pessoaSoftwareHouse) {
        this.pessoaSoftwareHouse = pessoaSoftwareHouse;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONFIGURACAO_CERTIFICADO", foreignKey=@ForeignKey(name="FK_CONFIGURACAO_CERTIFICADO_R_M"))
    public ConfiguracaoCertificado getConfiguracaoCertificado() {
        return this.configuracaoCertificado;
    }

    public void setConfiguracaoCertificado(ConfiguracaoCertificado configuracaoCertificado) {
        this.configuracaoCertificado = configuracaoCertificado;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_REINF_R_MIL_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    @Override
    @OneToMany(mappedBy="r1000", fetch=FetchType.LAZY)
    public List<ReinfPreEvento> getPreEventosReinf() {
        return this.preEventosReinf;
    }

    public void setPreEventosReinf(List<ReinfPreEvento> preEventosReinf) {
        this.preEventosReinf = preEventosReinf;
    }
}

