/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.touch.EnumConstTipoHoraRelTouch;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.RelacionamentoPessoa;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="RELACIONAMENTO_PESSOA_LOG")
public class RelacionamentoPessoaLog
implements InterfaceVO {
    private Long identificador;
    private Usuario usuario;
    private Usuario usuarioAgendamento;
    private Date dataAgendamento;
    private String observacao;
    private Short finalizado = 0;
    private Double tempoDispendiado = 0.0;
    private Date dataFinalizacao;
    private Date dataInicial;
    private RelacionamentoPessoa relacionamentoPessoa;
    private Date dataInclusao;
    private Short tipoHora = EnumConstTipoHoraRelTouch.TIPO_HORA_PRODUTIVA.getValue();

    @Id
    @Column(nullable=false, name="ID_RELACIONAMENTO_PESSOA_LOG")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_RELACIONAMENTO_PESSOA_LOG")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO_AGENDAMENTO", foreignKey=@ForeignKey(name="FK_REL_PESSOA_LOG_USUARIO_AG"))
    public Usuario getUsuarioAgendamento() {
        return this.usuarioAgendamento;
    }

    public void setUsuarioAgendamento(Usuario usuarioAgendamento) {
        this.usuarioAgendamento = usuarioAgendamento;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_AGENDAMENTO")
    public Date getDataAgendamento() {
        return this.dataAgendamento;
    }

    public void setDataAgendamento(Date dataAgendamento) {
        this.dataAgendamento = dataAgendamento;
    }

    @Column(name="OBSERVACAO", length=5000)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_RELACIONAMENTO_PESSOA", foreignKey=@ForeignKey(name="FK_REL_PESSOA_LOG_REL_PESSOA"))
    public RelacionamentoPessoa getRelacionamentoPessoa() {
        return this.relacionamentoPessoa;
    }

    public void setRelacionamentoPessoa(RelacionamentoPessoa relacionamentoPessoa) {
        this.relacionamentoPessoa = relacionamentoPessoa;
    }

    @Column(name="FINALIZADO")
    public Short getFinalizado() {
        return this.finalizado;
    }

    public void setFinalizado(Short finalizado) {
        this.finalizado = finalizado;
    }

    @Column(nullable=false, name="TEMPO_DISPENDIADO", precision=15, scale=2)
    public Double getTempoDispendiado() {
        return this.tempoDispendiado;
    }

    public void setTempoDispendiado(Double tempoDispendiado) {
        this.tempoDispendiado = tempoDispendiado;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_FINALIZACAO")
    public Date getDataFinalizacao() {
        return this.dataFinalizacao;
    }

    public void setDataFinalizacao(Date dataFinalizacao) {
        this.dataFinalizacao = dataFinalizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_REL_PESSOA_LOG_USUARIO"))
    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getObservacao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_INICIAL")
    public Date getDataInicial() {
        return this.dataInicial;
    }

    public void setDataInicial(Date dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_INCLUSAO")
    public Date getDataInclusao() {
        return this.dataInclusao;
    }

    public void setDataInclusao(Date dataInclusao) {
        this.dataInclusao = dataInclusao;
    }

    @Column(name="TIPO_HORA")
    public Short getTipoHora() {
        return this.tipoHora;
    }

    public void setTipoHora(Short tipoHora) {
        this.tipoHora = tipoHora;
    }
}

