/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CarteiraCobranca;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoDeBaixa;
import com.touchcomp.basementor.model.vo.HistoricoPadrao;
import com.touchcomp.basementor.model.vo.LoteContabil;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.TipoDoc;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="RENEGOCIACAO_TITULOS")
public class RenegociacaoTitulos
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Empresa empresa;
    private Timestamp dataAtualizacao;
    private CarteiraCobranca carteiraCobranca;
    private Short pagRec = 0;
    private Date dataEmissao;
    private Date dataCompetencia;
    private Integer nrParcelas = 0;
    private Integer diasEntreParcelas = 0;
    private Short tipoGeracao = 0;
    private TipoDoc tipoDoc;
    private String observacao;
    private List<Titulo> titulosGerados = new ArrayList<Titulo>();
    private Double desconto = 0.0;
    private Double juros = 0.0;
    private Double jurosEmbutidos = 0.0;
    private Short variarDtCompVenc = 0;
    private String descricao;
    private Short gerarDataFixa = 0;
    private GrupoDeBaixa grupoDeBaixa;
    private Date dataVencInicial;
    private Double multaEmbutida = 0.0;
    private Double multa = 0.0;
    private Double valorAdicional = 0.0;
    private Double percentualMultaEmb = 0.0;
    private Double percentualJurosEmb = 0.0;
    private MeioPagamento meioPagamento;
    private Double valorDescontosEmbutido = 0.0;
    private Short gerarLancamentoAdicional = 0;
    private PlanoConta planoContaCredito;
    private PlanoConta planoContaDebito;
    private HistoricoPadrao historicoPadrao;
    private String historico;
    private LoteContabil lote;
    private Date dataBaixaTitulo;

    @Id
    @Column(nullable=false, name="ID_RENEGOCIACAO_TITULOS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_RENEGOCIACAO_TITULOS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(nullable=false, name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_RENEGOCIACAO_TITULOS_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CARTEIRA_COBRANCA", foreignKey=@ForeignKey(name="FK_RENEGOCIACAO_TITULOS_CART_CO"))
    public CarteiraCobranca getCarteiraCobranca() {
        return this.carteiraCobranca;
    }

    public void setCarteiraCobranca(CarteiraCobranca carteiraCobranca) {
        this.carteiraCobranca = carteiraCobranca;
    }

    @Column(name="PAG_REC")
    public Short getPagRec() {
        return this.pagRec;
    }

    public void setPagRec(Short pagRec) {
        this.pagRec = pagRec;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_EMISSAO")
    public Date getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(Date dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_COMPETENCIA")
    public Date getDataCompetencia() {
        return this.dataCompetencia;
    }

    public void setDataCompetencia(Date dataCompetencia) {
        this.dataCompetencia = dataCompetencia;
    }

    @Column(name="NR_PARCELAS")
    public Integer getNrParcelas() {
        return this.nrParcelas;
    }

    public void setNrParcelas(Integer nrParcelas) {
        this.nrParcelas = nrParcelas;
    }

    @Column(name="DIAS_ENTRE_PARCELAS")
    public Integer getDiasEntreParcelas() {
        return this.diasEntreParcelas;
    }

    public void setDiasEntreParcelas(Integer diasEntreParcelas) {
        this.diasEntreParcelas = diasEntreParcelas;
    }

    @Column(name="TIPO_GERACAO")
    public Short getTipoGeracao() {
        return this.tipoGeracao;
    }

    public void setTipoGeracao(Short tipoGeracao) {
        this.tipoGeracao = tipoGeracao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_DOC_FINANCEIRO", foreignKey=@ForeignKey(name="FK_RENEGOCIACAO_TITULOS_TIP_DOC"))
    public TipoDoc getTipoDoc() {
        return this.tipoDoc;
    }

    public void setTipoDoc(TipoDoc tipoDoc) {
        this.tipoDoc = tipoDoc;
    }

    @Column(name="OBSERVACAO", length=300)
    public String getObservacao() {
        return this.observacao;
    }

    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @OneToMany(mappedBy="renegociacaoTitulos")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<Titulo> getTitulosGerados() {
        return this.titulosGerados;
    }

    public void setTitulosGerados(List<Titulo> titulosGerados) {
        this.titulosGerados = titulosGerados;
    }

    @Column(nullable=false, name="DESCONTO_TITULO", precision=12, scale=2)
    public Double getDesconto() {
        return this.desconto;
    }

    public void setDesconto(Double desconto) {
        this.desconto = desconto;
    }

    @Column(nullable=false, name="JUROS_TITULO", precision=12, scale=2)
    public Double getJuros() {
        return this.juros;
    }

    public void setJuros(Double juros) {
        this.juros = juros;
    }

    @Column(nullable=false, name="JUROS_EMBUTIDO_TITULO", precision=12, scale=2)
    public Double getJurosEmbutidos() {
        return this.jurosEmbutidos;
    }

    public void setJurosEmbutidos(Double jurosEmbutidos) {
        this.jurosEmbutidos = jurosEmbutidos;
    }

    @Column(name="VARIAR_DATA_COMP_VENC")
    public Short getVariarDtCompVenc() {
        return this.variarDtCompVenc;
    }

    public void setVariarDtCompVenc(Short variarDtCompVenc) {
        this.variarDtCompVenc = variarDtCompVenc;
    }

    @Column(name="DESCRICAO", length=100)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Column(name="GERAR_DATA_FIXA")
    public Short getGerarDataFixa() {
        return this.gerarDataFixa;
    }

    public void setGerarDataFixa(Short gerarDataFixa) {
        this.gerarDataFixa = gerarDataFixa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRUPO_DE_BAIXA", foreignKey=@ForeignKey(name="FK_RENEGOCIACAO_TITULOS_BAIXA"))
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public GrupoDeBaixa getGrupoDeBaixa() {
        return this.grupoDeBaixa;
    }

    public void setGrupoDeBaixa(GrupoDeBaixa grupoDeBaixa) {
        this.grupoDeBaixa = grupoDeBaixa;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_VENC_INICIAL")
    public Date getDataVencInicial() {
        return this.dataVencInicial;
    }

    public void setDataVencInicial(Date dataVencInicial) {
        this.dataVencInicial = dataVencInicial;
    }

    @Column(name="MULTA_EMBUTIDA", precision=15, scale=2)
    public Double getMultaEmbutida() {
        return this.multaEmbutida;
    }

    public void setMultaEmbutida(Double multaEmbutida) {
        this.multaEmbutida = multaEmbutida;
    }

    @Column(name="MULTA", precision=15, scale=2)
    public Double getMulta() {
        return this.multa;
    }

    public void setMulta(Double multa) {
        this.multa = multa;
    }

    @Column(name="VALOR_ADICIONAL", precision=15, scale=2)
    public Double getValorAdicional() {
        return this.valorAdicional;
    }

    public void setValorAdicional(Double valorAdicional) {
        this.valorAdicional = valorAdicional;
    }

    @Column(name="PERCENTUAL_MULTA_EMB", precision=15, scale=2)
    public Double getPercentualMultaEmb() {
        return this.percentualMultaEmb;
    }

    public void setPercentualMultaEmb(Double percentualMultaEmb) {
        this.percentualMultaEmb = percentualMultaEmb;
    }

    @Column(name="PERCENTUAL_JUROS_EMB", precision=15, scale=2)
    public Double getPercentualJurosEmb() {
        return this.percentualJurosEmb;
    }

    public void setPercentualJurosEmb(Double percentualJurosEmb) {
        this.percentualJurosEmb = percentualJurosEmb;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MEIO_PAGAMENTO", foreignKey=@ForeignKey(name="FK_RENEGOCIACAO_TITULOS_MEIO_PA"))
    public MeioPagamento getMeioPagamento() {
        return this.meioPagamento;
    }

    public void setMeioPagamento(MeioPagamento meioPagamento) {
        this.meioPagamento = meioPagamento;
    }

    @Column(name="VALOR_DESCONTO_EMBUTIDO", precision=15, scale=2)
    public Double getValorDescontosEmbutido() {
        return this.valorDescontosEmbutido;
    }

    public void setValorDescontosEmbutido(Double valorDescontosEmbutido) {
        this.valorDescontosEmbutido = valorDescontosEmbutido;
    }

    @Column(name="GERAR_LANC_ADICIONAL")
    public Short getGerarLancamentoAdicional() {
        return this.gerarLancamentoAdicional;
    }

    public void setGerarLancamentoAdicional(Short gerarLancamentoAdicional) {
        this.gerarLancamentoAdicional = gerarLancamentoAdicional;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_CRED", foreignKey=@ForeignKey(name="FK_RENEGOCIACAO_TITULOS_CRED"))
    public PlanoConta getPlanoContaCredito() {
        return this.planoContaCredito;
    }

    public void setPlanoContaCredito(PlanoConta planoContaCredito) {
        this.planoContaCredito = planoContaCredito;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_DEB", foreignKey=@ForeignKey(name="FK_RENEGOCIACAO_TITULOS_DEB"))
    public PlanoConta getPlanoContaDebito() {
        return this.planoContaDebito;
    }

    public void setPlanoContaDebito(PlanoConta planoContaDebito) {
        this.planoContaDebito = planoContaDebito;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_HISTORICO_PADRAO", foreignKey=@ForeignKey(name="FK_RENEG_TITULOS_HIST_PADRAO"))
    public HistoricoPadrao getHistoricoPadrao() {
        return this.historicoPadrao;
    }

    public void setHistoricoPadrao(HistoricoPadrao historicoPadrao) {
        this.historicoPadrao = historicoPadrao;
    }

    @Column(name="HISTORICO", length=500)
    public String getHistorico() {
        return this.historico;
    }

    public void setHistorico(String historico) {
        this.historico = historico;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_LOTE_CONTABIL", foreignKey=@ForeignKey(name="FK_RENEGOCIACAO_TITULOS_LOTE"))
    @Cascade(value={CascadeType.MERGE, CascadeType.SAVE_UPDATE, CascadeType.REFRESH, CascadeType.PERSIST, CascadeType.DELETE_ORPHAN, CascadeType.ALL})
    public LoteContabil getLote() {
        return this.lote;
    }

    public void setLote(LoteContabil lote) {
        this.lote = lote;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_BAIXA_TITULO")
    public Date getDataBaixaTitulo() {
        return this.dataBaixaTitulo;
    }

    public void setDataBaixaTitulo(Date dataBaixaTitulo) {
        this.dataBaixaTitulo = dataBaixaTitulo;
    }
}

