/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CaracteristicaFuncao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Funcao;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;

@Entity
@Table(name="REQUISITOS_FUNCOES")
public class RequisitosFuncoes
implements InterfaceVO {
    private Long identificador;
    private Funcao funcao;
    private String experienciaContratacao;
    private String experienciaPromocao;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Date dataUltimaAtualizacao;
    private String referencia;
    private List<CaracteristicaFuncao> treinamento = new ArrayList<CaracteristicaFuncao>();
    private List<CaracteristicaFuncao> habilidade = new ArrayList<CaracteristicaFuncao>();
    private List<CaracteristicaFuncao> atribuicao = new ArrayList<CaracteristicaFuncao>();

    @Id
    @Column(unique=true, nullable=false, name="ID_REQUISITOS_FUNCOES")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_REQUISITOS_FUNCOES")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_REQUISITOS_FUNCOES_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(unique=true, name="ID_FUNCAO", foreignKey=@ForeignKey(name="FK_REQUISITOS_FUNCOES_FUNCOES"))
    public Funcao getFuncao() {
        return this.funcao;
    }

    public void setFuncao(Funcao funcao) {
        this.funcao = funcao;
    }

    @Column(name="EXPERIENCIA_CONTRATACAO", length=500)
    public String getExperienciaContratacao() {
        return this.experienciaContratacao;
    }

    public void setExperienciaContratacao(String experienciaContratacao) {
        this.experienciaContratacao = experienciaContratacao;
    }

    @Column(name="EXPERIENCIA_PROMOCAO", length=500)
    public String getExperienciaPromocao() {
        return this.experienciaPromocao;
    }

    public void setExperienciaPromocao(String experienciaPromocao) {
        this.experienciaPromocao = experienciaPromocao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_ULTIMA_ATUALIZACAO")
    public Date getDataUltimaAtualizacao() {
        return this.dataUltimaAtualizacao;
    }

    public void setDataUltimaAtualizacao(Date dataUltimaAtualizacao) {
        this.dataUltimaAtualizacao = dataUltimaAtualizacao;
    }

    @Column(name="REFERENCIA", length=50)
    public String getReferencia() {
        return this.referencia;
    }

    public void setReferencia(String referencia) {
        this.referencia = referencia;
    }

    @OneToMany(fetch=FetchType.LAZY)
    @JoinTable(name="REQUISITO_FUNCAO_TREINAMENTO", joinColumns={@JoinColumn(name="ID_REQUISITOS_FUNCOES")}, inverseJoinColumns={@JoinColumn(name="ID_CARACTERISTICA_FUNCAO")})
    public List<CaracteristicaFuncao> getTreinamento() {
        return this.treinamento;
    }

    public void setTreinamento(List<CaracteristicaFuncao> treinamento) {
        this.treinamento = treinamento;
    }

    @OneToMany(fetch=FetchType.LAZY)
    @JoinTable(name="REQUISITOS_FUNCAO_HABILIDADE", joinColumns={@JoinColumn(name="ID_REQUISITOS_FUNCOES")}, inverseJoinColumns={@JoinColumn(name="ID_CARACTERISTICA_FUNCAO")})
    public List<CaracteristicaFuncao> getHabilidade() {
        return this.habilidade;
    }

    public void setHabilidade(List<CaracteristicaFuncao> habilidade) {
        this.habilidade = habilidade;
    }

    @OneToMany(fetch=FetchType.LAZY)
    @JoinTable(name="REQUISITOS_FUNCAO_ATRIBUICAO", joinColumns={@JoinColumn(name="ID_REQUISITOS_FUNCOES")}, inverseJoinColumns={@JoinColumn(name="ID_CARACTERISTICA_FUNCAO")})
    public List<CaracteristicaFuncao> getAtribuicao() {
        return this.atribuicao;
    }

    public void setAtribuicao(List<CaracteristicaFuncao> atribuicao) {
        this.atribuicao = atribuicao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getHabilidade()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

