/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.GrupoServicoRPS;
import com.touchcomp.basementor.model.vo.Nbs;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.ProdutoFaturamentoRPS;
import com.touchcomp.basementor.model.vo.TipoItemSped;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;

@Entity
@Table(name="SERVICO_RPS", uniqueConstraints={@UniqueConstraint(name="UNQ1_SERVICO_RPS", columnNames={"CODIGO_AUXILIAR_SERVICO"})})
public class ServicoRPS
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private String discriminacao;
    private PlanoContaGerencial planoContaGerencial;
    private Produto produtoPCP;
    private GrupoServicoRPS grupoServicoRPS;
    private CentroCusto centroCusto;
    private TipoItemSped tipoItemSped;
    private String codigoAuxiliarServico;
    private Short obrigarVincularCRMAt = 0;
    private Nbs nbs;
    private List<ProdutoFaturamentoRPS> produtoFaturamentoRPS = new ArrayList<ProdutoFaturamentoRPS>();

    @Id
    @Column(nullable=false, name="ID_SERVICO_RPS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_SERVICO_RPS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DATA_CADASTRO")
    @Temporal(value=TemporalType.DATE)
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(name="DISCRIMINACAO", length=2000)
    public String getDiscriminacao() {
        return this.discriminacao;
    }

    public void setDiscriminacao(String discriminacao) {
        this.discriminacao = discriminacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_GERENCIAL", foreignKey=@ForeignKey(name="FK_SERVICO_RPS_PC_GERENCIAL"))
    public PlanoContaGerencial getPlanoContaGerencial() {
        return this.planoContaGerencial;
    }

    public void setPlanoContaGerencial(PlanoContaGerencial planoContaGerencial) {
        this.planoContaGerencial = planoContaGerencial;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PRODUTO", foreignKey=@ForeignKey(name="FK_SERVICO_RPS_PRODUTO"))
    public Produto getProdutoPCP() {
        return this.produtoPCP;
    }

    public void setProdutoPCP(Produto produtoPCP) {
        this.produtoPCP = produtoPCP;
    }

    @OneToOne(targetEntity=GrupoServicoRPS.class, fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRUPO_SERVICO_RPS", foreignKey=@ForeignKey(name="FK_SERVICO_RPS_GR_SERV_RPS"))
    public GrupoServicoRPS getGrupoServicoRPS() {
        return this.grupoServicoRPS;
    }

    public void setGrupoServicoRPS(GrupoServicoRPS grupoServicoRPS) {
        this.grupoServicoRPS = grupoServicoRPS;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDiscriminacao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToOne(targetEntity=CentroCusto.class, fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_CUSTO", foreignKey=@ForeignKey(name="FK_SERVICO_RPS_C_CUSTO"))
    public CentroCusto getCentroCusto() {
        return this.centroCusto;
    }

    public void setCentroCusto(CentroCusto centroCusto) {
        this.centroCusto = centroCusto;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_ITEM_SPED", foreignKey=@ForeignKey(name="FK_SERVICO_RPS_TP_ITEM_SPED"))
    public TipoItemSped getTipoItemSped() {
        return this.tipoItemSped;
    }

    public void setTipoItemSped(TipoItemSped tipoItemSped) {
        this.tipoItemSped = tipoItemSped;
    }

    @Column(name="CODIGO_AUXILIAR_SERVICO", length=60)
    public String getCodigoAuxiliarServico() {
        return this.codigoAuxiliarServico;
    }

    public void setCodigoAuxiliarServico(String codigoAuxiliarServico) {
        this.codigoAuxiliarServico = codigoAuxiliarServico;
    }

    @Column(name="OBRIGAR_VINCULAR_CRMAT")
    public Short getObrigarVincularCRMAt() {
        return this.obrigarVincularCRMAt;
    }

    public void setObrigarVincularCRMAt(Short obrigarVincularCRMAt) {
        this.obrigarVincularCRMAt = obrigarVincularCRMAt;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NBS")
    public Nbs getNbs() {
        return this.nbs;
    }

    public void setNbs(Nbs nbs) {
        this.nbs = nbs;
    }

    @OneToMany(mappedBy="servicoRPS", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    public List<ProdutoFaturamentoRPS> getProdutoFaturamentoRPS() {
        return this.produtoFaturamentoRPS;
    }

    public void setProdutoFaturamentoRPS(List<ProdutoFaturamentoRPS> produtoFaturamentoRPS) {
        this.produtoFaturamentoRPS = produtoFaturamentoRPS;
    }
}

