/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.EntResponsavelPCSped;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.SpedContabilAssinante;
import com.touchcomp.basementor.model.vo.SpedContabilDRE;
import com.touchcomp.basementor.model.vo.SpedContabilDmpl;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="SPED_CONTABIL")
public class SpedContabil
implements InterfaceVO {
    private Long identificador;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private GrupoEmpresa grupoEmpresa;
    private Short tipoArquivo = 1;
    private Integer mes = 0;
    private Integer ano = 0;
    private Integer numeroOrdem = 0;
    private String naturezaOperacao;
    private Date dataArquivamento;
    private Date dataEncerramentoExercicioSocial;
    private Short situacaoInicioPeriodo = 0;
    private Short situacaoEspecial = 5;
    private Short finalidadeEscrituracao = 0;
    private String hashEscrituracaoSubstituta;
    private String nireSubstituta;
    private Short existenciaNire = 1;
    private Short tipoEntidade = 0;
    private Short tipoECD = 0;
    private String codigoSCP;
    private Short gerarI155ContasComMovimento = 1;
    private Short gerarJ100Sintetico = 0;
    private Short tipoDemonstracao = 1;
    private Short tipoCalculoJ150 = 0;
    private Short gerarJ150ContasComMovimento = 1;
    private Short gerarJ150Sintetico = 0;
    private Short gerarLancResultadoFinal = 0;
    private PlanoConta planoContaResultadoJ150;
    private Short gerarBlocoJ800 = 0;
    private Short gerarBlocoJ801 = 0;
    private List<SpedContabilAssinante> assinantes = new ArrayList<SpedContabilAssinante>();
    private Short indicadorModalidade = 0;
    private Short indicadorMudancaPlanoConta = 0;
    private EntResponsavelPCSped entResponsavel;
    private List<SpedContabilDRE> dreIndiceEconomico = new ArrayList<SpedContabilDRE>();
    private Date dataAbertura;
    private Date dataFinal;
    private String cabecalhoDemonstracao;
    private List<SpedContabilDmpl> registroJ210 = new ArrayList<SpedContabilDmpl>();

    @Id
    @Column(name="ID_SPED_CONTABIL")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_SPED_CONTABIL")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRUPO_EMPRESA", foreignKey=@ForeignKey(name="FK_SPED_CONTABIL_GR_EMP"))
    public GrupoEmpresa getGrupoEmpresa() {
        return this.grupoEmpresa;
    }

    public void setGrupoEmpresa(GrupoEmpresa grupoEmpresa) {
        this.grupoEmpresa = grupoEmpresa;
    }

    @Column(name="TIPO_ARQUIVO")
    public Short getTipoArquivo() {
        return this.tipoArquivo;
    }

    public void setTipoArquivo(Short tipoArquivo) {
        this.tipoArquivo = tipoArquivo;
    }

    @Column(name="MES")
    public Integer getMes() {
        return this.mes;
    }

    public void setMes(Integer mes) {
        this.mes = mes;
    }

    @Column(name="ANO")
    public Integer getAno() {
        return this.ano;
    }

    public void setAno(Integer ano) {
        this.ano = ano;
    }

    @Column(name="NUMERO_ORDEM")
    public Integer getNumeroOrdem() {
        return this.numeroOrdem;
    }

    public void setNumeroOrdem(Integer numeroOrdem) {
        this.numeroOrdem = numeroOrdem;
    }

    @Column(name="NATUREZA_OPERACAO", length=80)
    public String getNaturezaOperacao() {
        return this.naturezaOperacao;
    }

    public void setNaturezaOperacao(String naturezaOperacao) {
        this.naturezaOperacao = naturezaOperacao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_ARQUIVAMENTO")
    public Date getDataArquivamento() {
        return this.dataArquivamento;
    }

    public void setDataArquivamento(Date dataArquivamento) {
        this.dataArquivamento = dataArquivamento;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_ENC_EXERCICIO_SOCIAL")
    public Date getDataEncerramentoExercicioSocial() {
        return this.dataEncerramentoExercicioSocial;
    }

    public void setDataEncerramentoExercicioSocial(Date dataEncerramentoExercicioSocial) {
        this.dataEncerramentoExercicioSocial = dataEncerramentoExercicioSocial;
    }

    @Column(name="SITUACAO_INICIO_PERIODO")
    public Short getSituacaoInicioPeriodo() {
        return this.situacaoInicioPeriodo;
    }

    public void setSituacaoInicioPeriodo(Short situacaoInicioPeriodo) {
        this.situacaoInicioPeriodo = situacaoInicioPeriodo;
    }

    @Column(name="SITUACAO_ESPECIAL")
    public Short getSituacaoEspecial() {
        return this.situacaoEspecial;
    }

    public void setSituacaoEspecial(Short situacaoEspecial) {
        this.situacaoEspecial = situacaoEspecial;
    }

    @Column(name="FINALIDADE_ESCRITURACAO")
    public Short getFinalidadeEscrituracao() {
        return this.finalidadeEscrituracao;
    }

    public void setFinalidadeEscrituracao(Short finalidadeEscrituracao) {
        this.finalidadeEscrituracao = finalidadeEscrituracao;
    }

    @Column(name="HASH_ESCRITURACAO_SUBSTITUTA", length=40)
    public String getHashEscrituracaoSubstituta() {
        return this.hashEscrituracaoSubstituta;
    }

    public void setHashEscrituracaoSubstituta(String hashEscrituracaoSubstituta) {
        this.hashEscrituracaoSubstituta = hashEscrituracaoSubstituta;
    }

    @Column(name="NIRE_SUBSTITUICAO", length=11)
    public String getNireSubstituta() {
        return this.nireSubstituta;
    }

    public void setNireSubstituta(String nireSubstituta) {
        this.nireSubstituta = nireSubstituta;
    }

    @Column(name="EXISTENCIA_NIRE")
    public Short getExistenciaNire() {
        return this.existenciaNire;
    }

    public void setExistenciaNire(Short existenciaNire) {
        this.existenciaNire = existenciaNire;
    }

    @Column(name="TIPO_ENTIDADE")
    public Short getTipoEntidade() {
        return this.tipoEntidade;
    }

    public void setTipoEntidade(Short tipoEntidade) {
        this.tipoEntidade = tipoEntidade;
    }

    @Column(name="TIPO_ECD")
    public Short getTipoECD() {
        return this.tipoECD;
    }

    public void setTipoECD(Short tipoECD) {
        this.tipoECD = tipoECD;
    }

    @Column(name="CODIGO_SCP", length=14)
    public String getCodigoSCP() {
        return this.codigoSCP;
    }

    public void setCodigoSCP(String codigoSCP) {
        this.codigoSCP = codigoSCP;
    }

    @Column(name="GERAR_I155_COM_MOVIMENTO")
    public Short getGerarI155ContasComMovimento() {
        return this.gerarI155ContasComMovimento;
    }

    public void setGerarI155ContasComMovimento(Short gerarI155ContasComMovimento) {
        this.gerarI155ContasComMovimento = gerarI155ContasComMovimento;
    }

    @Column(name="GERAR_J100_SINTETICO")
    public Short getGerarJ100Sintetico() {
        return this.gerarJ100Sintetico;
    }

    public void setGerarJ100Sintetico(Short gerarJ100Sintetico) {
        this.gerarJ100Sintetico = gerarJ100Sintetico;
    }

    @Column(name="TIPO_DEMONSTRACAO")
    public Short getTipoDemonstracao() {
        return this.tipoDemonstracao;
    }

    public void setTipoDemonstracao(Short tipoDemonstracao) {
        this.tipoDemonstracao = tipoDemonstracao;
    }

    @Column(name="TIPO_CALCULO_J150")
    public Short getTipoCalculoJ150() {
        return this.tipoCalculoJ150;
    }

    public void setTipoCalculoJ150(Short tipoCalculoJ150) {
        this.tipoCalculoJ150 = tipoCalculoJ150;
    }

    @Column(name="GERAR_J150_COM_MOVIMENTO")
    public Short getGerarJ150ContasComMovimento() {
        return this.gerarJ150ContasComMovimento;
    }

    public void setGerarJ150ContasComMovimento(Short gerarJ150ContasComMovimento) {
        this.gerarJ150ContasComMovimento = gerarJ150ContasComMovimento;
    }

    @Column(name="GERAR_J150_SINTETICO")
    public Short getGerarJ150Sintetico() {
        return this.gerarJ150Sintetico;
    }

    public void setGerarJ150Sintetico(Short gerarJ150Sintetico) {
        this.gerarJ150Sintetico = gerarJ150Sintetico;
    }

    @Column(name="GERAR_LANC_RESULTADO_FINAL")
    public Short getGerarLancResultadoFinal() {
        return this.gerarLancResultadoFinal;
    }

    public void setGerarLancResultadoFinal(Short gerarLancResultadoFinal) {
        this.gerarLancResultadoFinal = gerarLancResultadoFinal;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PLANO_CONTA_RESULTADO_J150", foreignKey=@ForeignKey(name="FK_SPED_CONTABIL_PC_LANC_RES"))
    public PlanoConta getPlanoContaResultadoJ150() {
        return this.planoContaResultadoJ150;
    }

    public void setPlanoContaResultadoJ150(PlanoConta planoContaResultadoJ150) {
        this.planoContaResultadoJ150 = planoContaResultadoJ150;
    }

    @Column(name="GERAR_BLOCO_J800")
    public Short getGerarBlocoJ800() {
        return this.gerarBlocoJ800;
    }

    public void setGerarBlocoJ800(Short gerarBlocoJ800) {
        this.gerarBlocoJ800 = gerarBlocoJ800;
    }

    @Column(name="GERAR_BLOCO_J801")
    public Short getGerarBlocoJ801() {
        return this.gerarBlocoJ801;
    }

    public void setGerarBlocoJ801(Short gerarBlocoJ801) {
        this.gerarBlocoJ801 = gerarBlocoJ801;
    }

    @OneToMany(mappedBy="spedContabil")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<SpedContabilAssinante> getAssinantes() {
        return this.assinantes;
    }

    public void setAssinantes(List<SpedContabilAssinante> assinantes) {
        this.assinantes = assinantes;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="IND_MODALIDADE")
    public Short getIndicadorModalidade() {
        return this.indicadorModalidade;
    }

    public void setIndicadorModalidade(Short indicadorModalidade) {
        this.indicadorModalidade = indicadorModalidade;
    }

    @Column(name="IND_MUDANCA_PLANO_CONTA")
    public Short getIndicadorMudancaPlanoConta() {
        return this.indicadorMudancaPlanoConta;
    }

    public void setIndicadorMudancaPlanoConta(Short indicadorMudancaPlanoConta) {
        this.indicadorMudancaPlanoConta = indicadorMudancaPlanoConta;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ENTIDADE_RESPONSAVEL", foreignKey=@ForeignKey(name="FK_SPED_CONTABIL_ENT_RESP_SPED"))
    public EntResponsavelPCSped getEntResponsavel() {
        return this.entResponsavel;
    }

    public void setEntResponsavel(EntResponsavelPCSped entResponsavel) {
        this.entResponsavel = entResponsavel;
    }

    @OneToMany(mappedBy="spedContabil")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<SpedContabilDRE> getDreIndiceEconomico() {
        return this.dreIndiceEconomico;
    }

    public void setDreIndiceEconomico(List<SpedContabilDRE> dreIndiceEconomico) {
        this.dreIndiceEconomico = dreIndiceEconomico;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_ABERTURA")
    public Date getDataAbertura() {
        return this.dataAbertura;
    }

    public void setDataAbertura(Date dataAbertura) {
        this.dataAbertura = dataAbertura;
    }

    @Column(name="CABECALHO_DEMONSTRACAO", length=1000)
    public String getCabecalhoDemonstracao() {
        return this.cabecalhoDemonstracao;
    }

    public void setCabecalhoDemonstracao(String cabecalhoDemonstracao) {
        this.cabecalhoDemonstracao = cabecalhoDemonstracao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_FINAL")
    public Date getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    @OneToMany(mappedBy="spedContabil", fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<SpedContabilDmpl> getRegistroJ210() {
        return this.registroJ210;
    }

    public void setRegistroJ210(List<SpedContabilDmpl> registroJ210) {
        this.registroJ210 = registroJ210;
    }
}

