/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.ItemTabelaIRRFPlr;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@Table(name="TABELA_IRRF_PLR")
public class TabelaIRRFPlr
implements InterfaceVO {
    private Long identificador;
    private Date dataInicial;
    private Date dataFinal;
    private Double vrDeducaoPorDependente = 0.0;
    private Double vrMinimoADescontar = 0.0;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private List<ItemTabelaIRRFPlr> itensTabela = new ArrayList<ItemTabelaIRRFPlr>();
    private Double valorDescontoSimplicado = 0.0;

    @Id
    @Column(name="ID_TABELA_IRRF_PLR")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_TABELA_IRRF_PLR")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_INICIAL")
    public Date getDataInicial() {
        return this.dataInicial;
    }

    public void setDataInicial(Date dataInicial) {
        this.dataInicial = dataInicial;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_FINAL")
    public Date getDataFinal() {
        return this.dataFinal;
    }

    public void setDataFinal(Date dataFinal) {
        this.dataFinal = dataFinal;
    }

    @Column(name="VR_DEDUCAO_POR_DEPENDENTE", precision=15, scale=2)
    public Double getVrDeducaoPorDependente() {
        return this.vrDeducaoPorDependente;
    }

    public void setVrDeducaoPorDependente(Double vrDeducaoPorDependente) {
        this.vrDeducaoPorDependente = vrDeducaoPorDependente;
    }

    @Column(nullable=false, name="VR_MINIMO_A_DESCONTAR", precision=15, scale=2)
    public Double getVrMinimoADescontar() {
        return this.vrMinimoADescontar;
    }

    public void setVrMinimoADescontar(Double vrMinimoADescontar) {
        this.vrMinimoADescontar = vrMinimoADescontar;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_TABELA_IRRF_PLR_EMPRESA"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @OneToMany(mappedBy="tabelaIRRFPlr", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<ItemTabelaIRRFPlr> getItensTabela() {
        return this.itensTabela;
    }

    public void setItensTabela(List<ItemTabelaIRRFPlr> itensTabela) {
        this.itensTabela = itensTabela;
    }

    @Column(nullable=false, name="VR_DESCONTO_SIMPLIFICADO", precision=15, scale=4)
    public Double getValorDescontoSimplicado() {
        return this.valorDescontoSimplicado;
    }

    public void setValorDescontoSimplicado(Double valorDescontoSimplicado) {
        this.valorDescontoSimplicado = valorDescontoSimplicado;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }
}

