/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.ticketfiscal.EnumConstTicketFiscalStatus;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.ConjuntoTransportador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeItemTicketFiscal;
import com.touchcomp.basementor.model.vo.LoteFabricacao;
import com.touchcomp.basementor.model.vo.Motorista;
import com.touchcomp.basementor.model.vo.NaturezaOperacaoTicketFiscal;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.ObsTicketFiscal;
import com.touchcomp.basementor.model.vo.OrdemServicoProdLinhaProd;
import com.touchcomp.basementor.model.vo.OrdemServicoProdSobEnc;
import com.touchcomp.basementor.model.vo.PedidoTicketFiscal;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.Transportador;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="TICKET_FISCAL")
public class TicketFiscal
implements InterfaceVO {
    private Long identificador;
    private Empresa empresa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Short status;
    private NaturezaOperacaoTicketFiscal naturezaOperacaoTicketFiscal;
    private String serie;
    private Integer numero;
    private String serieImportado;
    private Integer numeroImportado;
    private Integer numeroInformado;
    private Date dataAbertura;
    private Date dataFechamento;
    private UnidadeFatCliente unidadeFatCliente;
    private Double pesoVeiculo;
    private Double pesoEstimado;
    private Double pesoLiquidoEstimado;
    private Double pesoTotal;
    private Double pesoLiquidoTotal;
    private Transportador transportador;
    private Motorista motorista;
    private String placa;
    private String placaCarreta;
    private Produto produto;
    private GradeCor gradeCor;
    private LoteFabricacao loteFabricacao;
    private CentroEstoque centroEstoque;
    private List<GradeItemTicketFiscal> gradeItemTicketFiscal;
    private List<ObsTicketFiscal> obsTicketFiscal;
    private String observacoes;
    private String motivoCancelamento;
    private NotaFiscalPropria notaFiscalPropria;
    private List<PedidoTicketFiscal> pedidoTicketFiscal;
    private Short infManualPeso;
    private String motivoManualPeso;
    private ConjuntoTransportador conjuntoTransportador;
    private String codigoMD5;
    private Usuario usuario;
    private OrdemServicoProdSobEnc osSobEncomenda;
    private OrdemServicoProdLinhaProd osLinhaProducao;

    public TicketFiscal() {
        this.status = EnumConstTicketFiscalStatus.ABERTO.value;
        this.numero = 0;
        this.numeroImportado = 0;
        this.numeroInformado = 0;
        this.pesoVeiculo = 0.0;
        this.pesoEstimado = 0.0;
        this.pesoLiquidoEstimado = 0.0;
        this.pesoTotal = 0.0;
        this.pesoLiquidoTotal = 0.0;
        this.gradeItemTicketFiscal = new ArrayList<GradeItemTicketFiscal>();
        this.obsTicketFiscal = new ArrayList<ObsTicketFiscal>();
        this.pedidoTicketFiscal = new ArrayList<PedidoTicketFiscal>();
        this.infManualPeso = EnumConstantsMentorSimNao.NAO.value;
    }

    @Id
    @Column(nullable=false, name="ID_TICKET_FISCAL")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_TICKET_FISCAL")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_TICKET_FISCAL_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(nullable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Column(nullable=false, name="STATUS")
    public Short getStatus() {
        return this.status;
    }

    public void setStatus(Short status) {
        this.status = status;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_NATUREZA_OP_TICKET", foreignKey=@ForeignKey(name="FK_TICKET_FISCAL_NAT_OP_TICK"))
    public NaturezaOperacaoTicketFiscal getNaturezaOperacaoTicketFiscal() {
        return this.naturezaOperacaoTicketFiscal;
    }

    public void setNaturezaOperacaoTicketFiscal(NaturezaOperacaoTicketFiscal naturezaOperacaoTicketFiscal) {
        this.naturezaOperacaoTicketFiscal = naturezaOperacaoTicketFiscal;
    }

    @Column(nullable=false, name="SERIE", length=10)
    public String getSerie() {
        return this.serie;
    }

    public void setSerie(String serie) {
        this.serie = serie;
    }

    @Column(name="NUMERO")
    @Generated(value=GenerationTime.ALWAYS)
    public Integer getNumero() {
        return this.numero;
    }

    public void setNumero(Integer numero) {
        this.numero = numero;
    }

    @Column(name="SERIE_IMPORTADO", length=10)
    public String getSerieImportado() {
        return this.serieImportado;
    }

    public void setSerieImportado(String serieImportado) {
        this.serieImportado = serieImportado;
    }

    @Column(name="NUMERO_IMPORTADO")
    public Integer getNumeroImportado() {
        return this.numeroImportado;
    }

    public void setNumeroImportado(Integer numeroImportado) {
        this.numeroImportado = numeroImportado;
    }

    @Column(name="NUMERO_INFORMADO")
    public Integer getNumeroInformado() {
        return this.numeroInformado;
    }

    public void setNumeroInformado(Integer numeroInformado) {
        this.numeroInformado = numeroInformado;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(nullable=false, name="DATA_ABERTURA")
    public Date getDataAbertura() {
        return this.dataAbertura;
    }

    public void setDataAbertura(Date dataAbertura) {
        this.dataAbertura = dataAbertura;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_FECHAMENTO")
    public Date getDataFechamento() {
        return this.dataFechamento;
    }

    public void setDataFechamento(Date dataFechamento) {
        this.dataFechamento = dataFechamento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_UNIDADE_FAT_CLIENTE", foreignKey=@ForeignKey(name="FK_TICKET_FISCAL_UNID_F_CLIENTE"))
    public UnidadeFatCliente getUnidadeFatCliente() {
        return this.unidadeFatCliente;
    }

    public void setUnidadeFatCliente(UnidadeFatCliente unidadeFatCliente) {
        this.unidadeFatCliente = unidadeFatCliente;
    }

    @Column(nullable=false, name="PESO_VEICULO", precision=12, scale=3)
    public Double getPesoVeiculo() {
        return this.pesoVeiculo;
    }

    public void setPesoVeiculo(Double pesoVeiculo) {
        this.pesoVeiculo = pesoVeiculo;
    }

    @Column(nullable=false, name="PESO_ESTIMADO", precision=12, scale=3)
    public Double getPesoEstimado() {
        return this.pesoEstimado;
    }

    public void setPesoEstimado(Double pesoEstimado) {
        this.pesoEstimado = pesoEstimado;
    }

    @Column(nullable=false, name="PESO_LIQUIDO_ESTIMADO", precision=12, scale=3)
    public Double getPesoLiquidoEstimado() {
        return this.pesoLiquidoEstimado;
    }

    public void setPesoLiquidoEstimado(Double pesoLiquidoEstimado) {
        this.pesoLiquidoEstimado = pesoLiquidoEstimado;
    }

    @Column(nullable=false, name="PESO_TOTAL", precision=12, scale=3)
    public Double getPesoTotal() {
        return this.pesoTotal;
    }

    public void setPesoTotal(Double pesoTotal) {
        this.pesoTotal = pesoTotal;
    }

    @Column(nullable=false, name="PESO_LIQUIDO_TOTAL", precision=12, scale=3)
    public Double getPesoLiquidoTotal() {
        return this.pesoLiquidoTotal;
    }

    public void setPesoLiquidoTotal(Double pesoLiquidoTotal) {
        this.pesoLiquidoTotal = pesoLiquidoTotal;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_TRANSPORTADOR", foreignKey=@ForeignKey(name="FK_TICKET_FISCAL_TRANSPORTADOR"))
    public Transportador getTransportador() {
        return this.transportador;
    }

    public void setTransportador(Transportador transportador) {
        this.transportador = transportador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_MOTORISTA", foreignKey=@ForeignKey(name="FK_TICKET_FISCAL_MOTORISTA"))
    public Motorista getMotorista() {
        return this.motorista;
    }

    public void setMotorista(Motorista motorista) {
        this.motorista = motorista;
    }

    @Column(nullable=false, name="PLACA", length=7)
    public String getPlaca() {
        return this.placa;
    }

    public void setPlaca(String placa) {
        this.placa = placa;
    }

    @Column(nullable=false, name="PLACA_CARRETA", length=7)
    public String getPlacaCarreta() {
        return this.placaCarreta;
    }

    public void setPlacaCarreta(String placaCarreta) {
        this.placaCarreta = placaCarreta;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PRODUTO", foreignKey=@ForeignKey(name="FK_TICKET_FISCAL_PRODUTO"))
    public Produto getProduto() {
        return this.produto;
    }

    public void setProduto(Produto produto) {
        this.produto = produto;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_GRADE_COR", foreignKey=@ForeignKey(name="FK_TICKET_FISCAL_GRADE_COR"))
    public GradeCor getGradeCor() {
        return this.gradeCor;
    }

    public void setGradeCor(GradeCor gradeCor) {
        this.gradeCor = gradeCor;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_LOTE_FABRICACAO", foreignKey=@ForeignKey(name="FK_TICKET_FISCAL_LOTE_FABRICACA"))
    public LoteFabricacao getLoteFabricacao() {
        return this.loteFabricacao;
    }

    public void setLoteFabricacao(LoteFabricacao loteFabricacao) {
        this.loteFabricacao = loteFabricacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_ESTOQUE", foreignKey=@ForeignKey(name="FK_TICKET_FISCAL_CENTRO_ESTOQUE"))
    public CentroEstoque getCentroEstoque() {
        return this.centroEstoque;
    }

    public void setCentroEstoque(CentroEstoque centroEstoque) {
        this.centroEstoque = centroEstoque;
    }

    @OneToMany(mappedBy="ticketFiscal", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<GradeItemTicketFiscal> getGradeItemTicketFiscal() {
        return this.gradeItemTicketFiscal;
    }

    public void setGradeItemTicketFiscal(List<GradeItemTicketFiscal> gradeItemTicketFiscal) {
        this.gradeItemTicketFiscal = gradeItemTicketFiscal;
    }

    @OneToMany(mappedBy="ticketFiscal", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<ObsTicketFiscal> getObsTicketFiscal() {
        return this.obsTicketFiscal;
    }

    public void setObsTicketFiscal(List<ObsTicketFiscal> obsTicketFiscal) {
        this.obsTicketFiscal = obsTicketFiscal;
    }

    @Column(name="OBSERVACOES", length=5000)
    public String getObservacoes() {
        return this.observacoes;
    }

    public void setObservacoes(String observacoes) {
        this.observacoes = observacoes;
    }

    @Column(name="MOTIVO_CANCELAMENTO", length=1000)
    public String getMotivoCancelamento() {
        return this.motivoCancelamento;
    }

    public void setMotivoCancelamento(String motivoCancelamento) {
        this.motivoCancelamento = motivoCancelamento;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0} - {1}", (Object[])new Object[]{this.getIdentificador(), this.getPlaca()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NOTA_FISCAL_PROPRIA", foreignKey=@ForeignKey(name="FK_TICKET_FISCAL_NOTA_PROPRIA"))
    @Cascade(value={org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST})
    public NotaFiscalPropria getNotaFiscalPropria() {
        return this.notaFiscalPropria;
    }

    public void setNotaFiscalPropria(NotaFiscalPropria notaFiscalPropria) {
        this.notaFiscalPropria = notaFiscalPropria;
    }

    @OneToMany(mappedBy="ticketFiscal", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<PedidoTicketFiscal> getPedidoTicketFiscal() {
        return this.pedidoTicketFiscal;
    }

    public void setPedidoTicketFiscal(List<PedidoTicketFiscal> pedidoTicketFiscal) {
        this.pedidoTicketFiscal = pedidoTicketFiscal;
    }

    @Column(name="INF_MANUAL_PESO")
    public Short getInfManualPeso() {
        return this.infManualPeso;
    }

    public void setInfManualPeso(Short infManualPeso) {
        this.infManualPeso = infManualPeso;
    }

    @Column(name="MOTIVO_MANUAL_PESO", length=500)
    public String getMotivoManualPeso() {
        return this.motivoManualPeso;
    }

    public void setMotivoManualPeso(String motivoManualPeso) {
        this.motivoManualPeso = motivoManualPeso;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CONJUNTO_TRANSPORTADOR", foreignKey=@ForeignKey(name="FK_TICKET_FISCAL_CONJ_TRANSP"))
    public ConjuntoTransportador getConjuntoTransportador() {
        return this.conjuntoTransportador;
    }

    public void setConjuntoTransportador(ConjuntoTransportador conjuntoTransportador) {
        this.conjuntoTransportador = conjuntoTransportador;
    }

    @Column(name="codigo_md5")
    public String getCodigoMD5() {
        return this.codigoMD5;
    }

    public void setCodigoMD5(String codigoMD5) {
        this.codigoMD5 = codigoMD5;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_USUARIO", foreignKey=@ForeignKey(name="FK_"))
    public Usuario getUsuario() {
        return this.usuario;
    }

    public void setUsuario(Usuario usuario) {
        this.usuario = usuario;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_OS_SOB_ENCOMENDA")
    public OrdemServicoProdSobEnc getOsSobEncomenda() {
        return this.osSobEncomenda;
    }

    public void setOsSobEncomenda(OrdemServicoProdSobEnc osSobEncomenda) {
        this.osSobEncomenda = osSobEncomenda;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_OS_LINHA_PRODUCAO")
    public OrdemServicoProdLinhaProd getOsLinhaProducao() {
        return this.osLinhaProducao;
    }

    public void setOsLinhaProducao(OrdemServicoProdLinhaProd osLinhaProducao) {
        this.osLinhaProducao = osLinhaProducao;
    }
}

