/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;

@Entity
@Table(name="TIPO_FERIAS", uniqueConstraints={@UniqueConstraint(name="UNQ1_TIPO_FERIAS", columnNames={"DESCRICAO"})})
public class TipoFerias
implements InterfaceVO {
    private Long identificador;
    private String descricao;
    private Integer nrDiasGozoFerias = 0;
    private Integer nrDiasAbonoPecuniario = 0;
    private Empresa empresa;
    private Timestamp dataAtualizacao;
    private Date dataCadastro;
    private Short abonoInicio = EnumConstantsMentorSimNao.SIM.getValue();
    private Short ativo = EnumConstantsMentorSimNao.SIM.getValue();

    @Id
    @Column(name="ID_TIPO_FERIAS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_TIPO_FERIAS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="DESCRICAO", length=50)
    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Column(name="NR_DIAS_ABONO_PECUNIARIO")
    public Integer getNrDiasAbonoPecuniario() {
        return this.nrDiasAbonoPecuniario;
    }

    public void setNrDiasAbonoPecuniario(Integer nrDiasAbonoPecuniario) {
        this.nrDiasAbonoPecuniario = nrDiasAbonoPecuniario;
    }

    @Column(name="NR_DIAS_GOZO_FERIAS")
    public Integer getNrDiasGozoFerias() {
        return this.nrDiasGozoFerias;
    }

    public void setNrDiasGozoFerias(Integer nrDiasGozoFerias) {
        this.nrDiasGozoFerias = nrDiasGozoFerias;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getDescricao()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_TIPO_FERIAS_1"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Column(name="ABONO_INICIO")
    public Short getAbonoInicio() {
        return this.abonoInicio;
    }

    public void setAbonoInicio(Short abonoInicio) {
        this.abonoInicio = abonoInicio;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }
}

