/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CategoriaCbsIbs;
import com.touchcomp.basementor.model.vo.CategoriaPessoa;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.ClassificacaoClientes;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.ReinfServicoConstrucaoCivil;
import com.touchcomp.basementor.model.vo.TabelaCalculoFrete;
import com.touchcomp.basementor.model.vo.TipoContribuinteCbsIbs;
import com.touchcomp.basementor.model.vo.TipoOperacao;
import com.touchcomp.basementor.model.vo.TomadorPrestadorRpsCentroCusto;
import com.touchcomp.basementor.model.vo.UnidadeFatTomPrestRPS;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="TOMADOR_PRESTADOR_RPS")
public class TomadorPrestadorRps
implements InterfaceVO {
    private Long identificador;
    private Pessoa pessoa;
    private Date dataCadastro;
    private Timestamp dataAtualizacao;
    private Empresa empresa;
    private PlanoConta planoContaCliente;
    private PlanoConta planoContaFornecedor;
    private PlanoConta planoContaTomadorAntec;
    private List<UnidadeFatTomPrestRPS> unidadesFat = new ArrayList<UnidadeFatTomPrestRPS>();
    private Double distanciaKM = 0.0;
    private Double taxaServico = 0.0;
    private Integer numDiasVenc = 0;
    private TabelaCalculoFrete tabelaCalcFrete;
    private TipoOperacao tipoOperacao;
    private Short tipoIss = Short.valueOf("2");
    private CentroCusto centroCusto;
    private List<TomadorPrestadorRpsCentroCusto> centroCustos = new ArrayList<TomadorPrestadorRpsCentroCusto>();
    private ReinfServicoConstrucaoCivil servicoObra;
    private CategoriaPessoa categoriaPessoa;
    private ClassificacaoClientes classificacaoPessoa;
    private Short ativo = 1;
    private TipoContribuinteCbsIbs tipoContribuinteCbsIbs;
    private CategoriaCbsIbs categoriaCbsIbs;

    @Id
    @Column(name="ID_TOMADOR_PRESTADOR_RPS")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_TOMADOR_PRESTADOR_RPS")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, unique=true, name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_TOMADOR_PRESTADOR_RPS_PES"))
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Version
    @Column(name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @JoinColumn(name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_TOMADOR_PRESTADOR_RPS_EMP"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    @JoinColumn(name="ID_PLANO_CONTA_CLIENTE", foreignKey=@ForeignKey(name="FK_TOMADOR_PRESTADOR_RPS_PC_CLI"))
    public PlanoConta getPlanoContaCliente() {
        return this.planoContaCliente;
    }

    public void setPlanoContaCliente(PlanoConta planoContaCliente) {
        this.planoContaCliente = planoContaCliente;
    }

    @JoinColumn(name="ID_PLANO_CONTA_FORN", foreignKey=@ForeignKey(name="FK_TOMADOR_PRESTADOR_RPS_PC_FOR"))
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    @ManyToOne(fetch=FetchType.LAZY)
    public PlanoConta getPlanoContaFornecedor() {
        return this.planoContaFornecedor;
    }

    public void setPlanoContaFornecedor(PlanoConta planoContaFornecedor) {
        this.planoContaFornecedor = planoContaFornecedor;
    }

    @JoinColumn(name="ID_PLANO_CONTA_TOMADOR_ANTEC", foreignKey=@ForeignKey(name="FK_TOMA_PREST_RPS_PC_TOMAD_ANTC"))
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    @ManyToOne(fetch=FetchType.LAZY)
    public PlanoConta getPlanoContaTomadorAntec() {
        return this.planoContaTomadorAntec;
    }

    public void setPlanoContaTomadorAntec(PlanoConta planoContaTomadorAntec) {
        this.planoContaTomadorAntec = planoContaTomadorAntec;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return this.getPessoa() != null ? ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getPessoa().getNome()}) : ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @OneToMany(cascade={CascadeType.ALL}, mappedBy="tomadorPrestadorRPS")
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<UnidadeFatTomPrestRPS> getUnidadesFat() {
        return this.unidadesFat;
    }

    public void setUnidadesFat(List<UnidadeFatTomPrestRPS> unidadesFat) {
        this.unidadesFat = unidadesFat;
    }

    @Column(nullable=false, name="DISTANCIA_KM", precision=15, scale=3)
    public Double getDistanciaKM() {
        return this.distanciaKM;
    }

    public void setDistanciaKM(Double distanciaKM) {
        this.distanciaKM = distanciaKM;
    }

    @Column(nullable=false, name="TAXA_SERVICO", precision=15, scale=6)
    public Double getTaxaServico() {
        return this.taxaServico;
    }

    public void setTaxaServico(Double taxaServico) {
        this.taxaServico = taxaServico;
    }

    @JoinColumn(name="ID_TABELA_CALC_FRETE", foreignKey=@ForeignKey(name="FK_TOMADOR_PRESTADOR_RPS_TAB_CF"))
    @ManyToOne(fetch=FetchType.LAZY)
    public TabelaCalculoFrete getTabelaCalcFrete() {
        return this.tabelaCalcFrete;
    }

    public void setTabelaCalcFrete(TabelaCalculoFrete tabelaCalcFrete) {
        this.tabelaCalcFrete = tabelaCalcFrete;
    }

    @JoinColumn(name="ID_TIPO_OPERACAO", foreignKey=@ForeignKey(name="FK_TOMADOR_PRESTADOR_RPS_TP_OP"))
    @ManyToOne(fetch=FetchType.LAZY)
    public TipoOperacao getTipoOperacao() {
        return this.tipoOperacao;
    }

    public void setTipoOperacao(TipoOperacao tipoOperacao) {
        this.tipoOperacao = tipoOperacao;
    }

    @Column(name="NUM_DIAS_VENCIMENTO")
    public Integer getNumDiasVenc() {
        return this.numDiasVenc;
    }

    public void setNumDiasVenc(Integer numDiasVenc) {
        this.numDiasVenc = numDiasVenc;
    }

    @Column(name="TIPO_ISS")
    public Short getTipoIss() {
        return this.tipoIss;
    }

    public void setTipoIss(Short tipoIss) {
        this.tipoIss = tipoIss;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CENTRO_CUSTO", foreignKey=@ForeignKey(name="FK_TOMADOR_PREST_CENTRO_CUSTO"))
    public CentroCusto getCentroCusto() {
        return this.centroCusto;
    }

    public void setCentroCusto(CentroCusto centroCusto) {
        this.centroCusto = centroCusto;
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="tomador", cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.SAVE_UPDATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    public List<TomadorPrestadorRpsCentroCusto> getCentroCustos() {
        return this.centroCustos;
    }

    public void setCentroCustos(List<TomadorPrestadorRpsCentroCusto> centroCustos) {
        this.centroCustos = centroCustos;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_REINF_SERV_CONS_CIVIL", foreignKey=@ForeignKey(name="FK_REINF_SERV_CONS_CIVIL"))
    public ReinfServicoConstrucaoCivil getServicoObra() {
        return this.servicoObra;
    }

    public void setServicoObra(ReinfServicoConstrucaoCivil servicoObra) {
        this.servicoObra = servicoObra;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CATEGORIA_PESSOA", foreignKey=@ForeignKey(name="FK_TOM_PREST_RPS_CAT_PESSOA"))
    public CategoriaPessoa getCategoriaPessoa() {
        return this.categoriaPessoa;
    }

    public void setCategoriaPessoa(CategoriaPessoa categoriaPessoa) {
        this.categoriaPessoa = categoriaPessoa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLASSIFICACAO_PESSOA", foreignKey=@ForeignKey(name="FK_TOM_PREST_RPS_CLA_PESSOA"))
    public ClassificacaoClientes getClassificacaoPessoa() {
        return this.classificacaoPessoa;
    }

    public void setClassificacaoPessoa(ClassificacaoClientes classificacaoPessoa) {
        this.classificacaoPessoa = classificacaoPessoa;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CATEGORIA_CBS_IBS", foreignKey=@ForeignKey(name="FK_CLIENTE_FAT_CAT_CBS_IBS"))
    public CategoriaCbsIbs getCategoriaCbsIbs() {
        return this.categoriaCbsIbs;
    }

    public void setCategoriaCbsIbs(CategoriaCbsIbs categoriaCbsIbs) {
        this.categoriaCbsIbs = categoriaCbsIbs;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_CONTRIB_CBS_IBS", foreignKey=@ForeignKey(name="FK_CLI_FAT_TIPO_C_CBS_IBS"))
    public TipoContribuinteCbsIbs getTipoContribuinteCbsIbs() {
        return this.tipoContribuinteCbsIbs;
    }

    public void setTipoContribuinteCbsIbs(TipoContribuinteCbsIbs tipoContribuinteCbsIbs) {
        this.tipoContribuinteCbsIbs = tipoContribuinteCbsIbs;
    }
}

