/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.constants.enums.receitaagronomica.EnumConstProvedorRecAgro;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.CategoriaCbsIbs;
import com.touchcomp.basementor.model.vo.CategoriaPessoa;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.Endereco;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.TalhaoPropriedade;
import com.touchcomp.basementor.model.vo.TipoContribuinteCbsIbs;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="UNIDADE_FAT_CLIENTE")
public class UnidadeFatCliente
implements InterfaceVO {
    private Long identificador;
    private Endereco enderecoEntrega;
    private Cliente cliente;
    private Short usarComoEnderecoEnt = 0;
    private Short unidadeFatPadrao = 0;
    private Timestamp dataAtualizacao;
    private Pessoa pessoa;
    private String codigoSincronizacao;
    private String codigoSincronizacao2;
    private Date dataAtualizacaoSevTerc;
    private Short codProvServicoRec = EnumConstProvedorRecAgro.SEM_VINCULO_SERVICO.getValue();
    private List<TalhaoPropriedade> talhoes = new LinkedList<TalhaoPropriedade>();
    private CategoriaPessoa categoriaPessoa;
    private CategoriaCbsIbs categoriaCbsIbs;
    private TipoContribuinteCbsIbs tipoContribuinteCbsIbs;

    @Id
    @Column(name="ID_UNIDADE_FAT_CLIENTE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_UNIDADE_FAT_CLIENTE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CLIENTE", foreignKey=@ForeignKey(name="FK_UNIDADE_FAT_CLIENTE_CLIENTE"))
    public Cliente getCliente() {
        return this.cliente;
    }

    public void setCliente(Cliente cliente) {
        this.cliente = cliente;
    }

    @Column(name="USAR_COMO_ENDERECO_ENT")
    public Short getUsarComoEnderecoEnt() {
        return this.usarComoEnderecoEnt;
    }

    public void setUsarComoEnderecoEnt(Short usarComoEnderecoEnt) {
        this.usarComoEnderecoEnt = usarComoEnderecoEnt;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}  {1} - Cep: {2} IE: {3}", (Object[])new Object[]{this.getPessoa() != null ? this.getPessoa().getNome() : "", this.getPessoa() != null && this.getPessoa().getNomeFantasia() != null ? this.getPessoa().getNomeFantasia() : "", this.getPessoa() != null ? this.getPessoa().getEndereco().getCep() : "", this.getPessoa() != null && this.getPessoa().getComplemento().getInscEst() != null ? this.getPessoa().getComplemento().getInscEst() : ""});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="UNIDADE_FAT_PADRAO")
    public Short getUnidadeFatPadrao() {
        return this.unidadeFatPadrao;
    }

    public void setUnidadeFatPadrao(Short unidadeFatPadrao) {
        this.unidadeFatPadrao = unidadeFatPadrao;
    }

    @Version
    @Generated(value=GenerationTime.ALWAYS)
    @Column(nullable=false, updatable=false, insertable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_ENDERECO_ENTREGA", foreignKey=@ForeignKey(name="FK_UNIDADE_FAT_CLIENTE_END"))
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public Endereco getEnderecoEntrega() {
        return this.enderecoEntrega;
    }

    public void setEnderecoEntrega(Endereco enderecoEntrega) {
        this.enderecoEntrega = enderecoEntrega;
    }

    @ManyToOne(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, fetch=FetchType.LAZY)
    @JoinColumn(name="ID_PESSOA", foreignKey=@ForeignKey(name="FK_UNIDADE_FAT_CLIENTE_PESSOA"))
    public Pessoa getPessoa() {
        return this.pessoa;
    }

    public void setPessoa(Pessoa pessoa) {
        this.pessoa = pessoa;
    }

    @Column(name="CODIGO_SINCRONIZACAO", length=100)
    public String getCodigoSincronizacao() {
        return this.codigoSincronizacao;
    }

    public void setCodigoSincronizacao(String codigoSincronizacao) {
        this.codigoSincronizacao = codigoSincronizacao;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_ATUALIZACAO_SERV_TERC")
    public Date getDataAtualizacaoSevTerc() {
        return this.dataAtualizacaoSevTerc;
    }

    public void setDataAtualizacaoSevTerc(Date dataAtualizacaoSevTerc) {
        this.dataAtualizacaoSevTerc = dataAtualizacaoSevTerc;
    }

    @Column(name="COD_PROV_SERVICO_REC")
    public Short getCodProvServicoRec() {
        return this.codProvServicoRec;
    }

    public void setCodProvServicoRec(Short codProvServicoRec) {
        this.codProvServicoRec = codProvServicoRec;
    }

    @OneToMany(mappedBy="unidadeFatCliente", cascade={CascadeType.ALL}, orphanRemoval=true)
    public List<TalhaoPropriedade> getTalhoes() {
        return this.talhoes;
    }

    public void setTalhoes(List<TalhaoPropriedade> talhoes) {
        this.talhoes = talhoes;
    }

    @Column(name="CODIGO_SINCRONIZACAO_2", length=100)
    public String getCodigoSincronizacao2() {
        return this.codigoSincronizacao2;
    }

    public void setCodigoSincronizacao2(String codigoSincronizacao2) {
        this.codigoSincronizacao2 = codigoSincronizacao2;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CATEGORIA_PESSOA", foreignKey=@ForeignKey(name="FK_UF_CLIENTE_CAT_PESS"))
    public CategoriaPessoa getCategoriaPessoa() {
        return this.categoriaPessoa;
    }

    public void setCategoriaPessoa(CategoriaPessoa categoriaPessoa) {
        this.categoriaPessoa = categoriaPessoa;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_CATEGORIA_CBS_IBS", foreignKey=@ForeignKey(name="FK_CLIENTE_FAT_CAT_CBS_IBS"))
    public CategoriaCbsIbs getCategoriaCbsIbs() {
        return this.categoriaCbsIbs;
    }

    public void setCategoriaCbsIbs(CategoriaCbsIbs categoriaCbsIbs) {
        this.categoriaCbsIbs = categoriaCbsIbs;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_CONTRIB_CBS_IBS", foreignKey=@ForeignKey(name="FK_CLI_FAT_TIPO_C_CBS_IBS"))
    public TipoContribuinteCbsIbs getTipoContribuinteCbsIbs() {
        return this.tipoContribuinteCbsIbs;
    }

    public void setTipoContribuinteCbsIbs(TipoContribuinteCbsIbs tipoContribuinteCbsIbs) {
        this.tipoContribuinteCbsIbs = tipoContribuinteCbsIbs;
    }
}

