/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.DiaRevisao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Equipamento;
import com.touchcomp.basementor.model.vo.Fabricante;
import com.touchcomp.basementor.model.vo.TipoCarroceriaVeiculo;
import com.touchcomp.basementor.model.vo.TipoRodadoVeiculo;
import com.touchcomp.basementor.model.vo.TipoVeiculo;
import com.touchcomp.basementor.model.vo.TranspAgregadoVeiculo;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;

@Entity
@Table(name="VEICULO", uniqueConstraints={@UniqueConstraint(name="UNQ1_VEICULO", columnNames={"PLACA"}), @UniqueConstraint(name="UNQ3_VEICULO", columnNames={"ID_EQUIPAMENTO"})})
public class Veiculo
implements InterfaceVO {
    private Long identificador;
    private Equipamento equipamento;
    private Fabricante fabricante;
    private DiaRevisao diaRevisao;
    private String placa;
    private String numeroRenavan;
    private String numeroDocumento;
    private String especieTipo;
    private String combustivel;
    private String marcaModelo;
    private String anoFabricacao;
    private String anoModelo;
    private String capPotCil;
    private String categoria;
    private String corPredominante;
    private Short numeroEixos = 0;
    private Date dataCadastro;
    private Empresa empresa;
    private Timestamp dataAtualizacao;
    private Double capVolumetricaTransportada = 0.0;
    private Double capPesoTransportada = 0.0;
    private Double peso = 0.0;
    private TipoVeiculo tipoVeiculo;
    private TipoCarroceriaVeiculo tipoCarroceriaVeiculo;
    private TipoRodadoVeiculo tipoRodadoVeiculo;
    private UnidadeFederativa ufLicenciamento;
    private Long numeroOdometro = 0L;
    private List<TranspAgregadoVeiculo> transpAgregadoVeiculo = new ArrayList<TranspAgregadoVeiculo>();
    private String lotacao;
    private Double pbt = 0.0;
    private Double cmt = 0.0;
    private String chassi;
    private String tecnologia;
    private String idRastreador;
    private String comunicacao;
    private Short ativo = 1;

    @Id
    @Column(nullable=false, name="ID_VEICULO")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_VEICULO")
    public Long getIdentificador() {
        return this.identificador;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.DELETE_ORPHAN, CascadeType.SAVE_UPDATE, CascadeType.ALL})
    @JoinColumn(name="ID_EQUIPAMENTO", foreignKey=@ForeignKey(name="FK_VEICULO_EQUIPAMENTO"))
    public Equipamento getEquipamento() {
        return this.equipamento;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_FABRICANTE", foreignKey=@ForeignKey(name="FK_VEICULO_FABRICANTE"))
    public Fabricante getFabricante() {
        return this.fabricante;
    }

    @Column(nullable=false, name="PLACA", length=8)
    public String getPlaca() {
        return this.placa;
    }

    @Column(nullable=false, name="NUMERO_RENAVAN", length=20)
    public String getNumeroRenavan() {
        return this.numeroRenavan;
    }

    @Column(nullable=false, name="NUMERO_DOCUMENTO", length=20)
    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    @Column(nullable=false, name="ESPECIE_TIPO", length=30)
    public String getEspecieTipo() {
        return this.especieTipo;
    }

    @Column(nullable=false, name="COMBUSTIVEL", length=20)
    public String getCombustivel() {
        return this.combustivel;
    }

    @Column(nullable=false, name="MARCA_MODELO", length=30)
    public String getMarcaModelo() {
        return this.marcaModelo;
    }

    @Column(nullable=false, name="ANO_FABRICACAO", length=4)
    public String getAnoFabricacao() {
        return this.anoFabricacao;
    }

    @Column(nullable=false, name="ANO_MODELO", length=4)
    public String getAnoModelo() {
        return this.anoModelo;
    }

    @Column(nullable=false, name="CAP_POT_CIL", length=20)
    public String getCapPotCil() {
        return this.capPotCil;
    }

    @Column(nullable=false, name="CATEGORIA", length=20)
    public String getCategoria() {
        return this.categoria;
    }

    @Column(nullable=false, name="COR_PREDOMINANTE", length=20)
    public String getCorPredominante() {
        return this.corPredominante;
    }

    @Column(nullable=false, name="NUMERO_EIXOS")
    public Short getNumeroEixos() {
        return this.numeroEixos;
    }

    @Temporal(value=TemporalType.DATE)
    @Column(nullable=false, name="DATA_CADASTRO")
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(nullable=false, name="ID_EMPRESA", foreignKey=@ForeignKey(name="FK_VEICULO_EMPRESA"))
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Version
    @Generated(value=GenerationTime.ALWAYS)
    @Column(nullable=false, updatable=false, insertable=false, name="DATA_ATUALIZACAO")
    public Timestamp getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    public void setEquipamento(Equipamento equipamento) {
        this.equipamento = equipamento;
    }

    public void setFabricante(Fabricante fabricante) {
        this.fabricante = fabricante;
    }

    public void setPlaca(String placa) {
        this.placa = placa;
    }

    public void setNumeroRenavan(String numeroRenavan) {
        this.numeroRenavan = numeroRenavan;
    }

    public void setNumeroDocumento(String numeroDocumento) {
        this.numeroDocumento = numeroDocumento;
    }

    public void setEspecieTipo(String especieTipo) {
        this.especieTipo = especieTipo;
    }

    public void setCombustivel(String combustivel) {
        this.combustivel = combustivel;
    }

    public void setMarcaModelo(String marcaModelo) {
        this.marcaModelo = marcaModelo;
    }

    public void setAnoFabricacao(String anoFabricacao) {
        this.anoFabricacao = anoFabricacao;
    }

    public void setAnoModelo(String anoModelo) {
        this.anoModelo = anoModelo;
    }

    public void setCapPotCil(String capPotCil) {
        this.capPotCil = capPotCil;
    }

    public void setCategoria(String categoria) {
        this.categoria = categoria;
    }

    public void setCorPredominante(String corPredominante) {
        this.corPredominante = corPredominante;
    }

    public void setNumeroEixos(Short numeroEixos) {
        this.numeroEixos = numeroEixos;
    }

    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public void setDataAtualizacao(Timestamp dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getPlaca()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_DIA_REVISAO", foreignKey=@ForeignKey(name="FK_VEICULO_DIA_REVISAO"))
    public DiaRevisao getDiaRevisao() {
        return this.diaRevisao;
    }

    public void setDiaRevisao(DiaRevisao diaRevisao) {
        this.diaRevisao = diaRevisao;
    }

    @Column(name="CAP_VOLUMETRICA_TRANSP", precision=15, scale=4)
    public Double getCapVolumetricaTransportada() {
        return this.capVolumetricaTransportada;
    }

    public void setCapVolumetricaTransportada(Double capVolumetricaTransportada) {
        this.capVolumetricaTransportada = capVolumetricaTransportada;
    }

    @Column(name="PESO", precision=15, scale=4)
    public Double getPeso() {
        return this.peso;
    }

    public void setPeso(Double peso) {
        this.peso = peso;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_VEIC", foreignKey=@ForeignKey(name="FK_VEICULO_0"))
    public TipoVeiculo getTipoVeiculo() {
        return this.tipoVeiculo;
    }

    public void setTipoVeiculo(TipoVeiculo tipoVeiculo) {
        this.tipoVeiculo = tipoVeiculo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_CARROCERIA_VEIC", foreignKey=@ForeignKey(name="FK_VEICULO_TIPO_CARROCERIA_VEIC"))
    public TipoCarroceriaVeiculo getTipoCarroceriaVeiculo() {
        return this.tipoCarroceriaVeiculo;
    }

    public void setTipoCarroceriaVeiculo(TipoCarroceriaVeiculo tipoCarroceriaVeiculo) {
        this.tipoCarroceriaVeiculo = tipoCarroceriaVeiculo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_TIPO_RODADO_VEIC", foreignKey=@ForeignKey(name="FK_VEICULO_TIPO_RODADO_VEICULO"))
    public TipoRodadoVeiculo getTipoRodadoVeiculo() {
        return this.tipoRodadoVeiculo;
    }

    public void setTipoRodadoVeiculo(TipoRodadoVeiculo tipoRodadoVeiculo) {
        this.tipoRodadoVeiculo = tipoRodadoVeiculo;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_UF_LICENCIAMENTO", foreignKey=@ForeignKey(name="FK_VEICULO_UF"))
    public UnidadeFederativa getUfLicenciamento() {
        return this.ufLicenciamento;
    }

    public void setUfLicenciamento(UnidadeFederativa ufLicenciamento) {
        this.ufLicenciamento = ufLicenciamento;
    }

    @Column(name="CAP_PESO_TRANSPORTADA", precision=15, scale=4)
    public Double getCapPesoTransportada() {
        return this.capPesoTransportada;
    }

    public void setCapPesoTransportada(Double capPesoTransportada) {
        this.capPesoTransportada = capPesoTransportada;
    }

    @Column(nullable=false, name="NUMERO_ODOMETRO")
    public Long getNumeroOdometro() {
        return this.numeroOdometro;
    }

    public void setNumeroOdometro(Long numeroOdometro) {
        this.numeroOdometro = numeroOdometro;
    }

    @OneToMany(mappedBy="veiculo")
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<TranspAgregadoVeiculo> getTranspAgregadoVeiculo() {
        return this.transpAgregadoVeiculo;
    }

    public void setTranspAgregadoVeiculo(List<TranspAgregadoVeiculo> transpAgregadoVeiculo) {
        this.transpAgregadoVeiculo = transpAgregadoVeiculo;
    }

    @Column(name="LOTACAO", length=150)
    public String getLotacao() {
        return this.lotacao;
    }

    public void setLotacao(String lotacao) {
        this.lotacao = lotacao;
    }

    @Column(name="PBT", precision=15, scale=4)
    public Double getPbt() {
        return this.pbt;
    }

    public void setPbt(Double pbt) {
        this.pbt = pbt;
    }

    @Column(nullable=false, name="CMT", precision=12, scale=2)
    public Double getCmt() {
        return this.cmt;
    }

    public void setCmt(Double cmt) {
        this.cmt = cmt;
    }

    @Column(name="CHASSI", length=50)
    public String getChassi() {
        return this.chassi;
    }

    public void setChassi(String chassi) {
        this.chassi = chassi;
    }

    @Column(name="TECNOLOGIA", length=500)
    public String getTecnologia() {
        return this.tecnologia;
    }

    public void setTecnologia(String tecnologia) {
        this.tecnologia = tecnologia;
    }

    @Column(name="ID_RASTREADOR", length=500)
    public String getIdRastreador() {
        return this.idRastreador;
    }

    public void setIdRastreador(String idRastreador) {
        this.idRastreador = idRastreador;
    }

    @Column(name="COMUNICACAO", length=500)
    public String getComunicacao() {
        return this.comunicacao;
    }

    public void setComunicacao(String comunicacao) {
        this.comunicacao = comunicacao;
    }

    @Column(name="ATIVO")
    public Short getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Short ativo) {
        this.ativo = ativo;
    }
}

