/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Embalagem;
import com.touchcomp.basementor.model.vo.LacreVolumeNFe;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="VOLUME_NFE")
public class VolumeNFe
implements InterfaceVO {
    private Long identificador;
    private Embalagem embalagem;
    private Long numeroVolume = 0L;
    private Integer quantidade = 0;
    private Double pesoLiquido = 0.0;
    private Double pesoBruto = 0.0;
    private String marca;
    private NotaFiscalPropria notaFiscalPropria;
    private List<LacreVolumeNFe> lacres = new ArrayList<LacreVolumeNFe>();
    private String serialForSinc;

    @Id
    @Column(name="ID_VOLUME_NFE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_VOLUME_NFE")
    public Long getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Column(name="NUMERO_VOLUME")
    public Long getNumeroVolume() {
        return this.numeroVolume;
    }

    public void setNumeroVolume(Long numeroVolume) {
        this.numeroVolume = numeroVolume;
    }

    @Column(nullable=false, name="PESO_LIQUIDO", precision=15, scale=2)
    public Double getPesoLiquido() {
        return this.pesoLiquido;
    }

    public void setPesoLiquido(Double pesoLiquido) {
        this.pesoLiquido = pesoLiquido;
    }

    @Column(nullable=false, name="PESO_BRUTO", precision=15, scale=2)
    public Double getPesoBruto() {
        return this.pesoBruto;
    }

    public void setPesoBruto(Double pesoBruto) {
        this.pesoBruto = pesoBruto;
    }

    @JoinColumn(name="ID_EMBALAGEM", foreignKey=@ForeignKey(name="FK_VOLUME_NFE_EMBALAGEM"))
    @ManyToOne(fetch=FetchType.LAZY)
    public Embalagem getEmbalagem() {
        return this.embalagem;
    }

    public void setEmbalagem(Embalagem embalagem) {
        this.embalagem = embalagem;
    }

    @Column(name="QUANTIDADE", precision=15, scale=2)
    public Integer getQuantidade() {
        return this.quantidade;
    }

    public void setQuantidade(Integer quantidade) {
        this.quantidade = quantidade;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_NOTA_FISCAL_PROPRIA", foreignKey=@ForeignKey(name="FK_VOLUME_NFE_NP"))
    public NotaFiscalPropria getNotaFiscalPropria() {
        return this.notaFiscalPropria;
    }

    public void setNotaFiscalPropria(NotaFiscalPropria notaFiscalPropria) {
        this.notaFiscalPropria = notaFiscalPropria;
    }

    @Column(name="MARCA", length=75)
    public String getMarca() {
        return this.marca;
    }

    public void setMarca(String marca) {
        this.marca = marca;
    }

    @OneToMany(mappedBy="volumeNFe", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL})
    public List<LacreVolumeNFe> getLacres() {
        return this.lacres;
    }

    public void setLacres(List<LacreVolumeNFe> lacres) {
        this.lacres = lacres;
    }

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Column(name="SERIAL_FOR_SINC")
    public String getSerialForSinc() {
        return this.serialForSinc;
    }

    public void setSerialForSinc(String serialForSinc) {
        this.serialForSinc = serialForSinc;
    }
}

