/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.model.vo;

import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Requisicao;
import com.touchcomp.basementor.model.vo.TransferenciaCentroEstoque;
import com.touchcomp.basementor.model.vo.WmsSaidaEstoqueItem;
import com.touchcomp.basementor.model.vo.WmsSeparacaoPedido;
import com.touchcomp.basementortools.tools.vo.ToolBaseMethodsVO;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Version;
import lombok.Generated;
import org.hibernate.annotations.Cascade;

@Entity
@Table(name="WMS_SAIDA_ESTOQUE")
public class WmsSaidaEstoque
implements InterfaceVO {
    @Id
    @Column(name="ID_WMS_SAIDA_ESTOQUE")
    @GeneratedValue(generator="sequence", strategy=GenerationType.AUTO)
    @SequenceGenerator(name="sequence", sequenceName="GEN_WMS_SAIDA_ESTOQUE")
    private Long identificador;
    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_CADASTRO", nullable=true, unique=false)
    private Date dataCadastro;
    @Version
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="DATA_ATUALIZACAO", nullable=true, unique=false)
    private Date dataAtualizacao;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ID_EMPRESA", nullable=true, unique=false, foreignKey=@ForeignKey(name="FK_WMS_SAI_EST_EMPRESA"))
    private Empresa empresa;
    @Temporal(value=TemporalType.DATE)
    @Column(name="DATA_SAIDA", nullable=true, unique=false)
    private Date dataSaida;
    @Column(name="OBSERVACAO", nullable=true, unique=false, length=500)
    private String observacao;
    @OneToMany(mappedBy="wmsSaidaEstoque", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<WmsSaidaEstoqueItem> itens = new LinkedList<WmsSaidaEstoqueItem>();
    @Column(name="PESO_TOTAL", scale=15, precision=6)
    private Double pesoTotal = 0.0;
    @Column(name="VOLUME_TOTAL", scale=15, precision=6)
    private Double volumeTotal = 0.0;
    @Column(name="QUANTIDADE_TOTAL", scale=15, precision=6)
    private Double quantidadeTotal = 0.0;
    @Column(name="DESCRICAO", length=500)
    private String descricao;
    @OneToOne(mappedBy="wmsSaidaEstoque", cascade={CascadeType.ALL}, orphanRemoval=true)
    private TransferenciaCentroEstoque transfCentroEstocagem;
    @OneToOne(mappedBy="wmsSaidaEstoque")
    private WmsSeparacaoPedido wmsSeparacaoPedido;
    @ManyToOne(fetch=FetchType.LAZY)
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN, org.hibernate.annotations.CascadeType.ALL})
    @JoinColumn(name="ID_REQUISICAO", foreignKey=@ForeignKey(name="FK_WMS_SAI_EST_REQUISICAO"))
    private Requisicao baixaEfetiva;

    public boolean equals(Object other) {
        return ToolBaseMethodsVO.equalsVO((Object)this, (Object)other);
    }

    public String toString() {
        return ToolBaseMethodsVO.toString((String)"{0}", (Object[])new Object[]{this.getIdentificador()});
    }

    public int hashCode() {
        return ToolBaseMethodsVO.hashCode((Number)this.getIdentificador());
    }

    @Generated
    public void setIdentificador(Long identificador) {
        this.identificador = identificador;
    }

    @Generated
    public void setDataCadastro(Date dataCadastro) {
        this.dataCadastro = dataCadastro;
    }

    @Generated
    public void setDataAtualizacao(Date dataAtualizacao) {
        this.dataAtualizacao = dataAtualizacao;
    }

    @Generated
    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    @Generated
    public void setDataSaida(Date dataSaida) {
        this.dataSaida = dataSaida;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setItens(List<WmsSaidaEstoqueItem> itens) {
        this.itens = itens;
    }

    @Generated
    public void setPesoTotal(Double pesoTotal) {
        this.pesoTotal = pesoTotal;
    }

    @Generated
    public void setVolumeTotal(Double volumeTotal) {
        this.volumeTotal = volumeTotal;
    }

    @Generated
    public void setQuantidadeTotal(Double quantidadeTotal) {
        this.quantidadeTotal = quantidadeTotal;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setTransfCentroEstocagem(TransferenciaCentroEstoque transfCentroEstocagem) {
        this.transfCentroEstocagem = transfCentroEstocagem;
    }

    @Generated
    public void setWmsSeparacaoPedido(WmsSeparacaoPedido wmsSeparacaoPedido) {
        this.wmsSeparacaoPedido = wmsSeparacaoPedido;
    }

    @Generated
    public void setBaixaEfetiva(Requisicao baixaEfetiva) {
        this.baixaEfetiva = baixaEfetiva;
    }

    @Generated
    public Long getIdentificador() {
        return this.identificador;
    }

    @Generated
    public Date getDataCadastro() {
        return this.dataCadastro;
    }

    @Generated
    public Date getDataAtualizacao() {
        return this.dataAtualizacao;
    }

    @Generated
    public Empresa getEmpresa() {
        return this.empresa;
    }

    @Generated
    public Date getDataSaida() {
        return this.dataSaida;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public List<WmsSaidaEstoqueItem> getItens() {
        return this.itens;
    }

    @Generated
    public Double getPesoTotal() {
        return this.pesoTotal;
    }

    @Generated
    public Double getVolumeTotal() {
        return this.volumeTotal;
    }

    @Generated
    public Double getQuantidadeTotal() {
        return this.quantidadeTotal;
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public TransferenciaCentroEstoque getTransfCentroEstocagem() {
        return this.transfCentroEstocagem;
    }

    @Generated
    public WmsSeparacaoPedido getWmsSeparacaoPedido() {
        return this.wmsSeparacaoPedido;
    }

    @Generated
    public Requisicao getBaixaEfetiva() {
        return this.baixaEfetiva;
    }
}

