/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.rules.totalizadoresitemgrade;

import com.touchcomp.basementor.rules.totalizadoresitemgrade.InterfaceTot;
import com.touchcomp.basementor.rules.totalizadoresitemgrade.InterfaceTotItem;
import com.touchcomp.basementor.rules.totalizadoresitemgrade.InterfaceTotItemGrade;
import com.touchcomp.basementor.rules.totalizadoresitemgrade.model.TotalGeralItens;
import com.touchcomp.basementor.rules.totalizadoresitemgrade.model.TotalItem;
import com.touchcomp.basementor.rules.totalizadoresitemgrade.model.TotalItemGrade;
import com.touchcomp.basementor.rules.totalizadoresitemgrade.model.TotalItemGradeLoteFabricacao;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class CompTotaisItemGrade {
    public TotalItem getTotais(InterfaceTotItem interfaceTotItem) {
        double qtd = 0.0;
        double pesoLiquido = 0.0;
        double pesoBruto = 0.0;
        double volume = 0.0;
        for (InterfaceTotItemGrade interfaceTotItemGrade : interfaceTotItem.getGrades()) {
            TotalItemGrade t = this.getTotaisGrade(interfaceTotItemGrade);
            qtd += t.getQuantidadeTotal().doubleValue();
            pesoLiquido += t.getPesoLiquido().doubleValue();
            pesoBruto += t.getPesoBruto().doubleValue();
            volume += t.getVolumeTotal().doubleValue();
        }
        TotalItem t = new TotalItem(interfaceTotItem.getProduto(), qtd, pesoBruto, pesoLiquido, volume);
        return t;
    }

    public TotalGeralItens getTotaisByItens(List<? extends InterfaceTotItem> interfaceTotItem) {
        double qtd = 0.0;
        double pesoBruto = 0.0;
        double pesoLiquido = 0.0;
        double volume = 0.0;
        List<TotalItemGrade> tots = this.getTotaisGrades(interfaceTotItem);
        for (TotalItemGrade grade : tots) {
            qtd += grade.getQuantidadeTotal().doubleValue();
            pesoBruto += grade.getPesoBruto().doubleValue();
            pesoLiquido += grade.getPesoLiquido().doubleValue();
            volume += grade.getVolumeTotal().doubleValue();
        }
        TotalGeralItens t = new TotalGeralItens(qtd, pesoBruto, pesoLiquido, volume);
        return t;
    }

    public TotalGeralItens getTotaisByGrades(List<? extends InterfaceTotItemGrade> aux) {
        double qtd = 0.0;
        double pesoBruto = 0.0;
        double pesoLiquido = 0.0;
        double volume = 0.0;
        List<TotalItemGrade> tots = this.getTotaisGrades(aux, new LinkedList<TotalItemGrade>());
        for (TotalItemGrade grade : tots) {
            qtd += grade.getQuantidadeTotal().doubleValue();
            pesoBruto += grade.getPesoBruto().doubleValue();
            pesoLiquido += grade.getPesoLiquido().doubleValue();
            volume += grade.getVolumeTotal().doubleValue();
        }
        TotalGeralItens t = new TotalGeralItens(qtd, pesoBruto, pesoLiquido, volume);
        return t;
    }

    public List<TotalItemGrade> getTotaisGrades(List<? extends InterfaceTotItem> totItem) {
        LinkedList<TotalItemGrade> aux = new LinkedList<TotalItemGrade>();
        for (InterfaceTotItem interfaceTotItem : totItem) {
            this.getTotaisGrades(interfaceTotItem.getGrades(), aux);
        }
        return aux;
    }

    public List<TotalItemGrade> getTotaisGrades(InterfaceTotItem interfaceTotItem) {
        LinkedList<TotalItemGrade> aux = new LinkedList<TotalItemGrade>();
        return this.getTotaisGrades(interfaceTotItem.getGrades(), aux);
    }

    public List<TotalItemGrade> getTotaisGrades(List<? extends InterfaceTotItemGrade> grades, List<TotalItemGrade> aux) {
        for (InterfaceTotItemGrade interfaceTotItemGrade : grades) {
            Optional<TotalItemGrade> found = aux.stream().filter(i -> TMethods.isEquals((Object)i.getGradeCor(), (Object)grade.getGradeCor())).findFirst();
            if (found.isPresent()) {
                TotalItemGrade t = this.getTotaisGrade(interfaceTotItemGrade);
                found.get().setQuantidadeTotal(found.get().getQuantidadeTotal() + t.getQuantidadeTotal());
                found.get().setVolumeTotal(found.get().getVolumeTotal() + t.getVolumeTotal());
                found.get().setPesoLiquido(found.get().getPesoLiquido() + t.getPesoLiquido());
                found.get().setPesoBruto(found.get().getPesoBruto() + t.getPesoBruto());
                continue;
            }
            aux.add(this.getTotaisGrade(interfaceTotItemGrade));
        }
        return aux;
    }

    public List<TotalItemGradeLoteFabricacao> getTotaisGradesLoteFabricacao(InterfaceTot vo) {
        LinkedList<TotalItemGradeLoteFabricacao> itens = new LinkedList<TotalItemGradeLoteFabricacao>();
        for (InterfaceTotItem interfaceTotItem : vo.getItens()) {
            this.getTotaisGradesLoteFabricacao(interfaceTotItem.getGrades(), itens);
        }
        return itens;
    }

    public List<TotalItemGradeLoteFabricacao> getTotaisGradesLoteFabricacao(List<? extends InterfaceTotItemGrade> grades, List<TotalItemGradeLoteFabricacao> aux) {
        for (InterfaceTotItemGrade interfaceTotItemGrade : grades) {
            Optional<TotalItemGradeLoteFabricacao> found = aux.stream().filter(i -> TMethods.isEquals((Object)i.getGradeCor(), (Object)grade.getGradeCor()) && TMethods.isEquals((Object)i.getLoteFabricacao(), (Object)grade.getLoteFabricacao())).findFirst();
            if (found.isPresent()) {
                TotalItemGrade t = this.getTotaisGrade(interfaceTotItemGrade);
                found.get().setQuantidadeTotal(found.get().getQuantidadeTotal() + t.getQuantidadeTotal());
                found.get().setVolumeTotal(found.get().getVolumeTotal() + t.getVolumeTotal());
                found.get().setPesoLiquido(found.get().getPesoLiquido() + t.getPesoLiquido());
                found.get().setPesoBruto(found.get().getPesoBruto() + t.getPesoBruto());
                continue;
            }
            aux.add(this.getTotaisGradeLoteFabricacao(interfaceTotItemGrade));
        }
        return aux;
    }

    public TotalItemGrade getTotaisGrade(InterfaceTotItemGrade grade) {
        Double qtd = TMethods.isNulThen0((Number)grade.getQuantidade());
        Double vol = TMethods.isNulThen0((Number)grade.getGradeCor().getProdutoGrade().getProduto().getVolume());
        Double pesoLiquido = TMethods.isNulThen0((Number)grade.getGradeCor().getProdutoGrade().getProduto().getPesoUnitario());
        Double pesoBrupo = TMethods.isNulThen0((Number)grade.getGradeCor().getProdutoGrade().getProduto().getPesoUnitario()) + TMethods.isNulThen0((Number)grade.getGradeCor().getProdutoGrade().getProduto().getPesoEmbalagem());
        return new TotalItemGrade(grade.getGradeCor(), qtd, pesoBrupo * qtd, pesoLiquido * qtd, vol * qtd);
    }

    public TotalItemGradeLoteFabricacao getTotaisGradeLoteFabricacao(InterfaceTotItemGrade grade) {
        Double qtd = TMethods.isNulThen0((Number)grade.getQuantidade());
        Double vol = TMethods.isNulThen0((Number)grade.getGradeCor().getProdutoGrade().getProduto().getVolume());
        Double pesoLiquido = TMethods.isNulThen0((Number)grade.getGradeCor().getProdutoGrade().getProduto().getPesoUnitario());
        Double pesoBrupo = TMethods.isNulThen0((Number)grade.getGradeCor().getProdutoGrade().getProduto().getPesoUnitario()) + TMethods.isNulThen0((Number)grade.getGradeCor().getProdutoGrade().getProduto().getPesoEmbalagem());
        return new TotalItemGradeLoteFabricacao(grade.getGradeCor(), grade.getLoteFabricacao(), qtd, pesoBrupo * qtd, pesoLiquido * qtd, vol * qtd);
    }

    public void calcularTotalizadores(InterfaceTot aux) {
        for (InterfaceTotItem interfaceTotItem : aux.getItens()) {
            for (InterfaceTotItemGrade interfaceTotItemGrade : interfaceTotItem.getGrades()) {
                TotalItemGrade tg = this.getTotaisGrade(interfaceTotItemGrade);
                interfaceTotItemGrade.setVolume(tg.getVolumeTotal());
                interfaceTotItemGrade.setPesoLiquido(tg.getPesoLiquido());
                interfaceTotItemGrade.setPesoBruto(tg.getPesoBruto());
            }
            TotalGeralItens ti = this.getTotaisByGrades(interfaceTotItem.getGrades());
            interfaceTotItem.setQuantidadeTotal(ti.getQuantidadeTotal());
            interfaceTotItem.setVolumeTotal(ti.getVolumeTotal());
            interfaceTotItem.setPesoBrutoTotal(ti.getPesoBrutoTotal());
            interfaceTotItem.setPesoLiquidoTotal(ti.getPesoLiquidoTotal());
        }
        TotalGeralItens tg = this.getTotaisByItens(aux.getItens());
        aux.setQuantidadeTotal(tg.getQuantidadeTotal());
        aux.setPesoBrutoTotal(tg.getPesoBrutoTotal());
        aux.setPesoLiquidoTotal(tg.getPesoLiquidoTotal());
        aux.setVolumeTotal(tg.getVolumeTotal());
    }
}

