/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.rules.totalizadoresitemgrade;

import com.touchcomp.basementor.rules.totalizadoresitemgrade.model.TotalItemDiferencas;
import com.touchcomp.basementor.rules.totalizadoresitemgrade.model.TotalItemGradeLoteFabricacao;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;

class CompTotaisItemGradeComparer {
    CompTotaisItemGradeComparer() {
    }

    public boolean isEquals(List<TotalItemGradeLoteFabricacao> itensEnt, List<TotalItemGradeLoteFabricacao> itens) {
        if (itensEnt == null && itens == null) {
            return true;
        }
        if (itensEnt == null || itens == null) {
            return false;
        }
        return this.getItensComDiferenca(itensEnt, itens).isEmpty();
    }

    public List<TotalItemDiferencas<TotalItemGradeLoteFabricacao>> getItensComDiferenca(List<TotalItemGradeLoteFabricacao> itensEnt, List<TotalItemGradeLoteFabricacao> itens) {
        LinkedList<TotalItemDiferencas<TotalItemGradeLoteFabricacao>> ret = new LinkedList<TotalItemDiferencas<TotalItemGradeLoteFabricacao>>();
        if (itensEnt == null) {
            itensEnt = new LinkedList<TotalItemGradeLoteFabricacao>();
        }
        if (itens == null) {
            itens = new LinkedList<TotalItemGradeLoteFabricacao>();
        }
        itens = this.sumIt(itens);
        itensEnt = this.sumIt(itensEnt);
        for (TotalItemGradeLoteFabricacao t : itensEnt) {
            ret.add(new TotalItemDiferencas<TotalItemGradeLoteFabricacao>(t, t.getQuantidadeTotal()));
        }
        for (TotalItemGradeLoteFabricacao item : itens) {
            Optional<TotalItemDiferencas> found = ret.stream().filter(i -> TMethods.isEquals((Object)((TotalItemGradeLoteFabricacao)i.getSource()).getGradeCor(), (Object)item.getGradeCor()) && TMethods.isEquals((Object)((TotalItemGradeLoteFabricacao)i.getSource()).getLoteFabricacao(), (Object)item.getLoteFabricacao())).findFirst();
            if (found.isPresent()) {
                found.get().setQuantidadeDestino(item.getQuantidadeTotal() + found.get().getQuantidadeDestino());
                continue;
            }
            ret.add(new TotalItemDiferencas<TotalItemGradeLoteFabricacao>(item, 0.0, item.getQuantidadeTotal()));
        }
        ret.forEach(i -> i.setQuantidadeDiferenca(ToolFormatter.arrredondarNumero((Double)(i.getQuantidadeOrigem() - i.getQuantidadeDestino()), (int)6)));
        ret.removeIf(i -> i.getQuantidadeDiferenca() == 0.0);
        return ret;
    }

    private List<TotalItemGradeLoteFabricacao> sumIt(List<TotalItemGradeLoteFabricacao> itens) {
        LinkedList<TotalItemGradeLoteFabricacao> aux = new LinkedList<TotalItemGradeLoteFabricacao>();
        for (TotalItemGradeLoteFabricacao item : itens) {
            Optional<TotalItemGradeLoteFabricacao> found = aux.stream().filter(i -> TMethods.isEquals((Object)i.getGradeCor(), (Object)item.getGradeCor()) && TMethods.isEquals((Object)i.getLoteFabricacao(), (Object)item.getLoteFabricacao())).findFirst();
            if (found.isPresent()) {
                TotalItemGradeLoteFabricacao t = found.get();
                t.setPesoBruto(t.getPesoBruto() + item.getPesoBruto());
                t.setPesoLiquido(t.getPesoLiquido() + item.getPesoLiquido());
                t.setQuantidadeTotal(t.getQuantidadeTotal() + item.getQuantidadeTotal());
                t.setVolumeTotal(t.getVolumeTotal() + item.getVolumeTotal());
                continue;
            }
            aux.add(new TotalItemGradeLoteFabricacao(item));
        }
        return aux;
    }
}

