/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementor.rules.usuariobasico;

import com.touchcomp.basementor.model.vo.OpcoesSistLogin;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementortools.tools.methods.TMethods;
import edu.vt.middleware.password.AlphabeticalSequenceRule;
import edu.vt.middleware.password.CharacterCharacteristicsRule;
import edu.vt.middleware.password.DigitCharacterRule;
import edu.vt.middleware.password.LengthRule;
import edu.vt.middleware.password.LowercaseCharacterRule;
import edu.vt.middleware.password.MessageResolver;
import edu.vt.middleware.password.NonAlphanumericCharacterRule;
import edu.vt.middleware.password.NumericalSequenceRule;
import edu.vt.middleware.password.Password;
import edu.vt.middleware.password.PasswordData;
import edu.vt.middleware.password.PasswordValidator;
import edu.vt.middleware.password.QwertySequenceRule;
import edu.vt.middleware.password.RepeatCharacterRegexRule;
import edu.vt.middleware.password.Rule;
import edu.vt.middleware.password.RuleResult;
import edu.vt.middleware.password.UppercaseCharacterRule;
import edu.vt.middleware.password.WhitespaceRule;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.springframework.stereotype.Component;

@Component
public class CompUsuarioBasico {
    public PasswordCheckResult checkUserPassword(OpcoesSistLogin opcoesSistLogin, String password) {
        PasswordCheckResult pres = new PasswordCheckResult(true);
        if (opcoesSistLogin == null) {
            return pres;
        }
        if (!TMethods.isStrWithData((String)password)) {
            pres.setIsPassed(false);
            return pres;
        }
        if (!TMethods.isAffirmative((Number)opcoesSistLogin.getHabilitarVerificacaoSenha())) {
            return pres;
        }
        PasswordValidator validator = CompUsuarioBasico.getValidator(opcoesSistLogin);
        PasswordData passwordData = new PasswordData(new Password(password));
        RuleResult result = validator.validate(passwordData);
        pres.setIsPassed(result.isValid());
        pres.setMessages(validator.getMessages(result));
        return pres;
    }

    private static PasswordValidator getValidator(OpcoesSistLogin opcoesSistLogin) {
        Properties props = new Properties();
        InputStream is = MessagesBaseMentor.getResourceBundleMessageValSenha();
        if (is != null) {
            try {
                props.load(is);
                MessageResolver resolver = new MessageResolver(props);
                PasswordValidator validator = new PasswordValidator(resolver, CompUsuarioBasico.getRulesList(opcoesSistLogin));
                return validator;
            }
            catch (IOException ex) {
                TLogger.get(CompUsuarioBasico.class).error((Throwable)ex);
            }
        }
        PasswordValidator validator = new PasswordValidator(CompUsuarioBasico.getRulesList(opcoesSistLogin));
        return validator;
    }

    private static List<Rule> getRulesList(OpcoesSistLogin opcoesSistLogin) {
        ArrayList<Rule> ruleList = new ArrayList<Rule>();
        if (TMethods.isWithData((Number)opcoesSistLogin.getNrMinTamanhoSenha()) && TMethods.isWithData((Number)opcoesSistLogin.getNrMaxTamanhoSenha()) && opcoesSistLogin.getNrMaxTamanhoSenha() > opcoesSistLogin.getNrMinTamanhoSenha()) {
            LengthRule lengthRule = new LengthRule((int)opcoesSistLogin.getNrMinTamanhoSenha().shortValue(), (int)opcoesSistLogin.getNrMaxTamanhoSenha().shortValue());
            ruleList.add((Rule)lengthRule);
        }
        if (TMethods.isAffirmative((Number)opcoesSistLogin.getNaoPermitirEspacosSenha())) {
            WhitespaceRule whitespaceRule = new WhitespaceRule();
            ruleList.add((Rule)whitespaceRule);
        }
        CharacterCharacteristicsRule charRule = new CharacterCharacteristicsRule();
        if (TMethods.isWithData((Number)opcoesSistLogin.getNrMinDigitosSenha())) {
            charRule.getRules().add(new DigitCharacterRule((int)opcoesSistLogin.getNrMinDigitosSenha().shortValue()));
        }
        if (TMethods.isWithData((Number)opcoesSistLogin.getNrMinCaracteresSenha())) {
            charRule.getRules().add(new NonAlphanumericCharacterRule((int)opcoesSistLogin.getNrMinCaracteresSenha().shortValue()));
        }
        if (TMethods.isWithData((Number)opcoesSistLogin.getNrMinCaracteresMaisculosSenha())) {
            charRule.getRules().add(new UppercaseCharacterRule(1));
        }
        if (TMethods.isWithData((Number)opcoesSistLogin.getNrMinCaracteresMinusculosSenha())) {
            charRule.getRules().add(new LowercaseCharacterRule(1));
        }
        if (TMethods.isWithData((Number)opcoesSistLogin.getNaoPermitirSequenciasCaracteres())) {
            AlphabeticalSequenceRule alphaSeqRule = new AlphabeticalSequenceRule();
            ruleList.add((Rule)alphaSeqRule);
        }
        if (TMethods.isWithData((Number)opcoesSistLogin.getNrMinDigitosSequenciaSenha())) {
            NumericalSequenceRule numSeqRule = new NumericalSequenceRule((int)opcoesSistLogin.getNrMinDigitosSequenciaSenha().shortValue(), true);
            ruleList.add((Rule)numSeqRule);
        }
        if (TMethods.isWithData((Number)opcoesSistLogin.getNaoPermitirSequenciasQwerty())) {
            QwertySequenceRule qwertySeqRule = new QwertySequenceRule();
            ruleList.add((Rule)qwertySeqRule);
        }
        if (TMethods.isWithData((Number)opcoesSistLogin.getNrMinRepeticaoCaracteresSenha())) {
            RepeatCharacterRegexRule repeatRule = new RepeatCharacterRegexRule((int)opcoesSistLogin.getNrMinRepeticaoCaracteresSenha().shortValue());
            ruleList.add((Rule)repeatRule);
        }
        if (!charRule.getRules().isEmpty()) {
            ruleList.add((Rule)charRule);
        }
        return ruleList;
    }

    public static class PasswordCheckResult {
        private boolean isPassed;
        private List<String> messages;

        public PasswordCheckResult(boolean isPassed) {
            this.isPassed = isPassed;
        }

        public boolean isIsPassed() {
            return this.isPassed;
        }

        public void setIsPassed(boolean isPassed) {
            this.isPassed = isPassed;
        }

        public List<String> getMessages() {
            return this.messages;
        }

        public void setMessages(List<String> messages) {
            this.messages = messages;
        }

        public String toString() {
            return "passed: " + this.isPassed;
        }
    }
}

