/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.constants;

public enum BankType {
    BANCO_DO_BRASIL("001", "Banco do Brasil"),
    ITAU("341", "Banco Ita\u00fa"),
    BRADESCO("237", "Banco Bradesco"),
    SANTANDER("033", "Banco Santander"),
    CAIXA_ECONOMICA("104", "Caixa Econ\u00f4mica Federal"),
    INTER("077", "Banco Inter"),
    NUBANK("260", "Nubank"),
    BTG_PACTUAL("208", "Banco BTG Pactual"),
    ORIGINAL("212", "Banco Original"),
    SAFRA("422", "Banco Safra"),
    PAN("623", "Banco Pan"),
    MERCANTIL("389", "Banco Mercantil do Brasil"),
    BMG("318", "Banco BMG"),
    DAYCOVAL("707", "Banco Daycoval"),
    C6("336", "Banco C6"),
    MODAL("746", "Banco Modal"),
    VOTORANTIM("655", "Banco Votorantim"),
    SICOOB("756", "Banco Cooperativo do Brasil - Sicoob"),
    SICREDI("748", "Banco Cooperativo Sicredi"),
    BANRISUL("041", "Banco do Estado do Rio Grande do Sul"),
    BANESTES("021", "Banco do Estado do Esp\u00edrito Santo"),
    BASA("003", "Banco da Amazonia"),
    NORDESTE("004", "Banco do Nordeste"),
    CITIBANK("745", "Banco Citibank"),
    BNP_PARIBAS("752", "Banco BNP Paribas"),
    JP_MORGAN("376", "Banco JP Morgan"),
    CREDIT_SUISSE("505", "Banco Credit Suisse"),
    ABC_BRASIL("246", "Banco ABC Brasil"),
    AGIBANK("121", "Banco Agibank"),
    MERCEDES_BENZ("366", "Banco Mercedes-Benz"),
    MORGAN_STANLEY("376", "Banco Morgan Stanley"),
    OURINVEST("712", "Banco Ourinvest");

    private final String code;
    private final String name;

    private BankType(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public static BankType get(String code) {
        for (BankType bank : BankType.values()) {
            if (!bank.getCode().equals(code)) continue;
            return bank;
        }
        throw new IllegalArgumentException("Invalid bank code: " + code);
    }
}

