/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorbanks.constants;

import com.touchcomp.basementorbanks.exceptions.BankRuntimeException;

public enum CharsetType {
    UTF8("UTF-8", "UTF-8"),
    UTF16("UTF-16", "UTF-16"),
    ISO88591("ISO-8859-1", "ISO-8859-1"),
    USASCII("US-ASCII", "US-ASCII"),
    ANSI("windows-1252", "ANSI");

    private String value;
    private String descricao;

    private CharsetType(String valor, String descricao) {
        this.value = valor;
        this.descricao = descricao;
    }

    public static CharsetType get(String value) {
        for (CharsetType value1 : CharsetType.values()) {
            if (!String.valueOf(value).equalsIgnoreCase(String.valueOf(value1.getValue()))) continue;
            return value1;
        }
        throw new BankRuntimeException("E.BANK.000012", value);
    }

    public String toString() {
        return this.getDescricao();
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }
}

